/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.rule.DialectRuntimeData;
import org.drools.core.rule.DialectRuntimeRegistry;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.Wireable;
import org.drools.mvel.expr.MVELCompileable;
import org.mvel2.ParserConfiguration;
import org.mvel2.ast.Function;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.impl.MapVariableResolverFactory;

public class MVELDialectRuntimeData
implements DialectRuntimeData,
Externalizable {
    private static final long serialVersionUID = 510L;
    private final MapFunctionResolverFactory functionFactory = new MapFunctionResolverFactory();
    private Map<Wireable, List<MVELCompileable>> invokerLookups = Collections.synchronizedMap(new IdentityHashMap());
    private Set<MVELCompileable> mvelReaders = ConcurrentHashMap.newKeySet();
    private ClassLoader rootClassLoader;
    private DialectRuntimeRegistry registry;
    private List<Wireable> wireList = Collections.emptyList();
    private Map<String, Object> imports = new HashMap<String, Object>();
    private HashSet<String> packageImports = new HashSet();
    private ParserConfiguration parserConfiguration;
    private boolean dirty;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        for (Map.Entry<String, Object> entry : this.imports.entrySet()) {
            if (entry.getValue() instanceof Method) {
                entry.setValue("m:" + ((Method)entry.getValue()).getDeclaringClass().getName());
                continue;
            }
            if (!(entry.getValue() instanceof Field)) continue;
            entry.setValue("f:" + ((Field)entry.getValue()).getDeclaringClass().getName());
        }
        out.writeObject(this.imports);
        out.writeObject(this.packageImports);
        out.writeObject(this.invokerLookups);
        out.writeObject(this.mvelReaders);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.imports = (Map)in.readObject();
        this.packageImports = (HashSet)in.readObject();
        this.invokerLookups = (Map)in.readObject();
        if (!this.invokerLookups.isEmpty()) {
            this.wireList = new ArrayList<Wireable>(this.invokerLookups.keySet());
        }
        this.mvelReaders = (Set)in.readObject();
    }

    public void merge(DialectRuntimeRegistry registry, DialectRuntimeData newData) {
        this.merge(registry, newData, false);
    }

    public void merge(DialectRuntimeRegistry registry, DialectRuntimeData newData, boolean excludeClasses) {
        MVELDialectRuntimeData other = (MVELDialectRuntimeData)newData;
        for (Map.Entry<String, Object> entry : other.imports.entrySet()) {
            if (entry.getValue() instanceof Class) {
                if (this.imports.containsKey(entry.getKey())) continue;
                this.imports.put(entry.getKey(), ((Class)entry.getValue()).getName());
                continue;
            }
            if (entry.getValue() instanceof Method) {
                this.imports.put(entry.getKey(), "m:" + ((Method)entry.getValue()).getDeclaringClass().getName());
                continue;
            }
            this.imports.put(entry.getKey(), entry.getValue());
        }
        this.packageImports.addAll(other.packageImports);
        for (Map.Entry<String, Object> entry : other.invokerLookups.entrySet()) {
            this.invokerLookups.put((Wireable)entry.getKey(), (List)entry.getValue());
            if (this.wireList == Collections.emptyList()) {
                this.wireList = new ArrayList<Wireable>();
            }
            this.wireList.add((Wireable)entry.getKey());
        }
        if (this.mvelReaders == null) {
            this.mvelReaders = new HashSet<MVELCompileable>();
        }
        this.mvelReaders.addAll(other.mvelReaders);
    }

    public DialectRuntimeData clone(DialectRuntimeRegistry registry, ClassLoader rootClassLoader) {
        return this.clone(registry, rootClassLoader, false);
    }

    public DialectRuntimeData clone(DialectRuntimeRegistry registry, ClassLoader rootClassLoader, boolean excludeClasses) {
        MVELDialectRuntimeData clone = new MVELDialectRuntimeData();
        clone.rootClassLoader = rootClassLoader;
        clone.merge(registry, this, excludeClasses);
        clone.onAdd(registry, rootClassLoader);
        return clone;
    }

    public void onAdd(DialectRuntimeRegistry registry, ClassLoader rootClassLoader) {
        this.rootClassLoader = rootClassLoader;
        this.registry = registry;
    }

    public void onRemove() {
    }

    public void onBeforeExecute() {
        for (Wireable target : this.wireList) {
            for (MVELCompileable compileable : this.invokerLookups.get(target)) {
                compileable.compile(this);
                target.wire((Object)compileable);
            }
        }
        this.wireList.clear();
        for (MVELCompileable compileable : this.mvelReaders) {
            compileable.compile(this);
        }
        if (this.dirty) {
            this.rewireImportedMethods();
            this.dirty = false;
        }
    }

    private void rewireImportedMethods() {
        if (this.imports != null) {
            HashMap<String, Method> rewiredMethod = new HashMap<String, Method>();
            block2: for (Object imp : this.imports.values()) {
                if (!(imp instanceof Method)) continue;
                Method method = (Method)imp;
                try {
                    Class<?> c = Class.forName(method.getDeclaringClass().getName(), false, this.getPackageClassLoader());
                    for (Method m : c.getDeclaredMethods()) {
                        if (!method.getName().equals(m.getName()) || method.getParameterTypes().length != m.getParameterTypes().length) continue;
                        rewiredMethod.put(m.getName(), m);
                        continue block2;
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            this.imports.putAll(rewiredMethod);
        }
    }

    public MapFunctionResolverFactory getFunctionFactory() {
        return this.functionFactory;
    }

    public void removeRule(KnowledgePackageImpl pkg, RuleImpl rule) {
    }

    public void addFunction(Function function) {
        this.functionFactory.addFunction(function);
    }

    public void removeFunction(KnowledgePackageImpl pkg, org.drools.core.rule.Function function) {
        this.functionFactory.removeFunction(function.getName());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void reload() {
    }

    public ParserConfiguration getParserConfiguration() {
        if (this.parserConfiguration == null) {
            ClassLoader packageClassLoader = this.getPackageClassLoader();
            String key = null;
            Object value = null;
            try {
                block2: for (Map.Entry<String, Object> entry : this.imports.entrySet()) {
                    Class<?> cls;
                    key = entry.getKey();
                    value = entry.getValue();
                    if (!(entry.getValue() instanceof String)) continue;
                    String str = (String)value;
                    if (str.startsWith("m:")) {
                        cls = packageClassLoader.loadClass(str.substring(2));
                        for (Method method : cls.getDeclaredMethods()) {
                            if (!method.getName().equals(key)) continue;
                            entry.setValue(method);
                            continue block2;
                        }
                        continue;
                    }
                    cls = packageClassLoader.loadClass(str);
                    entry.setValue(cls);
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Unable to resolve method of field: " + key + " - " + value, e);
            }
            ParserConfiguration conf = new ParserConfiguration();
            conf.setImports(this.imports);
            conf.setPackageImports(this.packageImports);
            conf.setClassLoader(packageClassLoader);
            this.parserConfiguration = conf;
        }
        return this.parserConfiguration;
    }

    public void resetParserConfiguration() {
        this.parserConfiguration = null;
    }

    public void addImport(String str, Class cls) {
        this.imports.put(str, cls);
        if (this.parserConfiguration != null) {
            this.parserConfiguration.addImport(str, cls);
        }
    }

    public void addImport(String str, Method method) {
        this.imports.put(str, method);
        if (this.parserConfiguration != null) {
            this.parserConfiguration.addImport(str, method);
        }
    }

    public void addPackageImport(String str) {
        this.packageImports.add(str);
        if (this.parserConfiguration != null) {
            this.parserConfiguration.addPackageImport(str);
        }
    }

    public void addCompileable(MVELCompileable compilable) {
        this.mvelReaders.add(compilable);
    }

    public void compile(InternalReadAccessor reader) {
        this.addCompileable((MVELCompileable)reader);
        ((MVELCompileable)reader).compile(this);
    }

    public void addCompileable(Wireable wireable, MVELCompileable compilable) {
        this.invokerLookups.computeIfAbsent(wireable, k -> new ArrayList()).add(compilable);
    }

    public ClassLoader getRootClassLoader() {
        return this.rootClassLoader;
    }

    public ClassLoader getPackageClassLoader() {
        if (this.registry == null) {
            return this.getRootClassLoader();
        }
        JavaDialectRuntimeData javaRuntime = (JavaDialectRuntimeData)this.registry.getDialectData("java");
        return javaRuntime.getClassLoader();
    }

    public Map<String, Object> getImports() {
        return this.imports;
    }

    public static class MapFunctionResolverFactory
    extends MapVariableResolverFactory
    implements Externalizable {
        public MapFunctionResolverFactory() {
            super(new HashMap());
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.variables);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.variables = (Map)in.readObject();
        }

        public void addFunction(Function function) {
            this.variables.put(function.getName(), function);
        }

        public void removeFunction(String functionName) {
            this.variables.remove(functionName);
            this.variableResolvers.remove(functionName);
        }

        public VariableResolver createVariable(String name, Object value) {
            throw new RuntimeException("variable is a read-only function pointer");
        }

        public VariableResolver createIndexedVariable(int index, String name, Object value, Class<?> type) {
            throw new RuntimeException("variable is a read-only function pointer");
        }
    }
}

