/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.extraction.word;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.LittleEndian;
import org.textmining.extraction.word.ComplexFileTable;
import org.textmining.extraction.word.PasswordProtectedException;
import org.textmining.extraction.word.WordTextExtractor;
import org.textmining.extraction.word.WordTextScrubber;
import org.textmining.extraction.word.model.CHPBinTable;
import org.textmining.extraction.word.model.CHPX;
import org.textmining.extraction.word.model.ComplexNodeHelper;
import org.textmining.extraction.word.model.NodeHelper;
import org.textmining.extraction.word.model.TextPiece;
import org.textmining.extraction.word.model.TextPieceTable;
import org.textmining.extraction.word.sprm.SprmIterator;
import org.textmining.extraction.word.sprm.SprmOperation;

public class Word97TextExtractor
extends WordTextExtractor {
    Word97TextExtractor(byte[] header, POIFSFileSystem fsys, boolean fastSaved) {
        this._header = header;
        this._fsys = fsys;
        this._fastSave = fastSaved;
    }

    public Word97TextExtractor(InputStream in) throws IOException, PasswordProtectedException {
        super.initWordHeader(in);
    }

    @Override
    public String getText() throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.getText(stringWriter);
        return stringWriter.toString();
    }

    @Override
    public void getText(Writer stringWriter) throws IOException {
        short info = LittleEndian.getShort((byte[])this._header, (int)10);
        boolean useTable1 = (info & 0x200) != 0;
        int complexOffset = LittleEndian.getInt((byte[])this._header, (int)418);
        String tableName = null;
        tableName = useTable1 ? "1Table" : "0Table";
        DocumentEntry table = (DocumentEntry)this._fsys.getRoot().getEntry(tableName);
        byte[] tableStream = new byte[table.getSize()];
        DocumentInputStream din = this._fsys.createDocumentInputStream(tableName);
        din.read(tableStream);
        din.close();
        int fcMin = LittleEndian.getInt((byte[])this._header, (int)24);
        ComplexFileTable cft = new ComplexFileTable(this._header, tableStream, complexOffset, fcMin);
        TextPieceTable tpt = cft.getTextPieceTable();
        List textPieces = tpt.getTextPieces();
        StringBuffer allTxt = new StringBuffer();
        for (int x = 0; x < textPieces.size(); ++x) {
            TextPiece tp = (TextPiece)textPieces.get(x);
            String txt = tp.getText(this._header);
            allTxt.append(txt);
        }
        NodeHelper fc2Cp = null;
        fc2Cp = this._fastSave ? new ComplexNodeHelper(tpt) : new NodeHelper(tpt);
        int chpOffset = LittleEndian.getInt((byte[])this._header, (int)250);
        int chpSize = LittleEndian.getInt((byte[])this._header, (int)254);
        CHPBinTable cbt = new CHPBinTable(this._header, tableStream, chpOffset, chpSize, fcMin, fc2Cp);
        din = null;
        this._fsys = null;
        table = null;
        List textRuns = cbt.getTextRuns();
        WordTextScrubber scrubber = new WordTextScrubber();
        for (int x = 0; x < textRuns.size(); ++x) {
            CHPX chpx = (CHPX)textRuns.get(x);
            if (this.isDeleted(chpx.getGrpprl())) continue;
            String str = allTxt.substring(chpx.getStart(), chpx.getEnd());
            scrubber.append(stringWriter, str);
        }
    }

    @Override
    protected boolean isDeleted(byte[] grpprl) {
        SprmIterator iterator = new SprmIterator(grpprl);
        while (iterator.hasNext()) {
            SprmOperation op = iterator.next();
            if (op.getOperation() != 0 || op.getOperand() == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean supportsUnicode() {
        return true;
    }
}

