/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.extraction.word.chp;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.util.LittleEndian;
import org.textmining.extraction.word.model.CHPFormattedDiskPage;
import org.textmining.extraction.word.model.GenericPropertyNode;
import org.textmining.extraction.word.model.NodeHelper;
import org.textmining.extraction.word.model.PlexOfCps;

public class Word6CHPBinTable {
    ArrayList _textRuns = new ArrayList();

    public Word6CHPBinTable(byte[] documentStream, int offset, int size, int fcMin, NodeHelper helper) {
        PlexOfCps binTable = new PlexOfCps(documentStream, offset, size, 2);
        int length = binTable.length();
        for (int x = 0; x < length; ++x) {
            GenericPropertyNode node = binTable.getProperty(x);
            short pageNum = LittleEndian.getShort((byte[])node.getBytes());
            int pageOffset = 512 * pageNum;
            CHPFormattedDiskPage cfkp = new CHPFormattedDiskPage(documentStream, pageOffset, fcMin, helper);
            int fkpSize = cfkp.size();
            for (int y = 0; y < fkpSize; ++y) {
                this._textRuns.add(cfkp.getCHPX(y));
            }
        }
        helper.sortNodes(this._textRuns, false);
    }

    public List getTextRuns() {
        return this._textRuns;
    }
}

