/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemupdate;

import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dspace.app.itemupdate.ItemUpdate;

public class ContentsEntry {
    public static final String HDR_BUNDLE = "bundle:";
    public static final String HDR_PERMISSIONS = "permissions:";
    public static final String HDR_DESCRIPTION = "description:";
    public static final Pattern permissionsPattern = Pattern.compile("-([rw])\\s*'?([^']+)'?");
    final String filename;
    final String bundlename;
    final String permissionsGroupName;
    final int permissionsActionId;
    final String description;

    private ContentsEntry(String filename, String bundlename, int permissionsActionId, String permissionsGroupName, String description) {
        this.filename = filename;
        this.bundlename = bundlename;
        this.permissionsActionId = permissionsActionId;
        this.permissionsGroupName = permissionsGroupName;
        this.description = description;
    }

    public static ContentsEntry parse(String line) throws ParseException {
        String[] ar = line.split("\t");
        ItemUpdate.pr("ce line split: " + ar.length);
        String[] arp = new String[4];
        arp[0] = ar[0];
        String groupName = null;
        int actionId = -1;
        if (ar.length > 1) {
            for (int i = 1; i < ar.length; ++i) {
                ItemUpdate.pr("ce " + i + " : " + ar[i]);
                if (ar[i].startsWith(HDR_BUNDLE)) {
                    arp[1] = ar[i].substring(HDR_BUNDLE.length()).trim();
                    continue;
                }
                if (ar[i].startsWith(HDR_PERMISSIONS)) {
                    arp[2] = ar[i].substring(HDR_PERMISSIONS.length()).trim();
                    Matcher m = permissionsPattern.matcher(arp[2]);
                    if (!m.matches()) continue;
                    String action = m.group(1);
                    if (action.equals("r")) {
                        actionId = 0;
                    } else if (action.equals("w")) {
                        actionId = 1;
                    }
                    groupName = m.group(2).trim();
                    continue;
                }
                if (ar[i].startsWith(HDR_DESCRIPTION)) {
                    arp[3] = ar[i].substring(HDR_DESCRIPTION.length()).trim();
                    continue;
                }
                throw new ParseException("Unknown text in contents file: " + ar[i], 0);
            }
        }
        return new ContentsEntry(arp[0], arp[1], actionId, groupName, arp[3]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.filename);
        if (this.bundlename != null) {
            sb.append(HDR_BUNDLE).append(" ").append(this.bundlename);
        }
        if (this.permissionsGroupName != null) {
            sb.append(HDR_PERMISSIONS);
            if (this.permissionsActionId == 0) {
                sb.append(" -r ");
            } else if (this.permissionsActionId == 1) {
                sb.append(" -w ");
            }
            sb.append(this.permissionsGroupName);
        }
        if (this.description != null) {
            sb.append(HDR_DESCRIPTION).append(" ").append(this.description);
        }
        return sb.toString();
    }
}

