/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.sitemap;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import org.dspace.app.sitemap.AbstractGenerator;

public class HTMLSitemapGenerator
extends AbstractGenerator {
    private String indexURLStem;
    private String indexURLTail;

    public HTMLSitemapGenerator(File outputDirIn, String urlStem, String urlTail) {
        super(outputDirIn);
        this.indexURLStem = urlStem;
        this.indexURLTail = urlTail == null ? "" : urlTail;
    }

    @Override
    public String getFilename(int number) {
        return "sitemap" + number + ".html";
    }

    @Override
    public String getLeadingBoilerPlate() {
        return "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\n<html><head><title>URL List</title></head><body><ul>";
    }

    @Override
    public int getMaxSize() {
        return 51200;
    }

    @Override
    public int getMaxURLs() {
        return 1000;
    }

    @Override
    public String getTrailingBoilerPlate() {
        return "</ul></body></html>\n";
    }

    @Override
    public String getURLText(String url, Date lastMod) {
        StringBuffer urlText = new StringBuffer();
        urlText.append("<li><a href=\"").append(url).append("\">").append(url).append("</a></li>\n");
        return urlText.toString();
    }

    @Override
    public boolean useCompression() {
        return false;
    }

    @Override
    public String getIndexFilename() {
        return "sitemap_index.html";
    }

    @Override
    public void writeIndex(PrintStream output, int sitemapCount) throws IOException {
        output.println(this.getLeadingBoilerPlate());
        for (int i = 0; i < sitemapCount; ++i) {
            output.print("<li><a href=\"" + this.indexURLStem + i + this.indexURLTail + "\">sitemap " + i);
            output.print("</a></li>\n");
        }
        output.println(this.getTrailingBoilerPlate());
    }
}

