/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.checker.DAOSupport;
import org.dspace.storage.rdbms.DatabaseManager;

public final class ChecksumResultDAO
extends DAOSupport {
    private static final String FIND_CHECK_STRING = "select result_description from checksum_results where result_code = ?";
    private static final Logger LOG = Logger.getLogger(ChecksumResultDAO.class);

    public String getChecksumCheckStr(String code) {
        String description = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseManager.getConnection();
            stmt = conn.prepareStatement(FIND_CHECK_STRING);
            stmt.setString(1, code);
            rs = stmt.executeQuery();
            if (rs.next()) {
                description = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                LOG.error((Object)("Problem selecting checker result description. " + e.getMessage()), (Throwable)e);
                throw new IllegalStateException("selecting checker result description. " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.cleanup(stmt, conn, rs);
                throw throwable;
            }
        }
        this.cleanup(stmt, conn, rs);
        return description;
    }

    public List<String> listAllCodes() {
        Object code;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<Object> codes = new ArrayList<Object>();
        try {
            conn = DatabaseManager.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery("SELECT result_code FROM checksum_results");
            while (rs.next()) {
                code = rs.getString("result_code");
                codes.add(code);
            }
            code = codes;
        }
        catch (SQLException e) {
            try {
                LOG.error((Object)("Problem listing checksum results codes: " + e.getMessage()), (Throwable)e);
                throw new IllegalStateException("Problem listing checksum results codes: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.cleanup(stmt, conn, rs);
                throw throwable;
            }
        }
        this.cleanup(stmt, conn, rs);
        return code;
    }
}

