/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeConfiguration;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.event.Event;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class Bundle
extends DSpaceObject {
    private static Logger log = Logger.getLogger(Bundle.class);
    private Context ourContext;
    private TableRow bundleRow;
    private List<Bitstream> bitstreams;
    private boolean modified;
    private boolean modifiedMetadata;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bundle(Context context, TableRow row) throws SQLException {
        this.ourContext = context;
        this.bundleRow = row;
        this.bitstreams = new ArrayList<Bitstream>();
        String bitstreamOrderingField = ConfigurationManager.getProperty("webui.bitstream.order.field");
        String bitstreamOrderingDirection = ConfigurationManager.getProperty("webui.bitstream.order.direction");
        if (bitstreamOrderingField == null) {
            bitstreamOrderingField = "sequence_id";
        }
        if (bitstreamOrderingDirection == null) {
            bitstreamOrderingDirection = "ASC";
        }
        StringBuilder query = new StringBuilder();
        query.append("SELECT bitstream.*,bundle2bitstream.bitstream_order FROM bitstream, bundle2bitstream WHERE");
        query.append(" bundle2bitstream.bitstream_id=bitstream.bitstream_id AND");
        query.append(" bundle2bitstream.bundle_id= ?");
        query.append(" ORDER BY ");
        query.append(bitstreamOrderingField);
        query.append(" ");
        query.append(bitstreamOrderingDirection);
        TableRowIterator tri = DatabaseManager.query(this.ourContext, query.toString(), this.bundleRow.getIntColumn("bundle_id"));
        try {
            while (tri.hasNext()) {
                TableRow r = tri.next();
                Bitstream fromCache = (Bitstream)context.fromCache(Bitstream.class, r.getIntColumn("bitstream_id"));
                if (fromCache != null) {
                    this.bitstreams.add(fromCache);
                    continue;
                }
                r.setTable("bitstream");
                this.bitstreams.add(new Bitstream(this.ourContext, r));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        context.cache(this, row.getIntColumn("bundle_id"));
        this.modified = false;
        this.modifiedMetadata = false;
    }

    public static Bundle find(Context context, int id) throws SQLException {
        Bundle fromCache = (Bundle)context.fromCache(Bundle.class, id);
        if (fromCache != null) {
            return fromCache;
        }
        TableRow row = DatabaseManager.find(context, "bundle", id);
        if (row == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader(context, "find_bundle", "not_found,bundle_id=" + id));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader(context, "find_bundle", "bundle_id=" + id));
        }
        return new Bundle(context, row);
    }

    static Bundle create(Context context) throws SQLException {
        TableRow row = DatabaseManager.create(context, "bundle");
        log.info((Object)LogManager.getHeader(context, "create_bundle", "bundle_id=" + row.getIntColumn("bundle_id")));
        context.addEvent(new Event(1, 1, row.getIntColumn("bundle_id"), null));
        return new Bundle(context, row);
    }

    @Override
    public int getID() {
        return this.bundleRow.getIntColumn("bundle_id");
    }

    @Override
    public String getName() {
        return this.bundleRow.getStringColumn("name");
    }

    public void setName(String name) {
        this.bundleRow.setColumn("name", name);
        this.modifiedMetadata = true;
    }

    public int getPrimaryBitstreamID() {
        return this.bundleRow.getIntColumn("primary_bitstream_id");
    }

    public void setPrimaryBitstreamID(int bitstreamID) {
        this.bundleRow.setColumn("primary_bitstream_id", bitstreamID);
        this.modified = true;
    }

    public void unsetPrimaryBitstreamID() {
        this.bundleRow.setColumnNull("primary_bitstream_id");
    }

    @Override
    public String getHandle() {
        return null;
    }

    public Bitstream getBitstreamByName(String name) {
        Bitstream target = null;
        for (Bitstream b : this.bitstreams) {
            if (!name.equals(b.getName())) continue;
            target = b;
            break;
        }
        return target;
    }

    public Bitstream[] getBitstreams() {
        Bitstream[] bitstreamArray = new Bitstream[this.bitstreams.size()];
        bitstreamArray = this.bitstreams.toArray(bitstreamArray);
        return bitstreamArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item[] getItems() throws SQLException {
        ArrayList<Item> items = new ArrayList<Item>();
        TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "item", "SELECT item.* FROM item, item2bundle WHERE item2bundle.item_id=item.item_id AND item2bundle.bundle_id= ? ", this.bundleRow.getIntColumn("bundle_id"));
        try {
            while (tri.hasNext()) {
                TableRow r = tri.next();
                Item fromCache = (Item)this.ourContext.fromCache(Item.class, r.getIntColumn("item_id"));
                if (fromCache != null) {
                    items.add(fromCache);
                    continue;
                }
                items.add(new Item(this.ourContext, r));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        Item[] itemArray = new Item[items.size()];
        itemArray = items.toArray(itemArray);
        return itemArray;
    }

    public Bitstream createBitstream(InputStream is) throws AuthorizeException, IOException, SQLException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 3);
        Bitstream b = Bitstream.create(this.ourContext, is);
        this.addBitstream(b);
        return b;
    }

    public Bitstream registerBitstream(int assetstore, String bitstreamPath) throws AuthorizeException, IOException, SQLException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 3);
        Bitstream b = Bitstream.register(this.ourContext, assetstore, bitstreamPath);
        this.addBitstream(b);
        return b;
    }

    public void addBitstream(Bitstream b) throws SQLException, AuthorizeException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 3);
        log.info((Object)LogManager.getHeader(this.ourContext, "add_bitstream", "bundle_id=" + this.getID() + ",bitstream_id=" + b.getID()));
        for (int i = 0; i < this.bitstreams.size(); ++i) {
            Bitstream existing = this.bitstreams.get(i);
            if (b.getID() != existing.getID()) continue;
            return;
        }
        this.bitstreams.add(b);
        this.ourContext.addEvent(new Event(8, 1, this.getID(), 0, b.getID(), String.valueOf(b.getSequenceID())));
        AuthorizeManager.inheritPolicies(this.ourContext, this, b);
        int bitstreamOrder = 0;
        TableRow tableRow = DatabaseManager.querySingle(this.ourContext, "SELECT MAX(bitstream_order) as max_value FROM bundle2bitstream WHERE bundle_id=?", this.getID());
        if (tableRow != null) {
            bitstreamOrder = tableRow.getIntColumn("max_value") + 1;
        }
        TableRow mappingRow = DatabaseManager.row("bundle2bitstream");
        mappingRow.setColumn("bundle_id", this.getID());
        mappingRow.setColumn("bitstream_id", b.getID());
        mappingRow.setColumn("bitstream_order", bitstreamOrder);
        DatabaseManager.insert(this.ourContext, mappingRow);
    }

    public void setOrder(int[] bitstreamIds) throws AuthorizeException, SQLException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 1);
        HashMap<Integer, Bitstream> bitstreamMap = new HashMap<Integer, Bitstream>();
        for (Bitstream bitstream : this.bitstreams) {
            bitstreamMap.put(bitstream.getID(), bitstream);
        }
        this.bitstreams = new ArrayList<Bitstream>();
        for (int i = 0; i < bitstreamIds.length; ++i) {
            int bitstreamId = bitstreamIds[i];
            TableRow row = DatabaseManager.querySingleTable(this.ourContext, "bundle2bitstream", "SELECT * FROM bundle2bitstream WHERE bitstream_id= ? ", bitstreamId);
            if (row == null) {
                log.warn((Object)LogManager.getHeader(this.ourContext, "Invalid bitstream id while changing bitstream order", "Bundle: " + this.getID() + ", bitstream id: " + bitstreamId));
            } else {
                row.setColumn("bitstream_order", i);
                DatabaseManager.update(this.ourContext, row);
            }
            this.bitstreams.add((Bitstream)bitstreamMap.get(bitstreamId));
        }
        Item owningItem = (Item)this.getParentObject();
        if (owningItem != null) {
            owningItem.updateLastModified();
            owningItem.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBitstream(Bitstream b) throws AuthorizeException, SQLException, IOException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 4);
        log.info((Object)LogManager.getHeader(this.ourContext, "remove_bitstream", "bundle_id=" + this.getID() + ",bitstream_id=" + b.getID()));
        ListIterator<Bitstream> li = this.bitstreams.listIterator();
        while (li.hasNext()) {
            Bitstream existing = li.next();
            if (b.getID() != existing.getID()) continue;
            li.remove();
        }
        this.ourContext.addEvent(new Event(16, 1, this.getID(), 0, b.getID(), String.valueOf(b.getSequenceID())));
        Item owningItem = (Item)this.getParentObject();
        if (owningItem != null) {
            owningItem.updateLastModified();
            owningItem.update();
        }
        if (b.getID() == this.getPrimaryBitstreamID()) {
            this.unsetPrimaryBitstreamID();
        }
        DatabaseManager.updateQuery(this.ourContext, "DELETE FROM bundle2bitstream WHERE bundle_id= ? AND bitstream_id= ? ", this.getID(), b.getID());
        TableRowIterator tri = DatabaseManager.query(this.ourContext, "SELECT * FROM bundle2bitstream WHERE bitstream_id= ? ", b.getID());
        try {
            if (!tri.hasNext()) {
                b.delete();
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
    }

    public void update() throws SQLException, AuthorizeException {
        log.info((Object)LogManager.getHeader(this.ourContext, "update_bundle", "bundle_id=" + this.getID()));
        if (this.modified) {
            this.ourContext.addEvent(new Event(2, 1, this.getID(), null));
            this.modified = false;
        }
        if (this.modifiedMetadata) {
            this.ourContext.addEvent(new Event(4, 1, this.getID(), null));
            this.modifiedMetadata = false;
        }
        DatabaseManager.update(this.ourContext, this.bundleRow);
    }

    void delete() throws SQLException, AuthorizeException, IOException {
        log.info((Object)LogManager.getHeader(this.ourContext, "delete_bundle", "bundle_id=" + this.getID()));
        this.ourContext.addEvent(new Event(32, 1, this.getID(), this.getName()));
        this.ourContext.removeCached(this, this.getID());
        Bitstream[] bs = this.getBitstreams();
        for (int i = 0; i < bs.length; ++i) {
            this.removeBitstream(bs[i]);
        }
        AuthorizeManager.removeAllPolicies(this.ourContext, this);
        DatabaseManager.delete(this.ourContext, this.bundleRow);
    }

    @Override
    public int getType() {
        return 1;
    }

    public void inheritCollectionDefaultPolicies(Collection c) throws SQLException, AuthorizeException {
        List<ResourcePolicy> policies = AuthorizeManager.getPoliciesActionFilter(this.ourContext, c, 9);
        Iterator<ResourcePolicy> i = policies.iterator();
        if (!i.hasNext()) {
            throw new SQLException("Collection " + c.getID() + " has no default bitstream READ policies");
        }
        while (i.hasNext()) {
            ResourcePolicy rp = i.next();
            rp.setAction(0);
        }
        this.replaceAllBitstreamPolicies(policies);
    }

    public void replaceAllBitstreamPolicies(List<ResourcePolicy> newpolicies) throws SQLException, AuthorizeException {
        if (this.bitstreams != null && this.bitstreams.size() > 0) {
            for (Bitstream bs : this.bitstreams) {
                AuthorizeManager.removeAllPolicies(this.ourContext, bs);
                AuthorizeManager.addPolicies(this.ourContext, newpolicies, bs);
            }
        }
        AuthorizeManager.removeAllPolicies(this.ourContext, this);
        AuthorizeManager.addPolicies(this.ourContext, newpolicies, this);
    }

    public List<ResourcePolicy> getBundlePolicies() throws SQLException {
        return AuthorizeManager.getPolicies(this.ourContext, this);
    }

    public List<ResourcePolicy> getBitstreamPolicies() throws SQLException {
        ArrayList<ResourcePolicy> list = new ArrayList<ResourcePolicy>();
        if (this.bitstreams != null && this.bitstreams.size() > 0) {
            for (Bitstream bs : this.bitstreams) {
                list.addAll(AuthorizeManager.getPolicies(this.ourContext, bs));
            }
        }
        return list;
    }

    @Override
    public DSpaceObject getAdminObject(int action) throws SQLException {
        Community[] communities;
        Bundle adminObject = null;
        Item[] items = this.getItems();
        Item item = null;
        Collection collection = null;
        Community community = null;
        if (items != null && items.length > 0 && (collection = (item = items[0]).getOwningCollection()) != null && (communities = collection.getCommunities()) != null && communities.length > 0) {
            community = communities[0];
        }
        switch (action) {
            case 4: {
                if (AuthorizeConfiguration.canItemAdminPerformBitstreamDeletion()) {
                    adminObject = item;
                    break;
                }
                if (AuthorizeConfiguration.canCollectionAdminPerformBitstreamDeletion()) {
                    adminObject = collection;
                    break;
                }
                if (!AuthorizeConfiguration.canCommunityAdminPerformBitstreamDeletion()) break;
                adminObject = community;
                break;
            }
            case 3: {
                if (AuthorizeConfiguration.canItemAdminPerformBitstreamCreation()) {
                    adminObject = item;
                    break;
                }
                if (AuthorizeConfiguration.canCollectionAdminPerformBitstreamCreation()) {
                    adminObject = collection;
                    break;
                }
                if (!AuthorizeConfiguration.canCommunityAdminPerformBitstreamCreation()) break;
                adminObject = community;
                break;
            }
            default: {
                adminObject = this;
            }
        }
        return adminObject;
    }

    @Override
    public DSpaceObject getParentObject() throws SQLException {
        Item[] items = this.getItems();
        if (items != null && items.length > 0 && items[0] != null) {
            return items[0];
        }
        return null;
    }
}

