/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.ctask.general;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.curate.AbstractCurationTask;
import org.dspace.curate.Curator;
import org.dspace.curate.Suspendable;

@Suspendable(invoked=Curator.Invoked.INTERACTIVE)
public class ClamScan
extends AbstractCurationTask {
    private static final int DEFAULT_CHUNK_SIZE = 4096;
    private static final byte[] INSTREAM = "zINSTREAM\u0000".getBytes();
    private static final byte[] PING = "zPING\u0000".getBytes();
    private static final byte[] STATS = "nSTATS\n".getBytes();
    private static final byte[] IDSESSION = "zIDSESSION\u0000".getBytes();
    private static final byte[] END = "zEND\u0000".getBytes();
    private static final String PLUGIN_PREFIX = "clamav";
    private static final String INFECTED_MESSAGE = "had virus detected.";
    private static final String CLEAN_MESSAGE = "had no viruses detected.";
    private static final String CONNECT_FAIL_MESSAGE = "Unable to connect to virus service - check setup";
    private static final String SCAN_FAIL_MESSAGE = "Error encountered using virus service - check setup";
    private static final String NEW_ITEM_HANDLE = "in workflow";
    private static Logger log = Logger.getLogger(ClamScan.class);
    private static String host = null;
    private static int port = 0;
    private static int timeout = 0;
    private static boolean failfast = true;
    private int status = -2;
    private List<String> results = null;
    private Socket socket = null;
    private DataOutputStream dataOutputStream = null;
    static final byte[] buffer = new byte[4096];

    @Override
    public void init(Curator curator, String taskId) throws IOException {
        super.init(curator, taskId);
        host = ConfigurationManager.getProperty(PLUGIN_PREFIX, "service.host");
        port = ConfigurationManager.getIntProperty(PLUGIN_PREFIX, "service.port");
        timeout = ConfigurationManager.getIntProperty(PLUGIN_PREFIX, "socket.timeout");
        failfast = ConfigurationManager.getBooleanProperty(PLUGIN_PREFIX, "scan.failfast");
    }

    @Override
    public int perform(DSpaceObject dso) throws IOException {
        this.status = 2;
        this.logDebugMessage("The target dso is " + dso.getName());
        if (dso instanceof Item) {
            this.status = 0;
            Item item = (Item)dso;
            try {
                this.openSession();
            }
            catch (IOException ioE) {
                this.closeSession();
                this.setResult(CONNECT_FAIL_MESSAGE);
                return -1;
            }
            try {
                Bundle bundle = item.getBundles("ORIGINAL")[0];
                this.results = new ArrayList<String>();
                for (Bitstream bitstream : bundle.getBitstreams()) {
                    InputStream inputstream = bitstream.retrieve();
                    this.logDebugMessage("Scanning " + bitstream.getName() + " . . . ");
                    int bstatus = this.scan(bitstream, inputstream, ClamScan.getItemHandle(item));
                    inputstream.close();
                    if (bstatus == -1) {
                        this.setResult(SCAN_FAIL_MESSAGE);
                        this.status = bstatus;
                        break;
                    }
                    if (failfast && bstatus == 1) {
                        this.status = bstatus;
                        break;
                    }
                    if (bstatus != 1 || this.status != 0) continue;
                    this.status = bstatus;
                }
            }
            catch (AuthorizeException authE) {
                throw new IOException(authE.getMessage(), authE);
            }
            catch (SQLException sqlE) {
                throw new IOException(sqlE.getMessage(), sqlE);
            }
            finally {
                this.closeSession();
            }
            if (this.status != -1) {
                this.formatResults(item);
            }
        }
        return this.status;
    }

    private void openSession() throws IOException {
        this.socket = new Socket();
        try {
            this.logDebugMessage("Connecting to " + host + ":" + port);
            this.socket.connect(new InetSocketAddress(host, port));
        }
        catch (IOException e) {
            log.error((Object)"Failed to connect to clamd . . .", (Throwable)e);
            throw e;
        }
        try {
            this.socket.setSoTimeout(timeout);
        }
        catch (SocketException e) {
            log.error((Object)("Could not set socket timeout . . .  " + timeout + "ms"), (Throwable)e);
            throw new IOException(e);
        }
        try {
            this.dataOutputStream = new DataOutputStream(this.socket.getOutputStream());
        }
        catch (IOException e) {
            log.error((Object)"Failed to open OutputStream . . . ", (Throwable)e);
            throw e;
        }
        try {
            this.dataOutputStream.write(IDSESSION);
        }
        catch (IOException e) {
            log.error((Object)"Error initiating session with IDSESSION command . . . ", (Throwable)e);
            throw e;
        }
    }

    private void closeSession() {
        if (this.dataOutputStream != null) {
            try {
                this.dataOutputStream.write(END);
            }
            catch (IOException e) {
                log.error((Object)"Exception closing dataOutputStream", (Throwable)e);
            }
        }
        try {
            this.logDebugMessage("Closing the socket for ClamAv daemon . . . ");
            this.socket.close();
        }
        catch (IOException e) {
            log.error((Object)"Exception closing socket", (Throwable)e);
        }
    }

    private int scan(Bitstream bitstream, InputStream inputstream, String itemHandle) {
        try {
            this.dataOutputStream.write(INSTREAM);
        }
        catch (IOException e) {
            log.error((Object)"Error writing INSTREAM command . . .");
            return -1;
        }
        int read = 4096;
        while (read == 4096) {
            try {
                read = inputstream.read(buffer);
            }
            catch (IOException e) {
                log.error((Object)"Failed attempting to read the InputStream . . . ");
                return -1;
            }
            if (read == -1) break;
            try {
                this.dataOutputStream.writeInt(read);
                this.dataOutputStream.write(buffer, 0, read);
            }
            catch (IOException e) {
                log.error((Object)"Could not write to the socket . . . ");
                return -1;
            }
        }
        try {
            this.dataOutputStream.writeInt(0);
            this.dataOutputStream.flush();
        }
        catch (IOException e) {
            log.error((Object)"Error writing zero-length chunk to socket");
            return -1;
        }
        try {
            read = this.socket.getInputStream().read(buffer);
        }
        catch (IOException e) {
            log.error((Object)"Error reading result from socket");
            return -1;
        }
        if (read > 0) {
            String response = new String(buffer, 0, read);
            this.logDebugMessage("Response: " + response);
            if (response.indexOf("FOUND") != -1) {
                String itemMsg = "item - " + itemHandle + ": ";
                String bsMsg = "bitstream - " + bitstream.getName() + ": SequenceId - " + bitstream.getSequenceID() + ": infected";
                this.report(itemMsg + bsMsg);
                this.results.add(bsMsg);
                return 1;
            }
            return 0;
        }
        return -1;
    }

    private void formatResults(Item item) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("Item: ").append(ClamScan.getItemHandle(item)).append(" ");
        if (this.status == 1) {
            sb.append(INFECTED_MESSAGE);
            int count = 0;
            for (String scanresult : this.results) {
                sb.append("\n").append(scanresult).append("\n");
                ++count;
            }
            sb.append(count).append(" virus(es) found. ").append(" failfast: ").append(failfast);
        } else {
            sb.append(CLEAN_MESSAGE);
        }
        this.setResult(sb.toString());
    }

    private static String getItemHandle(Item item) {
        String handle = item.getHandle();
        return handle != null ? handle : NEW_ITEM_HANDLE;
    }

    private void logDebugMessage(String message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)message);
        }
    }
}

