/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.ctask.general;

import java.io.IOException;
import java.net.URLEncoder;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.dspace.core.ConfigurationManager;
import org.dspace.ctask.general.AbstractTranslator;

public class MicrosoftTranslator
extends AbstractTranslator {
    private static final String PLUGIN_PREFIX = "translator";
    private static final String baseUrl = "http://api.microsofttranslator.com/V2/Http.svc/Translate";
    private static String apiKey = "";
    private static Logger log = Logger.getLogger(MicrosoftTranslator.class);

    @Override
    protected void initApi() {
        apiKey = ConfigurationManager.getProperty(PLUGIN_PREFIX, "translate.api.key.microsoft");
    }

    @Override
    protected String translateText(String from, String to, String text) throws IOException {
        log.debug((Object)("Performing API call to translate from " + from + " to " + to));
        text = URLEncoder.encode(text, "UTF-8");
        String translatedText = null;
        String url = "http://api.microsofttranslator.com/V2/Http.svc/Translate?appId=" + apiKey;
        url = url + "&to=" + to + "&from=" + from + "&text=" + text;
        HttpClient client = new HttpClient();
        GetMethod hm = new GetMethod(url);
        int code = client.executeMethod((HttpMethod)hm);
        log.debug((Object)("Response code from API call is " + code));
        if (code == 200) {
            String response = hm.getResponseBodyAsString();
            response = response.replaceAll("<string xmlns=\"http://schemas.microsoft.com/2003/10/Serialization/\">", "");
            translatedText = response = response.replaceAll("</string>", "");
        }
        return translatedText;
    }
}

