/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.usage;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dspace.core.ConfigurationManager;
import org.dspace.services.model.Event;
import org.dspace.usage.AbstractUsageEventListener;
import org.dspace.usage.UsageEvent;

public class TabFileUsageEventListener
extends AbstractUsageEventListener {
    private static Logger errorLog = Logger.getLogger(TabFileUsageEventListener.class);
    static PrintWriter log = null;

    public TabFileUsageEventListener() {
        if (null == log) {
            File logFile;
            String logPath = ConfigurationManager.getProperty("usageEvent.tabFileLogger.file");
            if (null == logPath) {
                errorLog.error((Object)"UsageEventTabFileLogger unconfigured, will not log events");
                return;
            }
            String logDir = null;
            if (!new File(logPath).isAbsolute()) {
                logDir = ConfigurationManager.getProperty("log.dir");
            }
            boolean appending = (logFile = new File(logDir, logPath)).length() > 0L;
            try {
                log = new PrintWriter(new OutputStreamWriter(new FileOutputStream(logFile, true)));
            }
            catch (FileNotFoundException e) {
                errorLog.error((Object)"UsageEventTabFileLogger cannot open file, will not log events", (Throwable)e);
                return;
            }
            if (!appending) {
                log.println("date event objectType objectId sessionId sourceAddress eperson");
            }
        }
    }

    public void receiveEvent(Event event) {
        System.out.println("got: " + event.toString());
        if (event instanceof UsageEvent) {
            UsageEvent ue = (UsageEvent)event;
            if (null == log) {
                return;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS");
            String string = dateFormat.format(new Date());
            string = string + "\t" + ue.getName();
            string = string + "\t" + ue.getObject().getType();
            string = string + "\t" + ue.getObject().getID();
            string = string + "\t" + ue.getRequest().getSession().getId();
            string = string + "\t" + ue.getRequest().getRequestURI();
            String epersonName = null == ue.getContext().getCurrentUser() ? "anonymous" : ue.getContext().getCurrentUser().getEmail();
            string = string + "\t" + epersonName;
            log.println(string);
            log.flush();
        }
    }
}

