/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state.actions.userassignment;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.xmlworkflow.Role;
import org.dspace.xmlworkflow.RoleMembers;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.WorkflowRequirementsManager;
import org.dspace.xmlworkflow.XmlWorkflowManager;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.actions.ActionResult;
import org.dspace.xmlworkflow.state.actions.WorkflowActionConfig;
import org.dspace.xmlworkflow.state.actions.userassignment.UserSelectionAction;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.WorkflowItemRole;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class AutoAssignAction
extends UserSelectionAction {
    private static final Logger log = Logger.getLogger(AutoAssignAction.class);

    @Override
    public void activate(Context c, XmlWorkflowItem wfItem) {
    }

    @Override
    public ActionResult execute(Context c, XmlWorkflowItem wfi, Step step, HttpServletRequest request) throws SQLException, AuthorizeException, IOException {
        try {
            Role role = this.getParent().getStep().getRole();
            if (role != null) {
                WorkflowActionConfig nextAction = this.getParent().getStep().getNextAction(this.getParent());
                while (nextAction != null && !nextAction.requiresUI()) {
                    nextAction = nextAction.getStep().getNextAction(nextAction);
                }
                if (nextAction != null) {
                    WorkflowItemRole[] workflowItemRoles;
                    for (WorkflowItemRole workflowItemRole : workflowItemRoles = WorkflowItemRole.find(c, wfi.getID(), role.getId())) {
                        if (workflowItemRole.getEPerson() != null) {
                            this.createTaskForEPerson(c, wfi, step, nextAction, workflowItemRole.getEPerson());
                        } else {
                            EPerson[] members;
                            for (EPerson member : members = Group.allMembers(c, workflowItemRole.getGroup())) {
                                this.createTaskForEPerson(c, wfi, step, nextAction, member);
                            }
                        }
                        workflowItemRole.delete();
                    }
                } else {
                    log.warn((Object)LogManager.getHeader(c, "Error while executing auto assign action", "No valid next action. Workflow item:" + wfi.getID()));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)LogManager.getHeader(c, "Error while executing auto assign action", "Workflow item: " + wfi.getID() + " step :" + this.getParent().getStep().getId()), (Throwable)e);
            throw e;
        }
        catch (AuthorizeException e) {
            log.error((Object)LogManager.getHeader(c, "Error while executing auto assign action", "Workflow item: " + wfi.getID() + " step :" + this.getParent().getStep().getId()), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            log.error((Object)LogManager.getHeader(c, "Error while executing auto assign action", "Workflow item: " + wfi.getID() + " step :" + this.getParent().getStep().getId()), (Throwable)e);
            throw e;
        }
        return new ActionResult(ActionResult.TYPE.TYPE_OUTCOME, 0);
    }

    private void createTaskForEPerson(Context c, XmlWorkflowItem wfi, Step step, WorkflowActionConfig actionConfig, EPerson user) throws SQLException, AuthorizeException, IOException {
        if (ClaimedTask.find(c, wfi.getID(), step.getId(), actionConfig.getId()) != null) {
            WorkflowRequirementsManager.addClaimedUser(c, wfi, step, c.getCurrentUser());
            XmlWorkflowManager.createOwnedTask(c, wfi, step, actionConfig, user);
        }
    }

    @Override
    public boolean isFinished(XmlWorkflowItem wfi) {
        return true;
    }

    @Override
    public void regenerateTasks(Context c, XmlWorkflowItem wfi, RoleMembers roleMembers) throws SQLException {
    }

    @Override
    public boolean isValidUserSelection(Context context, XmlWorkflowItem wfi, boolean hasUI) throws WorkflowConfigurationException, SQLException {
        Role role = this.getParent().getStep().getRole();
        if (role != null) {
            WorkflowItemRole[] workflowItemRoles = WorkflowItemRole.find(context, wfi.getID(), role.getId());
            if (workflowItemRoles.length == 0) {
                throw new WorkflowConfigurationException("The next step is invalid, since it doesn't have any individual item roles");
            }
            return true;
        }
        throw new WorkflowConfigurationException("The next step is invalid, since it doesn't have a valid role");
    }

    @Override
    public boolean usesTaskPool() {
        return false;
    }
}

