/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.storedcomponents;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.xmlworkflow.storedcomponents.InProgressUser;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class PoolTask {
    private Context myContext;
    private TableRow myRow;

    PoolTask(Context context, TableRow row) {
        this.myContext = context;
        this.myRow = row;
    }

    public static PoolTask find(Context context, int id) throws SQLException {
        TableRow row = DatabaseManager.find(context, "cwf_pooltask", id);
        if (row == null) {
            return null;
        }
        return new PoolTask(context, row);
    }

    public static List<PoolTask> findByEperson(Context context, int eperson_id) throws SQLException, AuthorizeException, IOException {
        TableRowIterator tri = DatabaseManager.queryTable(context, "cwf_pooltask", "SELECT * FROM cwf_pooltask WHERE eperson_id= " + eperson_id, new Object[0]);
        HashMap<Integer, PoolTask> tasks = new HashMap<Integer, PoolTask>();
        while (tri.hasNext()) {
            TableRow row = tri.next();
            PoolTask task = new PoolTask(context, row);
            tasks.put(task.getWorkflowItemID(), task);
        }
        tri.close();
        for (Group group : Group.allMemberGroups(context, EPerson.find(context, eperson_id))) {
            tri = DatabaseManager.queryTable(context, "cwf_pooltask", "SELECT * FROM cwf_pooltask WHERE group_id= " + group.getID(), new Object[0]);
            while (tri.hasNext()) {
                TableRow row = tri.next();
                PoolTask task = new PoolTask(context, row);
                XmlWorkflowItem wfi = XmlWorkflowItem.find(context, task.getWorkflowItemID());
                if (InProgressUser.findByWorkflowItemAndEPerson(context, wfi.getID(), eperson_id) != null) continue;
                tasks.put(task.getWorkflowItemID(), task);
            }
            tri.close();
        }
        return new ArrayList<PoolTask>(tasks.values());
    }

    public static List<PoolTask> find(Context context, XmlWorkflowItem workflowItem) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(context, "cwf_pooltask", "SELECT * FROM cwf_pooltask WHERE workflowitem_id= " + workflowItem.getID(), new Object[0]);
        ArrayList<PoolTask> list = new ArrayList<PoolTask>();
        while (tri.hasNext()) {
            TableRow row = tri.next();
            list.add(new PoolTask(context, row));
        }
        tri.close();
        return list;
    }

    public static PoolTask findByWorkflowIdAndEPerson(Context context, int workflowID, int epersonID) throws SQLException, AuthorizeException, IOException {
        TableRow row = DatabaseManager.querySingleTable(context, "cwf_pooltask", "SELECT * FROM cwf_pooltask WHERE workflowitem_id= ? AND eperson_id = ?", workflowID, epersonID);
        if (row != null) {
            return new PoolTask(context, row);
        }
        XmlWorkflowItem wfi = XmlWorkflowItem.find(context, workflowID);
        if (InProgressUser.findByWorkflowItemAndEPerson(context, workflowID, epersonID) != null) {
            return null;
        }
        for (Group group : Group.allMemberGroups(context, EPerson.find(context, epersonID))) {
            row = DatabaseManager.querySingleTable(context, "cwf_pooltask", "SELECT * FROM cwf_pooltask WHERE workflowitem_id= ? AND group_id = ?", workflowID, group.getID());
            if (row == null) continue;
            return new PoolTask(context, row);
        }
        return null;
    }

    public static PoolTask create(Context context) throws SQLException {
        TableRow row = DatabaseManager.create(context, "cwf_pooltask");
        return new PoolTask(context, row);
    }

    public void delete() throws SQLException {
        DatabaseManager.delete(this.myContext, this.myRow);
    }

    public void update() throws SQLException {
        DatabaseManager.update(this.myContext, this.myRow);
    }

    public void setEpersonID(int id) {
        this.myRow.setColumn("eperson_id", id);
    }

    public int getEpersonID() {
        return this.myRow.getIntColumn("eperson_id");
    }

    public void setGroupID(int id) {
        this.myRow.setColumn("group_id", id);
    }

    public int getGroupID() {
        return this.myRow.getIntColumn("group_id");
    }

    public void setWorkflowID(String id) {
        this.myRow.setColumn("workflow_id", id);
    }

    public String getWorkflowID() {
        return this.myRow.getStringColumn("workflow_id");
    }

    public void setWorkflowItemID(int id) {
        this.myRow.setColumn("workflowitem_id", id);
    }

    public int getWorkflowItemID() {
        return this.myRow.getIntColumn("workflowitem_id");
    }

    public void setStepID(String stepID) {
        this.myRow.setColumn("step_id", stepID);
    }

    public String getStepID() throws SQLException {
        return this.myRow.getStringColumn("step_id");
    }

    public void setActionID(String actionID) {
        this.myRow.setColumn("action_id", actionID);
    }

    public String getActionID() {
        return this.myRow.getStringColumn("action_id");
    }
}

