/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.storedcomponents;

import java.sql.SQLException;
import java.util.ArrayList;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class WorkflowItemRole {
    private Context myContext;
    private TableRow myRow;

    WorkflowItemRole(Context context, TableRow row) {
        this.myContext = context;
        this.myRow = row;
    }

    public static WorkflowItemRole find(Context context, int id) throws SQLException {
        TableRow row = DatabaseManager.find(context, "cwf_workflowitemrole", id);
        if (row == null) {
            return null;
        }
        return new WorkflowItemRole(context, row);
    }

    public static WorkflowItemRole[] find(Context context, int workflowItemId, String role) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(context, "cwf_workflowitemrole", "SELECT * FROM cwf_workflowitemrole WHERE workflowitem_id= ? AND role_id= ? ", workflowItemId, role);
        ArrayList<WorkflowItemRole> roles = new ArrayList<WorkflowItemRole>();
        while (tri.hasNext()) {
            roles.add(new WorkflowItemRole(context, tri.next()));
        }
        return roles.toArray(new WorkflowItemRole[roles.size()]);
    }

    public static WorkflowItemRole[] findAllForItem(Context context, int workflowItemId) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(context, "cwf_workflowitemrole", "SELECT * FROM cwf_workflowitemrole WHERE workflowitem_id= ? ", workflowItemId);
        ArrayList<WorkflowItemRole> roles = new ArrayList<WorkflowItemRole>();
        while (tri.hasNext()) {
            roles.add(new WorkflowItemRole(context, tri.next()));
        }
        return roles.toArray(new WorkflowItemRole[roles.size()]);
    }

    public static WorkflowItemRole create(Context context) throws SQLException, AuthorizeException {
        TableRow row = DatabaseManager.create(context, "cwf_workflowitemrole");
        return new WorkflowItemRole(context, row);
    }

    public void delete() throws SQLException {
        DatabaseManager.delete(this.myContext, this.myRow);
    }

    public void update() throws SQLException {
        DatabaseManager.update(this.myContext, this.myRow);
    }

    public void setRoleId(String id) {
        this.myRow.setColumn("role_id", id);
    }

    public String getRoleId() {
        return this.myRow.getStringColumn("role_id");
    }

    public void setWorkflowItemId(int id) {
        this.myRow.setColumn("workflowitem_id", id);
    }

    public int getWorkflowItemId() {
        return this.myRow.getIntColumn("workflowitem_id");
    }

    public void setEPerson(EPerson eperson) {
        this.myRow.setColumn("eperson_id", eperson.getID());
    }

    public EPerson getEPerson() throws SQLException {
        return EPerson.find(this.myContext, this.myRow.getIntColumn("eperson_id"));
    }

    public void setGroup(Group group) {
        this.myRow.setColumn("group_id", group.getID());
    }

    public Group getGroup() throws SQLException {
        return Group.find(this.myContext, this.myRow.getIntColumn("group_id"));
    }
}

