/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.servicemanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.dspace.kernel.Activator;
import org.dspace.kernel.ServiceManager;
import org.dspace.kernel.mixins.ConfigChangeListener;
import org.dspace.kernel.mixins.InitializedService;
import org.dspace.kernel.mixins.ServiceChangeListener;
import org.dspace.kernel.mixins.ServiceManagerReadyAware;
import org.dspace.kernel.mixins.ShutdownService;
import org.dspace.servicemanager.ServiceConfig;
import org.dspace.servicemanager.ServiceManagerSystem;
import org.dspace.servicemanager.ServiceManagerUtils;
import org.dspace.servicemanager.config.DSpaceConfig;
import org.dspace.servicemanager.config.DSpaceConfigurationService;
import org.dspace.servicemanager.spring.SpringServiceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

public final class DSpaceServiceManager
implements ServiceManagerSystem {
    private static Logger log = LoggerFactory.getLogger(DSpaceServiceManager.class);
    private final DSpaceConfigurationService configurationService;
    protected boolean running = false;
    private List<ServiceManagerSystem> serviceManagers = Collections.synchronizedList(new ArrayList());
    private SpringServiceManager primaryServiceManager = null;
    private List<Activator> activators = Collections.synchronizedList(new ArrayList());
    protected boolean developing = false;
    protected boolean testing = false;
    protected String[] springXmlConfigFiles = null;

    public boolean isRunning() {
        return this.running;
    }

    private void checkRunning() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Cannot perform operations on a service manager that is not running");
        }
    }

    public DSpaceServiceManager(DSpaceConfigurationService configurationService) {
        if (configurationService == null) {
            throw new IllegalArgumentException("Failure creating service manager, configuration service is null");
        }
        this.configurationService = configurationService;
        this.developing = (Boolean)((Object)configurationService.getPropertyAsType("service.manager.developing", Boolean.TYPE));
    }

    protected DSpaceServiceManager(DSpaceConfigurationService configurationService, String ... springXmlConfigFiles) {
        this.configurationService = configurationService;
        this.springXmlConfigFiles = springXmlConfigFiles;
        this.testing = true;
        this.developing = true;
    }

    private void registerActivators() {
        for (Activator activator : this.getServicesByType(Activator.class)) {
            try {
                activator.start((ServiceManager)this);
                this.activators.add(activator);
                log.info("Started and registered activator: " + activator.getClass().getName());
            }
            catch (Exception e1) {
                log.error("ERROR: Failed to start activator (" + activator.getClass().getName() + "): " + e1, (Throwable)e1);
            }
        }
    }

    private void unregisterActivators() {
        for (Activator activator : this.activators) {
            if (activator == null) continue;
            String activatorClassName = activator.getClass().getName();
            try {
                activator.stop((ServiceManager)this);
                log.info("Stopped and unregistered activator: " + activatorClassName);
            }
            catch (Exception e1) {
                log.error("ERROR: Failed to stop activator (" + activatorClassName + "): " + e1, (Throwable)e1);
            }
        }
        this.activators.clear();
    }

    public void notifyServiceManagerReady() {
        for (ServiceManagerSystem sms : this.serviceManagers) {
            List services = sms.getServicesByType(ServiceManagerReadyAware.class);
            for (ServiceManagerReadyAware serviceManagerReadyAware : services) {
                try {
                    serviceManagerReadyAware.serviceManagerReady((ServiceManager)this);
                }
                catch (Exception e) {
                    System.err.println("ERROR: Failure in service when calling serviceManagerReady: " + e);
                }
            }
        }
    }

    private boolean checkNotifyServiceChange(List<Class<?>> implementedTypes, ServiceChangeListener serviceChangeListener) {
        boolean notify = false;
        Class[] notifyTypes = serviceChangeListener.notifyForTypes();
        if (notifyTypes == null || notifyTypes.length == 0) {
            notify = true;
        } else {
            block0: for (Class notifyType : notifyTypes) {
                for (Class<?> implementedType : implementedTypes) {
                    if (!notifyType.equals(implementedType)) continue;
                    notify = true;
                    continue block0;
                }
            }
        }
        return notify;
    }

    @Override
    public void shutdown() {
        this.unregisterActivators();
        for (ServiceManagerSystem sms : this.serviceManagers) {
            try {
                sms.shutdown();
            }
            catch (Exception e) {
                System.err.println("Failure shutting down service manager (" + sms + "): " + e.getMessage());
            }
        }
        this.running = false;
        this.serviceManagers.clear();
        this.primaryServiceManager = null;
        log.info("Shutdown DSpace core service manager");
    }

    @Override
    public void startup() {
        Object[] extraConfigs;
        if (!this.testing && (extraConfigs = (String[])this.configurationService.getPropertyAsType("service.manager.spring.configs", String[].class)) != null) {
            this.springXmlConfigFiles = this.springXmlConfigFiles == null ? extraConfigs : (String[])ArrayUtils.addAll((Object[])this.springXmlConfigFiles, (Object[])extraConfigs);
        }
        try {
            this.running = true;
            SpringServiceManager springSMS = new SpringServiceManager(this, this.configurationService, this.testing, this.developing, this.springXmlConfigFiles);
            try {
                springSMS.startup();
            }
            catch (Exception e) {
                throw new IllegalStateException("failure starting up spring service manager: " + e.getMessage(), e);
            }
            this.serviceManagers.add(springSMS);
            this.primaryServiceManager = springSMS;
            this.registerActivators();
            this.notifyServiceManagerReady();
        }
        catch (Exception e) {
            this.shutdown();
            String message = "Failed to startup the DSpace Service Manager: " + e.getMessage();
            System.err.println(message);
            throw new RuntimeException(message, e);
        }
    }

    public void registerService(String name, Object service) {
        this.checkRunning();
        if (name == null || service == null) {
            throw new IllegalArgumentException("name and service cannot be null");
        }
        for (ServiceManagerSystem sms : this.serviceManagers) {
            sms.registerService(name, service);
        }
    }

    public <T> T registerServiceClass(String name, Class<T> type) {
        this.checkRunning();
        if (name == null || type == null) {
            throw new IllegalArgumentException("name and type cannot be null");
        }
        return this.primaryServiceManager.registerServiceClass(name, type);
    }

    public void unregisterService(String name) {
        this.checkRunning();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.primaryServiceManager.unregisterService(name);
    }

    public <T> T getServiceByName(String name, Class<T> type) {
        this.checkRunning();
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        Object service = null;
        for (ServiceManagerSystem sms : this.serviceManagers) {
            try {
                service = sms.getServiceByName(name, type);
                if (service == null) continue;
                break;
            }
            catch (Exception e) {
            }
        }
        if (service == null && name != null) {
            for (ServiceManagerSystem sms : this.serviceManagers) {
                if (service != null) continue;
                service = sms.getServiceByName(name, type);
            }
        }
        return (T)service;
    }

    public <T> List<T> getServicesByType(Class<T> type) {
        this.checkRunning();
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        HashSet set = new HashSet();
        for (ServiceManagerSystem sms : this.serviceManagers) {
            try {
                set.addAll(sms.getServicesByType(type));
            }
            catch (Exception e) {}
        }
        ArrayList services = new ArrayList(set);
        Collections.sort(services, new ServiceManagerUtils.ServiceComparator());
        return services;
    }

    public List<String> getServicesNames() {
        this.checkRunning();
        ArrayList<String> names = new ArrayList<String>();
        for (ServiceManagerSystem sms : this.serviceManagers) {
            try {
                names.addAll(sms.getServicesNames());
            }
            catch (Exception e) {}
        }
        Collections.sort(names);
        return names;
    }

    public boolean isServiceExists(String name) {
        this.checkRunning();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        boolean exists = false;
        for (ServiceManagerSystem sms : this.serviceManagers) {
            try {
                exists = sms.isServiceExists(name);
                if (!exists) continue;
                break;
            }
            catch (Exception e) {
            }
        }
        return exists;
    }

    @Override
    public Map<String, Object> getServices() {
        this.checkRunning();
        HashMap<String, Object> services = new HashMap<String, Object>();
        for (ServiceManagerSystem sms : this.serviceManagers) {
            try {
                for (Map.Entry<String, Object> entry : sms.getServices().entrySet()) {
                    if (services.containsKey(entry.getKey())) continue;
                    services.put(entry.getKey(), entry.getValue());
                }
            }
            catch (Exception e) {
                System.err.println("Failed to get list of services from service manager (" + sms.getClass() + "): " + e);
            }
        }
        return services;
    }

    public void pushConfig(Map<String, String> properties) {
        String[] changedNames;
        this.checkRunning();
        if (properties != null && !properties.isEmpty() && (changedNames = this.configurationService.loadConfiguration(properties, false)).length > 0) {
            ArrayList<String> changedSettingNames = new ArrayList<String>();
            LinkedHashMap<String, String> changedSettings = new LinkedHashMap<String, String>();
            for (String configName : changedNames) {
                changedSettingNames.add(configName);
                changedSettings.put(DSpaceServiceManager.getSimplerName(configName), this.configurationService.getProperty(configName));
            }
            for (ServiceManagerSystem sms : this.serviceManagers) {
                List configChangeListeners = sms.getServicesByType(ConfigChangeListener.class);
                for (ConfigChangeListener configChangeListener : configChangeListeners) {
                    String serviceImplName = configChangeListener.getClass().getName();
                    try {
                        boolean notify = false;
                        String[] notifyNames = configChangeListener.notifyForConfigNames();
                        if (notifyNames == null || notifyNames.length == 0) {
                            notify = true;
                        } else {
                            block5: for (String notifyName : notifyNames) {
                                String simplerName = DSpaceServiceManager.getSimplerName(notifyName);
                                String notifyBeanName = DSpaceConfig.getBeanName(notifyName);
                                if (notifyBeanName != null && notifyBeanName.equals(serviceImplName)) {
                                    notify = true;
                                    break;
                                }
                                for (String changedName : changedNames) {
                                    if (simplerName == null || !simplerName.equals(changedName)) continue;
                                    notify = true;
                                    continue block5;
                                }
                            }
                        }
                        if (!notify) continue;
                        configChangeListener.configurationChanged(changedSettingNames, changedSettings);
                    }
                    catch (Exception e) {
                        System.err.println("Failure occurred while trying to notify service of config change: " + e.getMessage());
                    }
                }
            }
        }
    }

    protected static String getSimplerName(String key) {
        String propertyName;
        String simpleName = key;
        if (key != null && (propertyName = DSpaceConfig.getBeanProperty(key)) != null) {
            simpleName = propertyName;
        }
        return simpleName;
    }

    public static void configureService(String serviceName, Object service, Map<String, Map<String, ServiceConfig>> serviceNameConfigs) {
        if (serviceNameConfigs.containsKey(serviceName)) {
            BeanWrapper beanWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)service);
            Map<String, ServiceConfig> configs = serviceNameConfigs.get(serviceName);
            for (ServiceConfig config : configs.values()) {
                try {
                    beanWrapper.setPropertyValue(config.getParamName(), config.getValue());
                    log.info("Set param (" + config.getParamName() + ") on service bean (" + serviceName + ") to: " + config.getValue());
                }
                catch (RuntimeException e) {
                    log.error("Unable to set param (" + config.getParamName() + ") on service bean (" + serviceName + "): " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static void initService(Object service) {
        if (service instanceof InitializedService) {
            try {
                ((InitializedService)service).init();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failure attempting to initialize service (" + service + "): " + e.getMessage());
            }
        }
    }

    public static void shutdownService(Object service) {
        if (service instanceof ShutdownService) {
            try {
                ((ShutdownService)service).shutdown();
            }
            catch (Exception e) {
                System.err.println("Failure shutting down service: " + service);
            }
        }
    }
}

