/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.servicemanager.config;

public final class DSpaceConfig {
    public static final String ACTIVATOR_PREFIX = "activator.";
    public static final String ACTIVATOR_CLASS_PREFIX = "activator.class.";
    private String key;
    private String value;
    private String beanProperty;
    private String beanName;
    private boolean activator = false;
    private boolean activatorClass = false;
    private String activatorClassName;
    private String activatorName;
    private String activatorAutowire;

    public DSpaceConfig(String key, String value) {
        if (key == null || "".equals(key)) {
            throw new IllegalArgumentException("Failure with config creation, key is empty or null");
        }
        this.key = key.trim();
        this.value = value;
        int atLoc = key.indexOf(64);
        if (atLoc > 0) {
            try {
                this.beanProperty = key.substring(0, atLoc);
                this.beanName = key.substring(atLoc + 1);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Invalid bean key (" + key + "): could not parse key (should be like param@org.dspace.BeanName): " + e.getMessage(), e);
            }
        }
        if (this.key.startsWith(ACTIVATOR_CLASS_PREFIX)) {
            if (this.value == null || this.value.length() <= 2) {
                throw new IllegalArgumentException("Invalid configuration value for key (" + this.key + "), must not be blank or null and must be set to a class activator string (e.g. org.dspace.MyClass;org.dspace.MyServiceName)");
            }
            this.activatorClass = true;
            if (this.value.indexOf(59) == -1) {
                this.activatorClassName = this.value.trim();
            } else {
                String[] parts = this.value.trim().split(";");
                this.activatorClassName = parts[0].trim();
                if (parts.length > 1) {
                    this.activatorName = parts[1].trim();
                }
                if (parts.length > 2) {
                    this.activatorAutowire = parts[2].trim().toLowerCase();
                }
            }
            if (this.activatorName == null) {
                this.activatorName = this.activatorClassName;
            }
            if (this.activatorAutowire == null) {
                this.activatorAutowire = "auto";
            }
        } else if (this.key.startsWith(ACTIVATOR_PREFIX)) {
            if (this.value == null || this.value.length() <= 2) {
                throw new IllegalArgumentException("Invalid configuration value for key (" + this.key + "), must not be blank or null and must be set to an activator class (e.g. org.dspace.MyActivator)");
            }
            this.activator = true;
            this.activatorClassName = this.value.trim();
        }
    }

    public String getBeanProperty() {
        return this.beanProperty;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public boolean isActivator() {
        return this.activator;
    }

    public boolean isActivatorClass() {
        return this.activatorClass;
    }

    public String getActivatorClassName() {
        return this.activatorClassName;
    }

    public String getActivatorName() {
        return this.activatorName;
    }

    public String getActivatorAutowire() {
        return this.activatorAutowire;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    protected void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof DSpaceConfig)) {
            return false;
        }
        DSpaceConfig castObj = (DSpaceConfig)obj;
        if (this.key == null || this.value == null) {
            return false;
        }
        return this.key.equals(castObj.key) && this.value.equals(castObj.value);
    }

    public int hashCode() {
        if (null == this.key) {
            return super.hashCode();
        }
        return this.key.hashCode() + this.value.hashCode();
    }

    public String toString() {
        return (this.beanName == null ? this.key : this.beanName + "(" + this.beanProperty + ")") + " => " + this.value;
    }

    public static String getBeanName(String key) {
        String name = null;
        int atLoc = key.indexOf(64);
        if (atLoc > 0) {
            try {
                name = key.substring(atLoc + 1);
            }
            catch (RuntimeException e) {
                name = null;
            }
        }
        return name;
    }

    public static String getBeanProperty(String key) {
        String property = null;
        int atLoc = key.indexOf(64);
        if (atLoc > 0) {
            try {
                property = key.substring(0, atLoc);
            }
            catch (RuntimeException e) {
                property = null;
            }
        }
        return property;
    }
}

