/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.servicemanager.spring;

import org.dspace.servicemanager.ServiceManagerSystem;
import org.dspace.servicemanager.config.DSpaceConfigurationService;
import org.dspace.services.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public final class DSpaceBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private static Logger log = LoggerFactory.getLogger(DSpaceBeanFactoryPostProcessor.class);
    private DSpaceConfigurationService configurationService;
    private ServiceManagerSystem parent;
    private boolean testMode = false;

    public DSpaceBeanFactoryPostProcessor(ServiceManagerSystem parent, DSpaceConfigurationService configurationService, boolean testMode) {
        if (parent == null || configurationService == null) {
            throw new IllegalArgumentException("parent and configuration service cannot be null");
        }
        this.configurationService = configurationService;
        this.parent = parent;
        this.testMode = testMode;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        beanFactory.registerSingleton(ConfigurationService.class.getName(), (Object)this.configurationService);
        beanFactory.registerSingleton(ServiceManagerSystem.class.getName(), (Object)this.parent);
    }
}

