/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.services.caching.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dspace.services.model.Cache;
import org.dspace.services.model.CacheConfig;

public final class MapCache
implements Cache {
    private Map<String, Object> cache;
    protected String name;
    protected CacheConfig cacheConfig;

    public Map<String, Object> getCache() {
        return this.cache;
    }

    public MapCache(String name, CacheConfig cacheConfig) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = name;
        this.cache = new HashMap<String, Object>();
        this.cacheConfig = cacheConfig != null ? cacheConfig : new CacheConfig(CacheConfig.CacheScope.REQUEST);
    }

    public void clear() {
        this.cache.clear();
    }

    public boolean exists(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        return this.cache.containsKey(key);
    }

    public Object get(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        return this.cache.get(key);
    }

    public List<String> getKeys() {
        return new ArrayList<String>(this.cache.keySet());
    }

    public CacheConfig getConfig() {
        return this.cacheConfig;
    }

    public String getName() {
        return this.name;
    }

    public Object look(String key) {
        return this.get(key);
    }

    public void put(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        this.cache.put(key, value);
    }

    public boolean remove(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        return this.cache.remove(key) != null;
    }

    public int size() {
        return this.cache.size();
    }

    public String toString() {
        return "MapCache:name=" + this.getName() + ":Scope=" + this.cacheConfig.getCacheScope() + ":size=" + this.size();
    }
}

