/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.services.events;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.ArrayUtils;
import org.dspace.kernel.mixins.ShutdownService;
import org.dspace.services.CachingService;
import org.dspace.services.EventService;
import org.dspace.services.RequestService;
import org.dspace.services.SessionService;
import org.dspace.services.model.Cache;
import org.dspace.services.model.CacheConfig;
import org.dspace.services.model.Event;
import org.dspace.services.model.EventListener;
import org.dspace.services.model.RequestInterceptor;
import org.dspace.services.model.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public final class SystemEventService
implements EventService,
ShutdownService {
    private final Logger log = LoggerFactory.getLogger(SystemEventService.class);
    private static final String QUEUE_CACHE_NAME = "eventQueueCache";
    private Map<String, EventListener> listenersMap = new ConcurrentHashMap<String, EventListener>();
    private final RequestService requestService;
    private final SessionService sessionService;
    private final CachingService cachingService;
    private EventRequestInterceptor requestInterceptor;
    private Random random = new Random();

    @Autowired(required=true)
    public SystemEventService(RequestService requestService, SessionService sessionService, CachingService cachingService) {
        if (requestService == null || cachingService == null || sessionService == null) {
            throw new IllegalArgumentException("requestService, cachingService, and all inputs must not be null");
        }
        this.requestService = requestService;
        this.sessionService = sessionService;
        this.cachingService = cachingService;
        this.requestInterceptor = new EventRequestInterceptor();
        this.requestService.registerRequestInterceptor((RequestInterceptor)this.requestInterceptor);
    }

    public void shutdown() {
        this.requestInterceptor = null;
        this.listenersMap.clear();
    }

    public void fireEvent(Event event) {
        boolean external;
        boolean cluster;
        this.validateEvent(event);
        Object[] scopes = event.getScopes();
        boolean local = ArrayUtils.contains((Object[])scopes, (Object)Event.Scope.LOCAL);
        if (local) {
            this.fireLocalEvent(event);
        }
        if (cluster = ArrayUtils.contains((Object[])scopes, (Object)Event.Scope.CLUSTER)) {
            this.fireClusterEvent(event);
        }
        if (external = ArrayUtils.contains((Object[])scopes, (Object)Event.Scope.EXTERNAL)) {
            this.fireExternalEvent(event);
        }
    }

    public void queueEvent(Event event) {
        this.validateEvent(event);
        Cache queueCache = this.cachingService.getCache(QUEUE_CACHE_NAME, new CacheConfig(CacheConfig.CacheScope.REQUEST));
        if (this.requestService.getCurrentRequestId() != null) {
            String key = System.currentTimeMillis() + ":" + queueCache.size() + ":" + event.getId();
            queueCache.put(key, (Object)event);
        } else {
            this.log.info("No request to queue this event (" + event + ") so firing immediately");
            this.fireEvent(event);
        }
    }

    public void registerEventListener(EventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Cannot register a listener that is null");
        }
        String key = listener.getClass().getName();
        this.listenersMap.put(key, listener);
    }

    private void fireLocalEvent(Event event) {
        for (EventListener listener : this.listenersMap.values()) {
            if (listener == null || !this.filterEvent(listener, event)) continue;
            try {
                listener.receiveEvent(event);
            }
            catch (Exception e) {
                this.log.warn("Listener (" + listener + ")[" + listener.getClass().getName() + "] failed to recieve event (" + event + "): " + e.getMessage() + ":" + e.getCause());
            }
        }
    }

    private void fireClusterEvent(Event event) {
        this.log.debug("fireClusterEvent is not implemented yet, no support for cluster events yet, could not fire event to the cluster: " + event);
    }

    private void fireExternalEvent(Event event) {
        this.log.debug("fireExternalEvent is not implemented yet, no support for external events yet, could not fire event to external listeners: " + event);
    }

    protected int fireQueuedEvents() {
        int fired = 0;
        Cache queueCache = this.cachingService.getCache(QUEUE_CACHE_NAME, new CacheConfig(CacheConfig.CacheScope.REQUEST));
        List eventIds = queueCache.getKeys();
        Collections.sort(eventIds);
        if (eventIds.size() > 0) {
            for (String eventId : eventIds) {
                Event event = (Event)queueCache.get(eventId);
                this.fireEvent(event);
                ++fired;
            }
        }
        queueCache.clear();
        return fired;
    }

    protected int clearQueuedEvents() {
        Cache queueCache = this.cachingService.getCache(QUEUE_CACHE_NAME, new CacheConfig(CacheConfig.CacheScope.REQUEST));
        int cleared = queueCache.size();
        queueCache.clear();
        return cleared;
    }

    private void validateEvent(Event event) {
        if (event == null) {
            throw new IllegalArgumentException("Cannot fire null events");
        }
        if (event.getName() == null || "".equals(event.getName())) {
            throw new IllegalArgumentException("Event name must be set");
        }
        if (event.getId() == null || "".equals(event.getId())) {
            event.setId(this.makeEventId());
        }
        if (event.getUserId() == null || "".equals(event.getUserId())) {
            String userId = this.sessionService.getCurrentUserId();
            event.setUserId(userId);
        }
        if (event.getScopes() == null) {
            event.setScopes(new Event.Scope[]{Event.Scope.LOCAL, Event.Scope.CLUSTER});
        }
    }

    private boolean filterEvent(EventListener listener, Event event) {
        boolean allowName;
        block10: {
            if (listener == null || event == null) {
                return false;
            }
            allowName = true;
            try {
                String[] namePrefixes = listener.getEventNamePrefixes();
                if (namePrefixes == null || namePrefixes.length <= 0) break block10;
                allowName = false;
                for (String namePrefix : namePrefixes) {
                    String eventName = event.getName();
                    if (namePrefix == null || namePrefix.length() <= 0 || !eventName.startsWith(namePrefix)) continue;
                    allowName = true;
                    break;
                }
            }
            catch (Exception e1) {
                this.log.warn("Listener (" + listener + ")[" + listener.getClass().getName() + "] failure calling getEventNamePrefixes: " + e1.getMessage() + ":" + e1.getCause());
            }
        }
        boolean allowResource = true;
        try {
            String resourcePrefix = listener.getResourcePrefix();
            if (resourcePrefix != null && resourcePrefix.length() > 0) {
                allowResource = false;
                String resRef = event.getResourceReference();
                if (resRef == null) {
                    allowResource = true;
                } else if (resRef.startsWith(resourcePrefix)) {
                    allowResource = true;
                }
            }
        }
        catch (Exception e1) {
            this.log.warn("Listener (" + listener + ")[" + listener.getClass().getName() + "] failure calling getResourcePrefix: " + e1.getMessage() + ":" + e1.getCause());
        }
        return allowName && allowResource;
    }

    private String makeEventId() {
        return "event-" + this.random.nextInt(1000) + "-" + System.currentTimeMillis();
    }

    public final class EventRequestInterceptor
    implements RequestInterceptor {
        public void onStart(String requestId, Session session) {
        }

        public void onEnd(String requestId, Session session, boolean succeeded, Exception failure) {
            if (succeeded) {
                int fired = SystemEventService.this.fireQueuedEvents();
                SystemEventService.this.log.debug("Fired " + fired + " events at the end of the request (" + requestId + ")");
            } else {
                int cleared = SystemEventService.this.clearQueuedEvents();
                SystemEventService.this.log.debug("Cleared/cancelled " + cleared + " events at the end of the failed request (" + requestId + ")");
            }
        }

        public int getOrder() {
            return 20;
        }
    }
}

