/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.services.sessions.model;

import java.util.Enumeration;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public final class InternalHttpSession
implements HttpSession {
    private final String id;
    private long lastAccessedTime = System.currentTimeMillis();
    private long creationTime = System.currentTimeMillis();
    private int maxInactiveInternal = 1800;
    private boolean invalidated = false;
    private ConcurrentHashMap<String, Object> attributes = null;

    private ConcurrentHashMap<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ConcurrentHashMap();
        }
        return this.attributes;
    }

    public InternalHttpSession() {
        this.id = UUID.randomUUID().toString();
    }

    private void checkInvalidated() {
        if (this.invalidated) {
            throw new IllegalStateException("This session is no longer valid");
        }
    }

    public String toString() {
        return "internalSession:" + this.id + ":" + this.creationTime + ":" + this.invalidated + ":" + super.toString();
    }

    public Object getAttribute(String name) {
        this.checkInvalidated();
        return this.getAttributes().get(name);
    }

    public Enumeration getAttributeNames() {
        this.checkInvalidated();
        return this.getAttributes().keys();
    }

    public long getCreationTime() {
        this.checkInvalidated();
        return this.creationTime;
    }

    public String getId() {
        this.checkInvalidated();
        return this.id;
    }

    public long getLastAccessedTime() {
        this.checkInvalidated();
        return this.lastAccessedTime;
    }

    public int getMaxInactiveInterval() {
        this.checkInvalidated();
        return this.maxInactiveInternal;
    }

    public ServletContext getServletContext() {
        this.checkInvalidated();
        return null;
    }

    public HttpSessionContext getSessionContext() {
        this.checkInvalidated();
        return null;
    }

    public Object getValue(String name) {
        this.checkInvalidated();
        return this.getAttributes().get(name);
    }

    public String[] getValueNames() {
        this.checkInvalidated();
        Set names = this.getAttributes().keySet();
        return names.toArray(new String[names.size()]);
    }

    public void invalidate() {
        this.invalidated = true;
        if (this.attributes != null) {
            this.attributes.clear();
            this.attributes = null;
        }
    }

    public boolean isNew() {
        return false;
    }

    public void putValue(String name, Object value) {
        this.checkInvalidated();
        this.getAttributes().put(name, value);
    }

    public void removeAttribute(String name) {
        this.checkInvalidated();
        this.getAttributes().remove(name);
    }

    public void removeValue(String name) {
        this.checkInvalidated();
        this.getAttributes().remove(name);
    }

    public void setAttribute(String name, Object value) {
        this.checkInvalidated();
        this.getAttributes().put(name, value);
    }

    public void setMaxInactiveInterval(int interval) {
        this.checkInvalidated();
        this.maxInactiveInternal = interval;
    }
}

