/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.utils;

import org.dspace.kernel.DSpaceKernel;
import org.dspace.kernel.DSpaceKernelManager;
import org.dspace.kernel.ServiceManager;
import org.dspace.services.ConfigurationService;
import org.dspace.services.EventService;
import org.dspace.services.RequestService;
import org.dspace.services.SessionService;

public final class DSpace {
    private DSpaceKernel kernel;

    public DSpaceKernel getKernel() {
        return this.kernel;
    }

    public DSpace() {
        this(null);
    }

    public DSpace(String kernelName) {
        DSpaceKernel kernel;
        this.kernel = kernel = new DSpaceKernelManager().getKernel(kernelName);
    }

    public ServiceManager getServiceManager() {
        if (this.kernel == null) {
            throw new IllegalStateException("DSpace kernel cannot be null");
        }
        return this.kernel.getServiceManager();
    }

    public ConfigurationService getConfigurationService() {
        return (ConfigurationService)this.getServiceManager().getServiceByName(ConfigurationService.class.getName(), ConfigurationService.class);
    }

    public EventService getEventService() {
        return (EventService)this.getServiceManager().getServiceByName(EventService.class.getName(), EventService.class);
    }

    public SessionService getSessionService() {
        return (SessionService)this.getServiceManager().getServiceByName(SessionService.class.getName(), SessionService.class);
    }

    public RequestService getRequestService() {
        return (RequestService)this.getServiceManager().getServiceByName(RequestService.class.getName(), RequestService.class);
    }

    public <T> T getSingletonService(Class<T> type) {
        return (T)this.getServiceManager().getServiceByName(type.getName(), type);
    }
}

