/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.utils.servicemanager;

import java.lang.ref.WeakReference;
import org.dspace.services.RequestService;
import org.dspace.services.model.RequestInterceptor;

public final class RequestExecutor
implements Runnable {
    private final WeakReference<RequestService> requestServiceRef;
    private final Runnable toExecute;
    private final boolean useExistingRequestIfPossible;

    public RequestExecutor(RequestService requestService, Runnable toExecute) {
        this(requestService, toExecute, false);
    }

    public RequestExecutor(RequestService requestService, Runnable toExecute, boolean useExistingRequestIfPossible) {
        if (toExecute == null || requestService == null) {
            throw new IllegalArgumentException("toExecute and requestService must both be set (neither can be null)");
        }
        this.requestServiceRef = new WeakReference<RequestService>(requestService);
        this.toExecute = toExecute;
        this.useExistingRequestIfPossible = useExistingRequestIfPossible;
    }

    public void execute() {
        RequestService requestService = (RequestService)this.requestServiceRef.get();
        if (requestService == null) {
            throw new IllegalStateException("it is no longer possible to execute this because the RequestService is no longer valid");
        }
        String requestId = null;
        if (this.useExistingRequestIfPossible) {
            requestId = requestService.getCurrentRequestId();
        }
        boolean newRequest = false;
        if (requestId == null) {
            requestId = requestService.startRequest();
            newRequest = true;
        }
        try {
            this.toExecute.run();
            if (newRequest) {
                requestService.endRequest(null);
            }
        }
        catch (Exception e) {
            requestService.endRequest(e);
            throw new RequestInterceptor.RequestInterruptionException("Failure during execution of Runnable (" + this.toExecute + ") in request (" + requestId + "):" + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void run() {
        this.execute();
    }
}

