/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.item;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Button;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.core.Context;

public class ConfirmItemForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = ConfirmItemForm.message((String)"xmlui.general.dspace_home");
    private static final Message T_item_trail = ConfirmItemForm.message((String)"xmlui.administrative.item.general.item_trail");
    private static final Message T_submit_cancel = ConfirmItemForm.message((String)"xmlui.general.cancel");
    private static final Message T_title = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.title");
    private static final Message T_trail = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.trail");
    private static final Message T_head1 = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.head1");
    private static final Message T_para_delete = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.para_delete");
    private static final Message T_para_withdraw = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.para_withdraw");
    private static final Message T_para_reinstate = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.para_reinstate");
    private static final Message T_column1 = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.column1");
    private static final Message T_column2 = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.column2");
    private static final Message T_column3 = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.column3");
    private static final Message T_submit_delete = ConfirmItemForm.message((String)"xmlui.general.delete");
    private static final Message T_submit_withdraw = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.submit_withdraw");
    private static final Message T_submit_reinstate = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.submit_reinstate");

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/admin/item", T_item_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws WingException, SQLException {
        int itemID = this.parameters.getParameterAsInteger("itemID", -1);
        Item item = Item.find((Context)this.context, (int)itemID);
        DCValue[] values = item.getMetadata("*", "*", "*", "*");
        Arrays.sort(values, new DCValueComparator());
        String confirm = this.parameters.getParameter("confirm", null);
        Division main = body.addInteractiveDivision("confirm-item", this.contextPath + "/admin/item", "post", "primary administrative item");
        main.setHead(T_head1.parameterize(new Object[]{item.getHandle()}));
        if ("delete".equals(confirm)) {
            main.addPara(T_para_delete);
        } else if ("reinstate".equals(confirm)) {
            main.addPara(T_para_reinstate);
        } else if ("withdraw".equals(confirm)) {
            main.addPara(T_para_withdraw);
        }
        Table table = main.addTable("withdrawValues", values.length + 1, 3);
        Row header = table.addRow("header");
        header.addCell().addContent(T_column1);
        header.addCell().addContent(T_column2);
        header.addCell().addContent(T_column3);
        for (DCValue value : values) {
            String dcValue = value.schema + ". " + value.element + (value.qualifier == null ? "" : ". " + value.qualifier);
            Row row = table.addRow();
            row.addCell().addContent(dcValue);
            row.addCell().addContent(value.value);
            row.addCell().addContent(value.language);
        }
        org.dspace.app.xmlui.wing.element.Item actions = main.addList("actions", "form").addItem();
        Button confirmButton = actions.addButton("submit_confirm");
        if ("delete".equals(confirm)) {
            confirmButton.setValue(T_submit_delete);
        } else if ("reinstate".equals(confirm)) {
            confirmButton.setValue(T_submit_reinstate);
        } else if ("withdraw".equals(confirm)) {
            confirmButton.setValue(T_submit_withdraw);
        }
        actions.addButton("submit_cancel").setValue(T_submit_cancel);
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }

    static class DCValueComparator
    implements Comparator,
    Serializable {
        DCValueComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            DCValue o1 = (DCValue)arg0;
            DCValue o2 = (DCValue)arg1;
            String s1 = o1.schema + o1.element + (o1.qualifier == null ? "" : "." + o1.qualifier);
            String s2 = o2.schema + o2.element + (o2.qualifier == null ? "" : "." + o2.qualifier);
            return s1.compareTo(s2);
        }
    }
}

