/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.item;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Button;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Highlight;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;

public class EditItemBitstreamsForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = EditItemBitstreamsForm.message((String)"xmlui.general.dspace_home");
    private static final Message T_submit_return = EditItemBitstreamsForm.message((String)"xmlui.general.return");
    private static final Message T_item_trail = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.general.item_trail");
    private static final Message T_option_head = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.general.option_head");
    private static final Message T_option_status = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.general.option_status");
    private static final Message T_option_bitstreams = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.general.option_bitstreams");
    private static final Message T_option_metadata = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.general.option_metadata");
    private static final Message T_option_view = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.general.option_view");
    private static final Message T_option_curate = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.general.option_curate");
    private static final Message T_title = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.EditItemBitstreamsForm.title");
    private static final Message T_trail = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.EditItemBitstreamsForm.trail");
    private static final Message T_head1 = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.EditItemBitstreamsForm.head1");
    private static final Message T_column1 = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.EditItemBitstreamsForm.column1");
    private static final Message T_column2 = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.EditItemBitstreamsForm.column2");
    private static final Message T_column3 = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.EditItemBitstreamsForm.column3");
    private static final Message T_column4 = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.EditItemBitstreamsForm.column4");
    private static final Message T_column5 = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.EditItemBitstreamsForm.column5");
    private static final Message T_column6 = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.EditItemBitstreamsForm.column6");
    private static final Message T_column7 = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.EditItemBitstreamsForm.column7");
    private static final Message T_bundle_label = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.EditItemBitstreamsForm.bundle_label");
    private static final Message T_primary_label = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.EditItemBitstreamsForm.primary_label");
    private static final Message T_view_link = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.EditItemBitstreamsForm.view_link");
    private static final Message T_submit_add = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.EditItemBitstreamsForm.submit_add");
    private static final Message T_submit_delete = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.EditItemBitstreamsForm.submit_delete");
    private static final Message T_no_upload = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.EditItemBitstreamsForm.no_upload");
    private static final Message T_no_remove = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.EditItemBitstreamsForm.no_remove");
    private static final Message T_submit_reorder = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.EditItemBitstreamsForm.submit_reorder");
    private static final Message T_order_up = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.EditItemBitstreamsForm.order_up");
    private static final Message T_order_down = EditItemBitstreamsForm.message((String)"xmlui.administrative.item.EditItemBitstreamsForm.order_down");

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/admin/item", T_item_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws SQLException, WingException {
        Cell cell;
        int itemID = this.parameters.getParameterAsInteger("itemID", -1);
        Item item = Item.find((Context)this.context, (int)itemID);
        String baseURL = this.contextPath + "/admin/item?administrative-continue=" + this.knot.getId();
        Division main = body.addInteractiveDivision("edit-item-status", this.contextPath + "/admin/item", "post", "primary administrative item");
        main.setHead(T_option_head);
        org.dspace.app.xmlui.wing.element.List options = main.addList("options", "simple", "horizontal");
        options.addItem().addXref(baseURL + "&submit_status", T_option_status);
        options.addItem().addHighlight("bold").addXref(baseURL + "&submit_bitstreams", T_option_bitstreams);
        options.addItem().addXref(baseURL + "&submit_metadata", T_option_metadata);
        options.addItem().addXref(baseURL + "&view_item", T_option_view);
        options.addItem().addXref(baseURL + "&submit_curate", T_option_curate);
        Table files = main.addTable("editItemBitstreams", 1, 1);
        files.setHead(T_head1);
        Row header = files.addRow("header");
        header.addCellContent(T_column1);
        header.addCellContent(T_column2);
        header.addCellContent(T_column3);
        header.addCellContent(T_column4);
        header.addCellContent(T_column5);
        header.addCellContent(T_column6);
        header.addCellContent(T_column7);
        Bundle[] bundles = item.getBundles();
        boolean showBitstreamUpdateOrderButton = false;
        for (Bundle bundle : bundles) {
            Cell bundleCell = files.addRow("bundle_head_" + bundle.getID(), "data", "").addCell(1, 5);
            bundleCell.addContent(T_bundle_label.parameterize(new Object[]{bundle.getName()}));
            Bitstream[] bitstreams = bundle.getBitstreams();
            ArrayList<Integer> bitstreamIdOrder = new ArrayList<Integer>();
            for (Bitstream bitstream : bitstreams) {
                bitstreamIdOrder.add(bitstream.getID());
            }
            for (int bitstreamIndex = 0; bitstreamIndex < bitstreams.length; ++bitstreamIndex) {
                Cell cell2;
                Bitstream bitstream = bitstreams[bitstreamIndex];
                boolean primary = bundle.getPrimaryBitstreamID() == bitstream.getID();
                String name = bitstream.getName();
                if (name != null && name.length() > 50) {
                    String shortName = name.substring(0, 15);
                    shortName = shortName + " ... ";
                    name = shortName = shortName + name.substring(name.length() - 25, name.length());
                }
                String description = bitstream.getDescription();
                String format = null;
                BitstreamFormat bitstreamFormat = bitstream.getFormat();
                if (bitstreamFormat != null) {
                    format = bitstreamFormat.getShortDescription();
                }
                String editURL = this.contextPath + "/admin/item?administrative-continue=" + this.knot.getId() + "&bitstreamID=" + bitstream.getID() + "&submit_edit";
                String viewURL = this.contextPath + "/bitstream/id/" + bitstream.getID() + "/" + bitstream.getName();
                Row row = files.addRow("bitstream_row_" + bitstream.getID(), "data", "");
                CheckBox remove = row.addCell().addCheckBox("remove");
                remove.setLabel("remove");
                remove.addOption(bundle.getID() + "/" + bitstream.getID());
                if (!AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)item, (int)4)) {
                    remove.setDisabled();
                }
                if (AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)bitstream, (int)1)) {
                    cell2 = row.addCell();
                    cell2.addXref(editURL, name);
                    if (primary) {
                        cell2.addXref(editURL, T_primary_label);
                    }
                    row.addCell().addXref(editURL, description);
                    row.addCell().addXref(editURL, format);
                } else {
                    cell2 = row.addCell();
                    cell2.addContent(name);
                    if (primary) {
                        cell2.addContent(T_primary_label);
                    }
                    row.addCell().addContent(description);
                    row.addCell().addContent(format);
                }
                Highlight highlight = row.addCell().addHighlight("fade");
                highlight.addContent("[");
                highlight.addXref(viewURL, T_view_link);
                highlight.addContent("]");
                if (AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)bundle, (int)1)) {
                    Cell cell3 = row.addCell("bitstream_order_" + bitstream.getID(), "data", "");
                    cell3.addHidden("order_" + bitstream.getID()).setValue(String.valueOf(bitstreamIndex + 1));
                    showBitstreamUpdateOrderButton = true;
                    Button upButton = cell3.addButton("submit_order_" + bundle.getID() + "_" + bitstream.getID() + "_up", (bitstreamIndex == 0 ? "disabled" : "") + " icon-button arrowUp ");
                    if (bitstreamIndex == 0) {
                        upButton.setDisabled();
                    }
                    upButton.setValue(T_order_up);
                    upButton.setHelp(T_order_up);
                    Button downButton = cell3.addButton("submit_order_" + bundle.getID() + "_" + bitstream.getID() + "_down", (bitstreamIndex == bitstreams.length - 1 ? "disabled" : "") + " icon-button arrowDown ");
                    if (bitstreamIndex == bitstreams.length - 1) {
                        downButton.setDisabled();
                    }
                    downButton.setValue(T_order_down);
                    downButton.setHelp(T_order_down);
                    cell3.addHidden(bundle.getID() + "_" + bitstream.getID() + "_up_value").setValue(this.retrieveOrderUpButtonValue((List)bitstreamIdOrder.clone(), bitstreamIndex));
                    cell3.addHidden(bundle.getID() + "_" + bitstream.getID() + "_down_value").setValue(this.retrieveOrderDownButtonValue((List)bitstreamIdOrder.clone(), bitstreamIndex));
                    continue;
                }
                row.addCell().addContent(String.valueOf(bitstreamIndex));
            }
        }
        if (AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)item, (int)3)) {
            cell = files.addRow().addCell(1, 5);
            cell.addXref(this.contextPath + "/admin/item?administrative-continue=" + this.knot.getId() + "&submit_add", T_submit_add);
        } else {
            cell = files.addRow().addCell(1, 5);
            cell.addHighlight("fade").addContent(T_no_upload);
        }
        Para actions = main.addPara("editItemActionsP", "editItemActionsP");
        if (showBitstreamUpdateOrderButton) {
            actions.addButton("submit_update_order", "hidden").setValue(T_submit_reorder);
        }
        if (AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)item, (int)4)) {
            actions.addButton("submit_delete").setValue(T_submit_delete);
        } else {
            Button button = actions.addButton("submit_delete");
            button.setValue(T_submit_delete);
            button.setDisabled();
            main.addPara().addHighlight("fade").addContent(T_no_remove);
        }
        actions.addButton("submit_return").setValue(T_submit_return);
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }

    private String retrieveOrderUpButtonValue(List<Integer> bitstreamIdOrder, int bitstreamIndex) {
        if (0 != bitstreamIndex) {
            Integer temp = bitstreamIdOrder.get(bitstreamIndex);
            bitstreamIdOrder.set(bitstreamIndex, bitstreamIdOrder.get(bitstreamIndex - 1));
            bitstreamIdOrder.set(bitstreamIndex - 1, temp);
        }
        return StringUtils.join((Object[])bitstreamIdOrder.toArray(new Integer[bitstreamIdOrder.size()]), (String)",");
    }

    private String retrieveOrderDownButtonValue(List<Integer> bitstreamIdOrder, int bitstreamIndex) {
        if (bitstreamIndex < bitstreamIdOrder.size() - 1) {
            Integer temp = bitstreamIdOrder.get(bitstreamIndex);
            bitstreamIdOrder.set(bitstreamIndex, bitstreamIdOrder.get(bitstreamIndex + 1));
            bitstreamIdOrder.set(bitstreamIndex + 1, temp);
        }
        return StringUtils.join((Object[])bitstreamIdOrder.toArray(new Integer[bitstreamIdOrder.size()]), (String)",");
    }
}

