/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.registries;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Highlight;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.app.xmlui.wing.element.TextArea;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.core.Context;

public class EditMetadataSchema
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = EditMetadataSchema.message((String)"xmlui.general.dspace_home");
    private static final Message T_title = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.title");
    private static final Message T_metadata_registry_trail = EditMetadataSchema.message((String)"xmlui.administrative.registries.general.metadata_registry_trail");
    private static final Message T_trail = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.trail");
    private static final Message T_head1 = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.head1");
    private static final Message T_para1 = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.para1");
    private static final Message T_head2 = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.head2");
    private static final Message T_column1 = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.column1");
    private static final Message T_column2 = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.column2");
    private static final Message T_column3 = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.column3");
    private static final Message T_column4 = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.column4");
    private static final Message T_empty = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.empty");
    private static final Message T_submit_return = EditMetadataSchema.message((String)"xmlui.general.return");
    private static final Message T_submit_delete = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.submit_delete");
    private static final Message T_submit_move = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.submit_move");
    private static final Message T_head3 = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.head3");
    private static final Message T_name = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.name");
    private static final Message T_note = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.note");
    private static final Message T_note_help = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.note_help");
    private static final Message T_submit_add = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.submit_add");
    private static final Message T_head4 = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.head4");
    private static final Message T_submit_update = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.submit_update");
    private static final Message T_submit_cancel = EditMetadataSchema.message((String)"xmlui.general.cancel");
    private static final Message T_error = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.error");
    private static final Message T_error_duplicate_field = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.error_duplicate_field");
    private static final Message T_error_element_empty = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.error_element_empty");
    private static final Message T_error_element_badchar = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.error_element_badchar");
    private static final Message T_error_element_tolong = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.error_element_tolong");
    private static final Message T_error_qualifier_tolong = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.error_qualifier_tolong");
    private static final Message T_error_qualifier_badchar = EditMetadataSchema.message((String)"xmlui.administrative.registries.EditMetadataSchema.error_qualifier_badchar");

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/admin/metadata-registry", T_metadata_registry_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws WingException, SQLException {
        int schemaID = this.parameters.getParameterAsInteger("schemaID", -1);
        int updateID = this.parameters.getParameterAsInteger("updateID", -1);
        int highlightID = this.parameters.getParameterAsInteger("highlightID", -1);
        MetadataSchema schema = MetadataSchema.find((Context)this.context, (int)schemaID);
        MetadataField[] fields = MetadataField.findAllInSchema((Context)this.context, (int)schemaID);
        String schemaName = schema.getName();
        String schemaNamespace = schema.getNamespace();
        String errorString = this.parameters.getParameter("errors", null);
        ArrayList<String> errors = new ArrayList<String>();
        if (errorString != null) {
            for (String error : errorString.split(",")) {
                errors.add(error);
            }
        }
        Division main = body.addInteractiveDivision("metadata-schema-edit", this.contextPath + "/admin/metadata-registry", "post", "primary administrative metadata-registry");
        main.setHead(T_head1.parameterize(new Object[]{schemaName}));
        main.addPara(T_para1.parameterize(new Object[]{schemaNamespace}));
        if (updateID >= 0) {
            this.addUpdateFieldForm(main, schemaName, updateID, errors);
        } else {
            this.addNewFieldForm(main, schemaName, errors);
        }
        Division existingFields = main.addDivision("metadata-schema-edit-existing-fields");
        existingFields.setHead(T_head2);
        Table table = existingFields.addTable("metadata-schema-edit-existing-fields", fields.length + 1, 5);
        Row header = table.addRow("header");
        header.addCellContent(T_column1);
        header.addCellContent(T_column2);
        header.addCellContent(T_column3);
        header.addCellContent(T_column4);
        for (MetadataField field : fields) {
            String id = String.valueOf(field.getFieldID());
            String fieldElement = field.getElement();
            String fieldQualifier = field.getQualifier();
            String fieldName = schemaName + "." + fieldElement;
            if (fieldQualifier != null && fieldQualifier.length() > 0) {
                fieldName = fieldName + "." + fieldQualifier;
            }
            boolean highlight = false;
            if (field.getFieldID() == highlightID) {
                highlight = true;
            }
            String fieldScopeNote = field.getScopeNote();
            String url = this.contextPath + "/admin/metadata-registry?administrative-continue=" + this.knot.getId() + "&submit_edit&fieldID=" + id;
            Row row = highlight ? table.addRow(null, null, "highlight") : table.addRow();
            CheckBox select = row.addCell().addCheckBox("select_field");
            select.setLabel(id);
            select.addOption(id);
            row.addCell().addContent(id);
            row.addCell().addXref(url, fieldName);
            row.addCell().addContent(fieldScopeNote);
        }
        if (fields.length == 0) {
            table.addRow().addCell(1, 4).addHighlight("italic").addContent(T_empty);
            main.addPara().addButton("submit_return").setValue(T_submit_return);
        } else {
            Para actions = main.addPara();
            actions.addButton("submit_delete").setValue(T_submit_delete);
            if (MetadataSchema.findAll((Context)this.context).length > 1) {
                actions.addButton("submit_move").setValue(T_submit_move);
            }
            actions.addButton("submit_return").setValue(T_submit_return);
        }
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }

    public void addNewFieldForm(Division div, String schemaName, List<String> errors) throws WingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String elementValue = request.getParameter("newElement");
        String qualifierValue = request.getParameter("newQualifier");
        String noteValue = request.getParameter("newNote");
        Division newField = div.addDivision("edit-schema-new-field");
        newField.setHead(T_head3);
        org.dspace.app.xmlui.wing.element.List form = newField.addList("edit-schema-new-field-form", "form");
        this.addFieldErrors(form, errors);
        form.addLabel(T_name);
        Highlight item = form.addItem().addHighlight("big");
        item.addContent(schemaName + " . ");
        Text element = item.addText("newElement");
        item.addContent(" . ");
        Text qualifier = item.addText("newQualifier");
        element.setSize(15);
        element.setValue(elementValue);
        qualifier.setSize(15);
        qualifier.setValue(qualifierValue);
        TextArea scopeNote = form.addItem().addTextArea("newNote");
        scopeNote.setLabel(T_note);
        scopeNote.setHelp(T_note_help);
        scopeNote.setSize(2, 35);
        scopeNote.setValue(noteValue);
        form.addItem().addButton("submit_add").setValue(T_submit_add);
    }

    public void addUpdateFieldForm(Division div, String schemaName, int fieldID, List<String> errors) throws WingException, SQLException {
        MetadataField field = MetadataField.find((Context)this.context, (int)fieldID);
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String elementValue = request.getParameter("updateElement");
        String qualifierValue = request.getParameter("updateQualifier");
        String noteValue = request.getParameter("updateNote");
        if (elementValue == null) {
            elementValue = field.getElement();
        }
        if (qualifierValue == null) {
            qualifierValue = field.getQualifier();
        }
        if (noteValue == null) {
            noteValue = field.getScopeNote();
        }
        Division newField = div.addDivision("edit-schema-update-field");
        newField.setHead(T_head4.parameterize(new Object[]{field.getFieldID()}));
        org.dspace.app.xmlui.wing.element.List form = newField.addList("edit-schema-update-field-form", "form");
        this.addFieldErrors(form, errors);
        form.addLabel(T_name);
        Highlight item = form.addItem().addHighlight("big");
        item.addContent(schemaName + " . ");
        Text element = item.addText("updateElement");
        item.addContent(" . ");
        Text qualifier = item.addText("updateQualifier");
        element.setSize(13);
        element.setValue(elementValue);
        qualifier.setSize(13);
        qualifier.setValue(qualifierValue);
        TextArea scopeNote = form.addItem().addTextArea("updateNote");
        scopeNote.setLabel(T_note);
        scopeNote.setHelp(T_note_help);
        scopeNote.setSize(2, 35);
        scopeNote.setValue(noteValue);
        Item actions = form.addItem();
        actions.addButton("submit_update").setValue(T_submit_update);
        actions.addButton("submit_cancel").setValue(T_submit_cancel);
    }

    public void addFieldErrors(org.dspace.app.xmlui.wing.element.List form, List<String> errors) throws WingException {
        if (errors.contains("duplicate_field")) {
            form.addLabel(T_error);
            form.addItem(T_error_duplicate_field);
        }
        if (errors.contains("element_empty")) {
            form.addLabel(T_error);
            form.addItem(T_error_element_empty);
        }
        if (errors.contains("element_badchar")) {
            form.addLabel(T_error);
            form.addItem(T_error_element_badchar);
        }
        if (errors.contains("element_tolong")) {
            form.addLabel(T_error);
            form.addItem(T_error_element_tolong);
        }
        if (errors.contains("qualifier_tolong")) {
            form.addLabel(T_error);
            form.addItem(T_error_qualifier_tolong);
        }
        if (errors.contains("qualifier_badchar")) {
            form.addLabel(T_error);
            form.addItem(T_error_qualifier_badchar);
        }
    }
}

