/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.oro.text.perl.Perl5Util;
import org.dspace.app.xmlui.aspect.artifactbrowser.AbstractSearch;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.xml.sax.SAXException;

public class AdvancedSearch
extends AbstractSearch
implements CacheableProcessingComponent {
    private static final Message T_title = AdvancedSearch.message((String)"xmlui.ArtifactBrowser.AdvancedSearch.title");
    private static final Message T_dspace_home = AdvancedSearch.message((String)"xmlui.general.dspace_home");
    private static final Message T_trail = AdvancedSearch.message((String)"xmlui.ArtifactBrowser.AdvancedSearch.trail");
    private static final Message T_head = AdvancedSearch.message((String)"xmlui.ArtifactBrowser.AdvancedSearch.head");
    private static final Message T_search_scope = AdvancedSearch.message((String)"xmlui.ArtifactBrowser.AdvancedSearch.search_scope");
    private static final Message T_search_scope_help = AdvancedSearch.message((String)"xmlui.ArtifactBrowser.AdvancedSearch.search_scope_help");
    private static final Message T_conjunction = AdvancedSearch.message((String)"xmlui.ArtifactBrowser.AdvancedSearch.conjunction");
    private static final Message T_search_type = AdvancedSearch.message((String)"xmlui.ArtifactBrowser.AdvancedSearch.search_type");
    private static final Message T_search_for = AdvancedSearch.message((String)"xmlui.ArtifactBrowser.AdvancedSearch.search_for");
    private static final Message T_go = AdvancedSearch.message((String)"xmlui.general.go");
    private static final Message T_and = AdvancedSearch.message((String)"xmlui.ArtifactBrowser.AdvancedSearch.and");
    private static final Message T_or = AdvancedSearch.message((String)"xmlui.ArtifactBrowser.AdvancedSearch.or");
    private static final Message T_not = AdvancedSearch.message((String)"xmlui.ArtifactBrowser.AdvancedSearch.not");
    private static final int FIELD_DISPLAY_COUNT = 3;
    private static final int FIELD_MAX_COUNT = 12;
    private List<SearchField> fields;

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException, SQLException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        if (dso instanceof Collection || dso instanceof Community) {
            HandleUtil.buildHandleTrail(dso, pageMeta, this.contextPath);
        }
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String numSearchField = request.getParameter("num_search_field");
        if (numSearchField == null || numSearchField.length() == 0) {
            numSearchField = "3";
        }
        Division search = body.addDivision("advanced-search", "primary");
        search.setHead(T_head);
        Division query = search.addInteractiveDivision("search-query", "advanced-search", "post", "secondary search");
        query.addHidden("num_search_field").setValue(numSearchField);
        query.addHidden("results_per_page").setValue(this.getParameterRpp());
        org.dspace.app.xmlui.wing.element.List queryList = query.addList("search-query", "form");
        if (this.variableScope()) {
            Select scope = queryList.addItem().addSelect("scope");
            scope.setLabel(T_search_scope);
            scope.setHelp(T_search_scope_help);
            this.buildScopeList(scope);
        }
        Table queryTable = query.addTable("search-query", 4, 3);
        Row header = queryTable.addRow("header");
        header.addCellContent(T_conjunction);
        header.addCellContent(T_search_type);
        header.addCellContent(T_search_for);
        for (int i = 1; i <= 3; ++i) {
            Row row = queryTable.addRow("data");
            this.buildConjunctionField(i, row.addCell());
            this.buildTypeField(i, row.addCell());
            this.buildQueryField(i, row.addCell());
        }
        for (SearchField field : this.fields) {
            int i = field.getIndex();
            if (i <= 3) continue;
            query.addHidden("conjunction" + i).setValue(field.getConjunction());
            query.addHidden("field" + i).setValue(field.getField());
            query.addHidden("query" + i).setValue(field.getQuery());
        }
        this.buildSearchControls(query);
        query.addPara(null, "button-list").addButton("submit").setValue(T_go);
        this.buildSearchResultsDivision(search);
    }

    private void buildConjunctionField(int row, Cell cell) throws WingException {
        if (row == 1) {
            return;
        }
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String current = request.getParameter("conjunction" + row);
        if (current == null || current.length() == 0) {
            current = "AND";
        }
        Select select = cell.addSelect("conjunction" + row);
        select.addOption("AND".equals(current), "AND").addContent(T_and);
        select.addOption("OR".equals(current), "OR").addContent(T_or);
        select.addOption("NOT".equals(current), "NOT").addContent(T_not);
    }

    private void buildTypeField(int row, Cell cell) throws WingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String current = request.getParameter("field" + row);
        Select select = cell.addSelect("field" + row);
        select.addOption(current == null, "ANY").addContent(AdvancedSearch.message((String)"xmlui.ArtifactBrowser.AdvancedSearch.type_ANY"));
        ArrayList<String> usedSearchTypes = new ArrayList<String>();
        int i = 1;
        String sindex = ConfigurationManager.getProperty((String)("search.index." + i));
        while (sindex != null) {
            String field = sindex.split(":")[0];
            if (!usedSearchTypes.contains(field)) {
                usedSearchTypes.add(field);
                select.addOption(field.equals(current), field).addContent(AdvancedSearch.message((String)("xmlui.ArtifactBrowser.AdvancedSearch.type_" + field)));
            }
            sindex = ConfigurationManager.getProperty((String)("search.index." + ++i));
        }
    }

    @Override
    public void recycle() {
        this.fields = null;
        super.recycle();
    }

    private void buildQueryField(int row, Cell cell) throws WingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String current = AdvancedSearch.decodeFromURL(request.getParameter("query" + row));
        Text text = cell.addText("query" + row);
        if (current != null) {
            text.setValue(current);
        }
    }

    @Override
    protected String generateURL(Map<String, String> parameters) throws UIException {
        String scope;
        String resultsPerPage;
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String numSearchField = request.getParameter("num_search_field");
        if (numSearchField != null) {
            parameters.put("num_search_field", numSearchField);
        }
        if ((resultsPerPage = request.getParameter("results_per_page")) != null) {
            parameters.put("results_per_page", resultsPerPage);
        }
        if ((scope = request.getParameter("scope")) != null) {
            parameters.put("scope", scope);
        }
        for (SearchField searchField : this.getSearchFields(request)) {
            int index = searchField.getIndex();
            String field = searchField.getField();
            String query = searchField.getQuery();
            String conjunction = searchField.getConjunction();
            parameters.put("conjunction" + index, conjunction);
            parameters.put("field" + index, field);
            parameters.put("query" + index, query);
        }
        if (parameters.get("page") == null) {
            parameters.put("page", String.valueOf(this.getParameterPage()));
        }
        if (parameters.get("rpp") == null) {
            parameters.put("rpp", String.valueOf(this.getParameterRpp()));
        }
        if (parameters.get("sort_by") == null) {
            parameters.put("sort_by", String.valueOf(this.getParameterSortBy()));
        }
        if (parameters.get("order") == null) {
            parameters.put("order", this.getParameterOrder());
        }
        if (parameters.get("etal") == null) {
            parameters.put("etal", String.valueOf(this.getParameterEtAl()));
        }
        return AbstractSearch.generateURL("advanced-search", parameters);
    }

    @Override
    protected String getQuery() throws UIException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        return this.buildQuery(this.getSearchFields(request));
    }

    private String buildQuery(List<SearchField> fields) {
        Perl5Util util = new Perl5Util();
        StringBuilder query = new StringBuilder();
        query.append("(");
        for (SearchField field : fields) {
            if (field.getQuery() == null) continue;
            if (fields.indexOf(field) > 0) {
                query.append(" ").append(field.getConjunction()).append(" ").toString();
            }
            if ("ANY".equals(field.getField())) {
                query.append("(").append(field.getQuery()).append(")").toString();
                continue;
            }
            String subQuery = util.substitute("s/'(.*)'/\"$1\"/g", field.getQuery());
            if (!util.match("/\".*\"/", subQuery)) {
                subQuery = util.substitute("s/[ ]+/ " + field.getField() + ":/g", subQuery);
            }
            query.append("(").append(field.getField()).append(":").append(subQuery).append(")").toString();
        }
        if (query.length() == 1) {
            return "";
        }
        return query.append(")").toString();
    }

    public List<SearchField> getSearchFields(Request request) throws UIException {
        int numSearchField;
        if (this.fields != null) {
            return this.fields;
        }
        try {
            String numSearchFieldStr = request.getParameter("num_search_field");
            numSearchField = Integer.valueOf(numSearchFieldStr);
        }
        catch (NumberFormatException nfe) {
            numSearchField = 12;
        }
        ArrayList<SearchField> fields = new ArrayList<SearchField>();
        for (int i = 1; i <= numSearchField; ++i) {
            String field = request.getParameter("field" + i);
            String query = AdvancedSearch.decodeFromURL(request.getParameter("query" + i));
            String conjunction = request.getParameter("conjunction" + i);
            if (field != null && (field = field.trim()).length() == 0) {
                field = null;
            }
            if (query != null && (query = query.trim()).length() == 0) {
                query = null;
            }
            if (conjunction != null && (conjunction = conjunction.trim()).length() == 0) {
                conjunction = null;
            }
            if (field == null) {
                field = "ANY";
            }
            if (conjunction == null) {
                conjunction = "AND";
            }
            if (query == null) continue;
            fields.add(new SearchField(i, field, query, conjunction));
        }
        this.fields = fields;
        return this.fields;
    }

    private static class SearchField {
        private int index;
        private String field;
        private String query;
        private String conjuction;

        public SearchField(int index, String field, String query, String conjunction) {
            this.index = index;
            this.field = field;
            this.query = query;
            this.conjuction = conjunction;
        }

        public int getIndex() {
            return this.index;
        }

        public String getField() {
            return this.field;
        }

        public String getQuery() {
            return this.query;
        }

        public String getConjunction() {
            return this.conjuction;
        }
    }
}

