/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import com.sun.syndication.io.FeedException;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.util.HashUtil;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.util.SyndicationFeed;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.FeedUtils;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.browse.BrowseEngine;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowserScope;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.handle.HandleManager;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DSpaceFeedGenerator
extends AbstractGenerator
implements Configurable,
CacheableProcessingComponent,
Recyclable {
    private static final Logger log = Logger.getLogger(DSpaceFeedGenerator.class);
    private String format = null;
    private String handle = null;
    private static final int ITEM_COUNT = ConfigurationManager.getIntProperty((String)"webui.feed.items");
    private static final long CACHE_AGE;
    private static boolean includeRestrictedItems;
    private DSpaceValidity validity = null;
    private Item[] recentSubmissionItems;

    public Serializable getKey() {
        String key = "key:" + this.handle + ":" + this.format;
        return Long.valueOf(HashUtil.hash((String)key));
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            try {
                FeedValidity validity = new FeedValidity();
                Context context = ContextUtil.obtainContext(this.objectModel);
                DSpaceObject dso = null;
                if (this.handle != null && !this.handle.contains("site")) {
                    dso = HandleManager.resolveToObject((Context)context, (String)this.handle);
                }
                validity.add(dso);
                for (Item item : this.getRecentlySubmittedItems(context, dso)) {
                    validity.add((DSpaceObject)item);
                }
                this.validity = ((DSpaceValidity)validity).complete();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.validity;
    }

    public void configure(Configuration conf) throws ConfigurationException {
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.format = par.getParameter("feedFormat", null);
        this.handle = par.getParameter("handle", null);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            Context context = ContextUtil.obtainContext(this.objectModel);
            DSpaceObject dso = null;
            if (this.handle != null && !this.handle.contains("site")) {
                dso = HandleManager.resolveToObject((Context)context, (String)this.handle);
                if (dso == null) {
                    throw new ResourceNotFoundException("Unable to find DSpace object matching the given handle: " + this.handle);
                }
                if (dso.getType() != 3 && dso.getType() != 4) {
                    throw new ResourceNotFoundException("Unable to syndicate DSpace object: " + this.handle);
                }
            }
            SyndicationFeed feed = new SyndicationFeed("xmlui");
            feed.populate((HttpServletRequest)ObjectModelHelper.getRequest((Map)this.objectModel), dso, (DSpaceObject[])this.getRecentlySubmittedItems(context, dso), FeedUtils.i18nLabels);
            feed.setType(this.format);
            Document dom = feed.outputW3CDom();
            FeedUtils.unmangleI18N(dom);
            DOMStreamer streamer = new DOMStreamer(this.contentHandler, this.lexicalHandler);
            streamer.stream((Node)dom);
        }
        catch (IllegalArgumentException iae) {
            throw new ResourceNotFoundException("Syndication feed format, '" + this.format + "', is not supported.", (Throwable)iae);
        }
        catch (FeedException fe) {
            throw new SAXException((Exception)((Object)fe));
        }
        catch (SQLException sqle) {
            throw new SAXException(sqle);
        }
    }

    private Item[] getRecentlySubmittedItems(Context context, DSpaceObject dso) throws SQLException {
        if (this.recentSubmissionItems != null) {
            return this.recentSubmissionItems;
        }
        String source = ConfigurationManager.getProperty((String)"recent.submissions.sort-option");
        BrowserScope scope = new BrowserScope(context);
        if (dso instanceof Collection) {
            scope.setCollection((Collection)dso);
        } else if (dso instanceof Community) {
            scope.setCommunity((Community)dso);
        }
        scope.setResultsPerPage(ITEM_COUNT);
        try {
            scope.setBrowseIndex(BrowseIndex.getItemBrowseIndex());
            for (SortOption so : SortOption.getSortOptions()) {
                if (!so.getName().equals(source)) continue;
                scope.setSortBy(so.getNumber());
                scope.setOrder("DESC");
            }
            BrowseEngine be = new BrowseEngine(context);
            this.recentSubmissionItems = be.browseMini(scope).getItemResults(context);
            if (!includeRestrictedItems) {
                ArrayList<Item> result = new ArrayList<Item>();
                block4: for (Item item : this.recentSubmissionItems) {
                    for (Group group : AuthorizeManager.getAuthorizedGroups((Context)context, (DSpaceObject)item, (int)0)) {
                        if (group.getID() != 0) continue;
                        result.add(item);
                        continue block4;
                    }
                }
                this.recentSubmissionItems = result.toArray(new Item[result.size()]);
            }
        }
        catch (BrowseException bex) {
            log.error((Object)"Caught browse exception", (Throwable)bex);
        }
        catch (SortException e) {
            log.error((Object)"Caught sort exception", (Throwable)e);
        }
        return this.recentSubmissionItems;
    }

    public void recycle() {
        this.format = null;
        this.handle = null;
        this.validity = null;
        this.recentSubmissionItems = null;
        super.recycle();
    }

    static {
        String ageCfgName = "webui.feed.cache.age";
        long ageCfg = ConfigurationManager.getIntProperty((String)"webui.feed.cache.age", (int)24);
        CACHE_AGE = 3600000L * ageCfg;
        includeRestrictedItems = ConfigurationManager.getBooleanProperty((String)"harvest.includerestricted.rss", (boolean)true);
    }

    private static class FeedValidity
    extends DSpaceValidity {
        private static final long serialVersionUID = 1L;
        private long expires = 0L;

        private FeedValidity() {
        }

        @Override
        public DSpaceValidity complete() {
            this.expires = System.currentTimeMillis() + CACHE_AGE;
            return super.complete();
        }

        @Override
        public int isValid() {
            if (this.completed) {
                if (System.currentTimeMillis() < this.expires) {
                    return 1;
                }
                return 0;
            }
            return -1;
        }

        @Override
        public int isValid(SourceValidity otherValidity) {
            if (this.completed && otherValidity instanceof FeedValidity) {
                FeedValidity other = (FeedValidity)otherValidity;
                if (this.hash == other.hash) {
                    this.expires = System.currentTimeMillis() + CACHE_AGE;
                    other.expires = System.currentTimeMillis() + CACHE_AGE;
                    return 1;
                }
            }
            return -1;
        }
    }
}

