/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing.element;

import org.dspace.app.xmlui.wing.AttributeMap;
import org.dspace.app.xmlui.wing.WingContext;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.StructuralElement;
import org.dspace.app.xmlui.wing.element.TextContainer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class Figure
extends TextContainer
implements StructuralElement {
    public static final String E_FIGURE = "figure";
    public static final String A_SOURCE = "source";
    public static final String A_TARGET = "target";
    public static final String A_TITLE = "title";
    public static final String A_RENDER = "rend";
    private String source;
    private String target;
    private String title;
    private String rend;

    protected Figure(WingContext context, String source, String target, String rend) throws WingException {
        super(context);
        this.require(source, "The 'source' parameter is required for all figures.");
        this.source = source;
        this.target = target;
        this.rend = rend;
    }

    protected Figure(WingContext context, String source, String target, String title, String rend) throws WingException {
        super(context);
        this.require(source, "The 'source' parameter is required for all figures.");
        this.source = source;
        this.target = target;
        this.title = title;
        this.rend = rend;
    }

    @Override
    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, NamespaceSupport namespaces) throws SAXException {
        AttributeMap attributes = new AttributeMap();
        attributes.put(A_SOURCE, this.source);
        if (this.target != null) {
            attributes.put(A_TARGET, this.target);
        }
        if (this.title != null) {
            attributes.put(A_TITLE, this.title);
        }
        if (this.rend != null) {
            attributes.put(A_RENDER, this.rend);
        }
        this.startElement(contentHandler, namespaces, E_FIGURE, attributes);
        super.toSAX(contentHandler, lexicalHandler, namespaces);
        this.endElement(contentHandler, namespaces, E_FIGURE);
    }
}

