/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing.element;

import java.util.ArrayList;
import org.dspace.app.xmlui.wing.AttributeMap;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingConstants;
import org.dspace.app.xmlui.wing.WingContext;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.AbstractWingElement;
import org.dspace.app.xmlui.wing.element.Head;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.Label;
import org.dspace.app.xmlui.wing.element.StructuralElement;
import org.dspace.app.xmlui.wing.element.WingMergeableElement;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class List
extends AbstractWingElement
implements WingMergeableElement,
StructuralElement {
    public static final String E_LIST = "list";
    public static final String A_TYPE = "type";
    private boolean merged = false;
    private boolean childMerged = false;
    public static final String TYPE_SIMPLE = "simple";
    public static final String TYPE_ORDERED = "ordered";
    public static final String TYPE_BULLETED = "bulleted";
    public static final String TYPE_GLOSS = "gloss";
    public static final String TYPE_PROGRESS = "progress";
    public static final String TYPE_FORM = "form";
    public static final String[] TYPES = new String[]{"simple", "ordered", "bulleted", "gloss", "progress", "form"};
    private String name;
    private String type;
    private String rend;
    private Head head;
    private java.util.List<AbstractWingElement> contents = new ArrayList<AbstractWingElement>();

    protected List(WingContext context, String name, String type, String rend) throws WingException {
        super(context);
        this.require(name, "The 'name' parameter is required for all lists.");
        this.restrict(type, TYPES, "The 'type' parameter must be one of these values: 'simple', 'ordered', 'bulleted', 'gloss', or 'form'.");
        this.name = name;
        this.type = type;
        this.rend = rend;
    }

    public Head setHead() throws WingException {
        Head head;
        this.head = head = new Head(this.context, null);
        return head;
    }

    public void setHead(String characters) throws WingException {
        Head head = this.setHead();
        head.addContent(characters);
    }

    public void setHead(Message key) throws WingException {
        Head head = this.setHead();
        head.addContent(key);
    }

    public Label addLabel(String name, String rend) throws WingException {
        Label label = new Label(this.context, name, rend);
        this.contents.add(label);
        return label;
    }

    public void addLabel(String characters) throws WingException {
        this.require(characters, "The 'characters' parameter is required for list labels.");
        Label label = new Label(this.context, null, null);
        label.addContent(characters);
        this.contents.add(label);
    }

    public void addLabel() throws WingException {
        Label label = new Label(this.context, null, null);
        this.contents.add(label);
    }

    public void addLabel(Message key) throws WingException {
        this.require(key, "The 'key' parameter is required for list labels.");
        Label label = new Label(this.context, null, null);
        label.addContent(key);
        this.contents.add(label);
    }

    public Item addItem() throws WingException {
        return this.addItem(null, null);
    }

    public Item addItem(String name, String rend) throws WingException {
        Item item = new Item(this.context, name, rend);
        this.contents.add(item);
        return item;
    }

    public void addItem(String characters) throws WingException {
        this.require(characters, "The 'characters' parameter is required for list items.");
        Item item = this.addItem(null, null);
        item.addContent(characters);
    }

    public void addItem(Message key) throws WingException {
        this.require(key, "The 'key' parameter is required for list items.");
        Item item = this.addItem(null, null);
        item.addContent(key);
    }

    public void addItemXref(String target, String characters) throws WingException {
        Item item = this.addItem(null, null);
        item.addXref(target, characters);
    }

    public void addItemXref(String target, Message key) throws WingException {
        Item item = this.addItem(null, null);
        item.addXref(target, key);
    }

    public List addList(String name, String type, String rend) throws WingException {
        List list = new List(this.context, name, type, rend);
        this.contents.add(list);
        return list;
    }

    public List addList(String name, String type) throws WingException {
        List list = new List(this.context, name, type, null);
        this.contents.add(list);
        return list;
    }

    public List addList(String name) throws WingException {
        return this.addList(name, null, null);
    }

    @Override
    public boolean mergeEqual(String namespace, String localName, String qName, Attributes attributes) {
        if (!WingConstants.DRI.URI.equals(namespace)) {
            return false;
        }
        if (!E_LIST.equals(localName)) {
            return false;
        }
        String name = attributes.getValue("n");
        if (name == null) {
            return false;
        }
        return name.equals(this.name);
    }

    @Override
    public WingMergeableElement mergeChild(String namespace, String localName, String qName, Attributes attributes) throws SAXException, WingException {
        this.childMerged = true;
        WingMergeableElement found = null;
        for (AbstractWingElement content : this.contents) {
            WingMergeableElement candidate;
            if (!(content instanceof WingMergeableElement) || !(candidate = (WingMergeableElement)((Object)content)).mergeEqual(namespace, localName, qName, attributes)) continue;
            found = candidate;
        }
        this.contents.remove(found);
        return found;
    }

    @Override
    public Attributes merge(Attributes attributes) throws SAXException, WingException {
        this.merged = true;
        return attributes;
    }

    @Override
    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, NamespaceSupport namespaces) throws SAXException {
        if (!this.merged) {
            AttributeMap attributes = new AttributeMap();
            attributes.put("n", this.name);
            attributes.put("id", this.context.generateID(E_LIST, this.name));
            if (this.type != null) {
                attributes.put(A_TYPE, this.type);
            }
            if (this.rend != null) {
                attributes.put("rend", this.rend);
            }
            this.startElement(contentHandler, namespaces, E_LIST, attributes);
        }
        if (!this.childMerged && this.head != null) {
            this.head.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        for (AbstractWingElement content : this.contents) {
            content.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        if (!this.merged) {
            this.endElement(contentHandler, namespaces, E_LIST);
        }
    }

    @Override
    public void dispose() {
        if (this.head != null) {
            this.head.dispose();
        }
        this.head = null;
        for (AbstractWingElement content : this.contents) {
            content.dispose();
        }
        this.contents.clear();
        this.contents = null;
        super.dispose();
    }
}

