/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing.element;

import java.util.ArrayList;
import java.util.List;
import org.dspace.app.xmlui.wing.AttributeMap;
import org.dspace.app.xmlui.wing.ObjectManager;
import org.dspace.app.xmlui.wing.WingContext;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.AbstractWingElement;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.app.xmlui.wing.element.StructuralElement;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class Reference
extends AbstractWingElement
implements StructuralElement {
    public static final String E_REFERENCE = "reference";
    public static final String A_REPOSITORY_ID = "repositoryID";
    public static final String A_TYPE = "type";
    public static final String A_URL = "url";
    private String repository;
    private String url;
    private String type;
    private List<AbstractWingElement> contents = new ArrayList<AbstractWingElement>();

    protected Reference(WingContext context, Object object) throws WingException {
        super(context);
        ObjectManager objectManager = context.getObjectManager();
        if (objectManager == null) {
            throw new WingException("Unable to reference object because no object manager has been defined.");
        }
        if (!objectManager.manageObject(object)) {
            throw new WingException("The available object manager is unable to manage the give object.");
        }
        this.url = objectManager.getObjectURL(object);
        this.repository = objectManager.getRepositoryIdentifier(object);
        this.type = objectManager.getObjectType(object);
    }

    public ReferenceSet addReferenceSet(String type, String orderBy, String render) throws WingException {
        ReferenceSet referenceSet = new ReferenceSet(this.context, true, null, type, orderBy, render);
        this.contents.add(referenceSet);
        return referenceSet;
    }

    public ReferenceSet addReferenceSet(String type, String orderBy) throws WingException {
        return this.addReferenceSet(type, orderBy, null);
    }

    public ReferenceSet addReferenceSet(String type) throws WingException {
        return this.addReferenceSet(type, null, null);
    }

    @Override
    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, NamespaceSupport namespaces) throws SAXException {
        AttributeMap attributes = new AttributeMap();
        attributes.put(A_REPOSITORY_ID, this.repository);
        attributes.put(A_URL, this.url);
        if (this.type != null) {
            attributes.put(A_TYPE, this.type);
        }
        this.startElement(contentHandler, namespaces, E_REFERENCE, attributes);
        for (AbstractWingElement content : this.contents) {
            content.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        this.endElement(contentHandler, namespaces, E_REFERENCE);
    }

    @Override
    public void dispose() {
        if (this.contents != null) {
            for (AbstractWingElement content : this.contents) {
                content.dispose();
            }
            this.contents.clear();
        }
        this.contents = null;
        super.dispose();
    }
}

