/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing.element;

import java.util.HashMap;
import java.util.Map;
import org.dspace.app.xmlui.wing.AttributeMap;
import org.dspace.app.xmlui.wing.ObjectManager;
import org.dspace.app.xmlui.wing.WingConstants;
import org.dspace.app.xmlui.wing.WingContext;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.AbstractWingElement;
import org.dspace.app.xmlui.wing.element.MetadataElement;
import org.dspace.app.xmlui.wing.element.WingMergeableElement;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class RepositoryMeta
extends AbstractWingElement
implements WingMergeableElement,
MetadataElement {
    public static final String E_REPOSITORY_META = "repositoryMeta";
    public static final String E_REPOSITORY = "repository";
    public static final String A_REPOSITORY_ID = "repositoryID";
    public static final String A_REPOSITORY_URL = "url";
    private boolean merged = false;
    private Map<String, String> repositories = new HashMap<String, String>();

    protected RepositoryMeta(WingContext context) throws WingException {
        super(context);
        ObjectManager objectManager = context.getObjectManager();
        if (objectManager != null) {
            this.repositories = objectManager.getAllManagedRepositories();
        }
    }

    @Override
    public boolean mergeEqual(String namespace, String localName, String qName, Attributes attributes) throws SAXException, WingException {
        if (!WingConstants.DRI.URI.equals(namespace)) {
            return false;
        }
        return E_REPOSITORY_META.equals(localName);
    }

    @Override
    public WingMergeableElement mergeChild(String namespace, String localName, String qName, Attributes attributes) throws SAXException, WingException {
        if (!WingConstants.DRI.URI.equals(namespace)) {
            return null;
        }
        if (!E_REPOSITORY.equals(localName)) {
            return null;
        }
        String repositoryIdentifier = attributes.getValue(A_REPOSITORY_ID);
        if (this.repositories.containsKey(repositoryIdentifier)) {
            this.repositories.remove(repositoryIdentifier);
        }
        return null;
    }

    @Override
    public Attributes merge(Attributes attributes) throws SAXException, WingException {
        this.merged = true;
        return attributes;
    }

    @Override
    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, NamespaceSupport namespaces) throws SAXException {
        if (!this.merged) {
            this.startElement(contentHandler, namespaces, E_REPOSITORY_META, null);
        }
        for (String identifier : this.repositories.keySet()) {
            AttributeMap attributes = new AttributeMap();
            attributes.put(A_REPOSITORY_ID, identifier);
            attributes.put(A_REPOSITORY_URL, this.repositories.get(identifier));
            this.startElement(contentHandler, namespaces, E_REPOSITORY, attributes);
            this.endElement(contentHandler, namespaces, E_REPOSITORY);
        }
        if (!this.merged) {
            this.endElement(contentHandler, namespaces, E_REPOSITORY_META);
        }
    }
}

