/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing.element;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dspace.app.xmlui.wing.WingConstants;
import org.dspace.app.xmlui.wing.WingContext;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.AbstractWingElement;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.SAXOutputter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class SimpleHTMLFragment
extends AbstractWingElement {
    private String fragment;
    private boolean blankLines;

    protected SimpleHTMLFragment(WingContext context, boolean blankLines, String fragment) throws WingException {
        super(context);
        this.blankLines = blankLines;
        this.fragment = fragment;
    }

    @Override
    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, NamespaceSupport namespaces) throws SAXException {
        try {
            String xml = "<fragment>" + this.fragment + "</fragment>";
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes());
            SAXBuilder builder = new SAXBuilder();
            Document document = builder.build((InputStream)inputStream);
            try {
                this.translate(document.getRootElement());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JDOMException("Error translating HTML fragment into DRI", (Throwable)e);
            }
            SAXFilter filter = new SAXFilter(contentHandler, lexicalHandler, namespaces);
            SAXOutputter outputter = new SAXOutputter();
            outputter.setContentHandler((ContentHandler)filter);
            outputter.setLexicalHandler((LexicalHandler)filter);
            Element root = document.getRootElement();
            List children = root.getChildren();
            for (Element child : children) {
                outputter.output(child);
            }
        }
        catch (JDOMException e) {
            this.startElement(contentHandler, namespaces, "p", null);
            this.sendCharacters(contentHandler, this.fragment);
            this.endElement(contentHandler, namespaces, "p");
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    private void removeContent(Content content) {
        if (content instanceof Element) {
            Element element = (Element)content;
            if (element.getContent().size() == 0) {
                StringBuilder replacement = new StringBuilder().append("<").append(element.getName());
                List attributes = element.getAttributes();
                for (Attribute attribute : attributes) {
                    replacement.append(" ").append(attribute.getName()).append("=\"").append(attribute.getValue()).append("\"").toString();
                }
                replacement.append("/>");
                Element parent = element.getParentElement();
                int index = parent.indexOf((Content)element);
                parent.setContent(index, (Content)new Text(replacement.toString()));
            } else {
                StringBuilder prepend = new StringBuilder();
                prepend.append("<").append(element.getName());
                List attributes = element.getAttributes();
                for (Attribute attribute : attributes) {
                    prepend.append(" ").append(attribute.getName()).append("=\"").append(attribute.getValue()).append("\"");
                }
                prepend.append(">");
                String postpend = "</" + element.getName() + ">";
                Element parent = element.getParentElement();
                int index = parent.indexOf((Content)element);
                parent.addContent(index, (Content)new Text(postpend));
                parent.addContent(index, (Collection)element.removeContent());
                parent.addContent(index, (Content)new Text(prepend.toString()));
                parent.removeContent((Content)element);
            }
        } else {
            Element parent = content.getParentElement();
            parent.removeContent(content);
        }
    }

    private boolean paragraphWrap(Element parent, int index, List<Content> contents) {
        if (contents == null || contents.size() <= 0) {
            return false;
        }
        boolean empty = true;
        for (Content content : contents) {
            if (!empty) continue;
            if (content instanceof Text) {
                Text text = (Text)content;
                if ("".equals(text.getTextNormalize())) continue;
                empty = false;
                continue;
            }
            empty = false;
        }
        if (empty) {
            return false;
        }
        Element para = new Element("p");
        para.addContent(contents);
        if (index >= 0) {
            parent.addContent(index, (Content)para);
        } else {
            parent.addContent((Content)para);
        }
        return true;
    }

    private void limitAttributes(Element element, String ... names) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (String name : names) {
            String value = element.getAttributeValue(name);
            if (value == null) continue;
            attributes.put(name, value);
        }
        element.setAttributes(new ArrayList());
        for (Map.Entry attr : attributes.entrySet()) {
            element.setAttribute((String)attr.getKey(), (String)attr.getValue());
        }
    }

    private void moveAttribute(Element element, String oldName, String newName) {
        Attribute attribute = element.getAttribute(oldName);
        if (attribute != null) {
            attribute.setName(newName);
        }
    }

    private void translate(Element parent) {
        for (int i = 0; i < parent.getContentSize(); ++i) {
            Content decedent = parent.getContent(i);
            if (decedent instanceof Text) continue;
            if (decedent instanceof Element) {
                Element element = (Element)decedent;
                String name = element.getName();
                if ("p".equals(name)) {
                    if (parent.isRootElement()) {
                        this.moveAttribute(element, "class", "rend");
                        this.limitAttributes(element, "id", "n", "rend");
                        this.translate(element);
                        continue;
                    }
                    this.removeContent((Content)element);
                    continue;
                }
                if ("h1".equals(name) || "h2".equals(name) || "h3".equals(name) || "h4".equals(name) || "h5".equals(name)) {
                    if (parent.isRootElement()) {
                        this.limitAttributes(element, new String[0]);
                        element.setName("p");
                        element.setAttribute("rend", "heading");
                        this.translate(element);
                        continue;
                    }
                    this.removeContent((Content)element);
                    continue;
                }
                if ("a".equals(name)) {
                    this.moveAttribute(element, "href", "target");
                    this.limitAttributes(element, "target");
                    element.setName("xref");
                    this.translate(element);
                    continue;
                }
                if ("ol".equals(name)) {
                    this.moveAttribute(element, "class", "rend");
                    this.limitAttributes(element, "id", "n", "rend");
                    element.setName("list");
                    element.setAttribute("type", "ordered");
                    this.translate(element);
                    continue;
                }
                if ("li".equals(name)) {
                    this.moveAttribute(element, "class", "rend");
                    this.limitAttributes(element, "id", "n", "rend");
                    element.setName("item");
                    this.translate(element);
                    continue;
                }
                if ("b".equals(name)) {
                    this.limitAttributes(element, new String[0]);
                    element.setName("hi");
                    element.setAttribute("rend", "bold");
                    this.translate(element);
                    continue;
                }
                if ("i".equals(name)) {
                    this.limitAttributes(element, new String[0]);
                    element.setName("hi");
                    element.setAttribute("rend", "italic");
                    this.translate(element);
                    continue;
                }
                if ("u".equals(name)) {
                    this.limitAttributes(element, new String[0]);
                    element.setName("hi");
                    element.setAttribute("rend", "underline");
                    this.translate(element);
                    continue;
                }
                if ("img".equals(name)) {
                    this.moveAttribute(element, "src", "source");
                    this.limitAttributes(element, "source");
                    element.setName("figure");
                    this.translate(element);
                    continue;
                }
                if ("hi".equals(name)) {
                    this.limitAttributes(element, "rend");
                    this.translate(element);
                    continue;
                }
                if ("xref".equals(name)) {
                    this.limitAttributes(element, "target");
                    this.translate(element);
                    continue;
                }
                if ("figure".equals(name)) {
                    this.limitAttributes(element, "rend", "source", "target");
                    this.translate(element);
                    continue;
                }
                this.removeContent(decedent);
                continue;
            }
            this.removeContent(decedent);
        }
        if (parent.isRootElement()) {
            ArrayList<Content> removed = new ArrayList<Content>();
            for (int i = 0; i < parent.getContentSize(); ++i) {
                Content current = parent.getContent(i);
                if (current instanceof Element && "p".equals(((Element)current).getName())) {
                    if (!this.paragraphWrap(parent, i, removed)) continue;
                    removed.clear();
                    ++i;
                    continue;
                }
                if (current instanceof Element && "list".equals(((Element)current).getName())) {
                    if (!this.paragraphWrap(parent, i, removed)) continue;
                    removed.clear();
                    ++i;
                    continue;
                }
                if (this.blankLines && current instanceof Text) {
                    String rawText = ((Text)current).getText();
                    parent.removeContent(current);
                    --i;
                    String[] parts = rawText.split("\n\\s*\n");
                    if (parts.length <= 0) continue;
                    for (int partIdx = 0; partIdx < parts.length - 1; ++partIdx) {
                        removed.add((Content)new Text(parts[partIdx]));
                        if (!this.paragraphWrap(parent, i + 1, removed)) continue;
                        removed.clear();
                        ++i;
                    }
                    removed.add((Content)new Text(parts[parts.length - 1]));
                    continue;
                }
                removed.add(current);
                parent.removeContent(current);
                --i;
            }
            if (removed.size() > 0) {
                this.paragraphWrap(parent, -1, removed);
                removed.clear();
            }
        }
    }

    public static class SAXFilter
    implements ContentHandler,
    LexicalHandler {
        private final String URI;
        private ContentHandler contentHandler;
        private NamespaceSupport namespaces;

        public SAXFilter(ContentHandler contentHandler, LexicalHandler lexicalHandler, NamespaceSupport namespaces) {
            this.URI = WingConstants.DRI.URI;
            this.contentHandler = contentHandler;
            this.namespaces = namespaces;
        }

        private String qName(String localName) {
            String prefix = this.namespaces.getPrefix(this.URI);
            if (prefix == null || prefix.equals("")) {
                return localName;
            }
            return prefix + ":" + localName;
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.contentHandler.characters(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.contentHandler.endElement(this.URI, localName, this.qName(localName));
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.contentHandler.ignorableWhitespace(ch, start, length);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            this.contentHandler.skippedEntity(name);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.contentHandler.startElement(this.URI, localName, this.qName(localName), atts);
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
        }
    }
}

