/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing.element;

import org.dspace.app.xmlui.wing.AttributeMap;
import org.dspace.app.xmlui.wing.WingConstants;
import org.dspace.app.xmlui.wing.WingContext;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.AbstractWingElement;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Meta;
import org.dspace.app.xmlui.wing.element.Options;
import org.dspace.app.xmlui.wing.element.WingMergeableElement;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class WingDocument
extends AbstractWingElement
implements WingMergeableElement {
    public static final String E_DOCUMENT = "document";
    public static final String A_VERSION = "version";
    public static final String DOCUMENT_VERSION = "1.1";
    private boolean merged = false;
    private Meta meta;
    private Body body;
    private Options options;

    public WingDocument(WingContext context) throws WingException {
        super(context);
        this.meta = new Meta(context);
        this.body = new Body(context);
        this.options = new Options(context);
    }

    public Meta setMeta() throws WingException {
        return this.meta;
    }

    public Body setBody() throws WingException {
        return this.body;
    }

    public Options setOptions() throws WingException {
        return this.options;
    }

    @Override
    public boolean mergeEqual(String namespace, String localName, String qName, Attributes attributes) throws SAXException, WingException {
        if (!WingConstants.DRI.URI.equals(namespace)) {
            return false;
        }
        if (!E_DOCUMENT.equals(localName)) {
            return false;
        }
        String version = attributes.getValue(A_VERSION);
        if (!DOCUMENT_VERSION.equals(version)) {
            throw new WingException("Incompatable DRI versions, 1.1 != " + version);
        }
        return true;
    }

    @Override
    public WingMergeableElement mergeChild(String namespace, String localName, String qName, Attributes attributes) throws SAXException, WingException {
        if (this.meta != null && this.meta.mergeEqual(namespace, localName, qName, attributes)) {
            Meta child = this.meta;
            this.meta = null;
            return child;
        }
        if (this.body != null && this.body.mergeEqual(namespace, localName, qName, attributes)) {
            Body child = this.body;
            this.body = null;
            return child;
        }
        if (this.options != null && this.options.mergeEqual(namespace, localName, qName, attributes)) {
            Options options = this.options;
            this.options = null;
            return options;
        }
        return null;
    }

    @Override
    public Attributes merge(Attributes attributes) throws SAXException, WingException {
        this.merged = true;
        return attributes;
    }

    @Override
    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, NamespaceSupport namespaces) throws SAXException {
        if (!this.merged) {
            AttributeMap attributes = new AttributeMap();
            attributes.put(A_VERSION, DOCUMENT_VERSION);
            this.startElement(contentHandler, namespaces, E_DOCUMENT, attributes);
        }
        if (this.meta != null) {
            this.meta.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        if (this.body != null) {
            this.body.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        if (this.options != null) {
            this.options.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        if (!this.merged) {
            this.endElement(contentHandler, namespaces, E_DOCUMENT);
        }
    }

    @Override
    public void dispose() {
        if (this.meta != null) {
            this.meta.dispose();
        }
        if (this.body != null) {
            this.body.dispose();
        }
        if (this.options != null) {
            this.options.dispose();
        }
        this.meta = null;
        this.body = null;
        this.options = null;
        super.dispose();
    }
}

