/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.simplexml;

import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import net.cnri.simplexml.XTag;
import net.cnri.simplexml.XUtil;

public class XParser {
    private static boolean debug = false;
    private boolean ignoreUnKnown = true;
    private boolean stripNewLine = true;
    private boolean strictMode = false;

    private Hashtable parseTagAttributes(PushbackReader reader) throws IOException {
        Hashtable<String, String> attributes = null;
        String attName = null;
        String attVal = null;
        block6: while (true) {
            int ci;
            if ((ci = reader.read()) < 0) {
                throw new IOException("Unexpected end of input reading attributes");
            }
            char ch = (char)ci;
            switch (ch) {
                case '>': {
                    if (attName != null) {
                        if (attributes == null) {
                            attributes = new Hashtable<String, String>();
                        }
                        attributes.put(attName, attVal == null ? "NULL" : attVal);
                    }
                    return attributes;
                }
                case '=': {
                    if (attName == null) {
                        attName = "";
                    }
                    attVal = this.readToken(reader);
                    continue block6;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block6;
                }
                case '\"': {
                    if (attName != null) {
                        if (attributes == null) {
                            attributes = new Hashtable();
                        }
                        attributes.put(attName, attVal == null ? "NULL" : attVal);
                    }
                    attName = this.readRestOfString(ch, reader);
                    continue block6;
                }
            }
            if (attName != null) {
                if (attributes == null) {
                    attributes = new Hashtable();
                }
                attributes.put(attName, attVal == null ? "NULL" : attVal);
                attName = null;
            }
            reader.unread(ch);
            attName = this.readToken(reader);
        }
    }

    private String readToken(PushbackReader reader) throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int ci;
            if ((ci = reader.read()) < 0) {
                throw new IOException("Unexpected end of input reading token: " + sb);
            }
            char ch = (char)ci;
            if (Character.isWhitespace(ch)) {
                if (sb.length() <= 0) continue;
                return XUtil.decodeString(sb.toString());
            }
            if (ch == '\"') {
                if (sb.length() <= 0) {
                    return this.readRestOfString(ch, reader);
                }
                reader.unread(ch);
                return XUtil.decodeString(sb.toString());
            }
            if (ch == '=') {
                if (sb.length() <= 0) {
                    return String.valueOf(ch);
                }
                reader.unread(ch);
                return XUtil.decodeString(sb.toString());
            }
            if (ch == '>' || ch == '<') {
                if (sb.length() <= 0) {
                    return String.valueOf(ch);
                }
                reader.unread(ch);
                return XUtil.decodeString(sb.toString());
            }
            sb.append(ch);
        }
    }

    private String readRestOfString(char strBeginChar, PushbackReader reader) throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int ci;
            if ((ci = reader.read()) < 0) {
                throw new IOException("Unexpected end of input reading string: " + sb);
            }
            char ch = (char)ci;
            if (ch == strBeginChar) {
                return XUtil.decodeString(sb.toString());
            }
            sb.append(ch);
        }
    }

    private ParseTag readTagToken(PushbackReader reader) throws IOException {
        int ci;
        while ((ci = reader.read()) != 60) {
            if (ci >= 0) continue;
            return null;
        }
        StringBuffer name = new StringBuffer();
        ParseTag tag = new ParseTag();
        while ((ci = reader.read()) != 62) {
            if (ci < 0) {
                throw new IOException("Unexpected end of input reading tag");
            }
            char ch = (char)ci;
            if (ch == '/') {
                if (name.length() <= 0) {
                    tag.isAggregateEnd = true;
                    continue;
                }
                tag.isEndTag = true;
                continue;
            }
            if (Character.isWhitespace(ch)) {
                if (name.length() <= 0) continue;
                if (name.toString().startsWith("!--")) {
                    tag.name = "****************************";
                    tag.isComment = true;
                    String comment = "";
                    while (!comment.toString().endsWith("-->")) {
                        ci = reader.read();
                        if (ci < 0) {
                            throw new IOException("Unexpected end of input reading comment tag");
                        }
                        comment = comment + (char)ci;
                    }
                    tag.value = comment;
                    return tag;
                }
                tag.attributes = this.parseTagAttributes(reader);
                break;
            }
            name.append(ch);
        }
        tag.name = name.toString();
        return tag;
    }

    private String readTagType(PushbackReader reader) throws IOException {
        int ci;
        StringBuffer name = new StringBuffer();
        while ((ci = reader.read()) != 32) {
            if (ci >= 0) continue;
            throw new IOException("Unexpected end of input reading special tag type");
        }
        return name.toString();
    }

    private String readTagValue(PushbackReader reader) throws IOException {
        int ci;
        StringBuffer sb = new StringBuffer();
        while ((ci = reader.read()) != 60) {
            if (ci < 0) {
                throw new IOException("Unexpected end of input reading tag value");
            }
            sb.append((char)ci);
        }
        reader.unread(60);
        String s = sb.toString();
        if (this.stripNewLine && s.endsWith("\r\n")) {
            return XUtil.decodeString(s.substring(0, s.length() - 2));
        }
        if (this.stripNewLine && s.endsWith("\n")) {
            return XUtil.decodeString(s.substring(0, s.length() - 1));
        }
        return XUtil.decodeString(s);
    }

    private ParseTag parseNonRecursive(PushbackReader reader) throws IOException {
        Stack parseStack = new Stack();
        Stack<ParseTag> aggregateStack = new Stack<ParseTag>();
        while (true) {
            ParseTag tag = null;
            while ((tag = this.readTagToken(reader)) != null && tag.isComment) {
            }
            if (tag == null) {
                if (parseStack.size() <= 0) {
                    return null;
                }
                Stack tmpStack = new Stack();
                while (parseStack.size() > 1) {
                    tmpStack.push(parseStack.pop());
                }
                tag = (ParseTag)parseStack.pop();
                while (tmpStack.size() > 0) {
                    tag.addSubTag((ParseTag)tmpStack.pop());
                }
                return tag;
            }
            String tagname = tag.name.trim();
            if (debug) {
                System.err.println("read tag: " + tag);
            }
            if (tag.isAggregateEnd) {
                aggregateStack.clear();
                ParseTag subtag = null;
                while (true) {
                    if (parseStack.size() <= 0) {
                        if (this.strictMode) {
                            throw new IOException("Got end tag " + tagname + " with no matching begin tag");
                        }
                        while (aggregateStack.size() > 0) {
                            parseStack.push(aggregateStack.pop());
                        }
                        subtag = null;
                        break;
                    }
                    subtag = (ParseTag)parseStack.pop();
                    if (subtag.name.trim().equals(tagname) && subtag.getSubTagCount() <= 0) break;
                    aggregateStack.push(subtag);
                }
                if (subtag == null) continue;
                while (aggregateStack.size() > 0) {
                    subtag.addSubTag((ParseTag)aggregateStack.pop());
                }
                if (subtag.getSubTagCount() > 0) {
                    subtag.value = null;
                }
                if (parseStack.size() <= 0) {
                    return subtag;
                }
                parseStack.push(subtag);
                continue;
            }
            tag.value = this.readTagValue(reader);
            parseStack.push(tag);
        }
    }

    public XTag parse(Reader reader, boolean strict) throws Exception {
        ParseTag ptag = this.parseNonRecursive(new PushbackReader(reader));
        if (debug) {
            System.err.println("parsed tag: " + ptag);
        }
        if (ptag == null) {
            return null;
        }
        return this.convertToX(ptag, strict);
    }

    private XTag convertToX(ParseTag ptag, boolean strict) {
        XTag xTag = new XTag(ptag.name, ptag.value);
        xTag.setAttributes(ptag.attributes);
        for (int i = 0; i < ptag.getSubTagCount(); ++i) {
            xTag.addSubTag(this.convertToX(ptag.getSubTag(i), strict));
        }
        return xTag;
    }

    public static void main(String[] argv) throws Exception {
        debug = true;
        XParser parser = new XParser();
        XTag xTag = parser.parse(new FileReader(argv[0]), false);
        System.err.println("parsed: " + xTag);
    }

    private class ParseTag {
        String name = null;
        String value = null;
        Hashtable attributes = null;
        boolean isComment = false;
        boolean isEndTag = false;
        boolean isAggregateEnd = false;
        private Vector subtags = null;

        private ParseTag() {
        }

        void addSubTag(ParseTag subtag) {
            if (this.subtags == null) {
                this.subtags = new Vector();
            }
            this.subtags.addElement(subtag);
        }

        int getSubTagCount() {
            return this.subtags == null ? 0 : this.subtags.size();
        }

        ParseTag getSubTag(int i) {
            if (this.subtags == null) {
                return null;
            }
            if (i < 0 || i >= this.subtags.size()) {
                return null;
            }
            return (ParseTag)this.subtags.elementAt(i);
        }

        public void dump(PrintStream out, String indent) {
            out.print(indent + "<" + this.name);
            if (this.attributes != null) {
                Enumeration en = this.attributes.keys();
                while (en.hasMoreElements()) {
                    Object key = en.nextElement();
                    out.print(" " + key + "=" + this.attributes.get(key));
                }
            }
            out.print(">");
            if (this.value == null) {
                out.println("");
                for (int i = 0; i < this.getSubTagCount(); ++i) {
                    this.getSubTag(i).dump(out, indent + "...");
                }
                out.println("</" + this.name + ">");
            } else {
                out.println(String.valueOf(this.value));
            }
        }

        public String toString() {
            return this.name == null ? "null" : this.name;
        }
    }
}

