/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.batch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.util.StringTokenizer;

public class AvgRawData {
    public static void printUsage() {
        System.err.println("Usage: java net.handle.apps.batch.AvgRawData <rawdatafile> <howmany_raw_data:1_avgED_data> <avgED_file> <desired_col_num_in_avgED_file>");
        System.err.println("\nExample as: java net.handle.apps.batch.AvgRawData stat500 5 avgDataFile 1");
        System.err.println("will average 5 data rows in <stat500> file and average it and save to one row in <avgDataFile>.");
        System.err.println("For a statatistics file from updates, do as: java net.handle.apps.batch.AvgRawData statUpd500 5 avgUpdDataFile 3");
        System.err.println("so it will average every 5 raw data on resoltion time, remove value time, add value time seperately and save it.");
    }

    public static void main(String[] argv) throws Exception {
        BufferedReader fileRaw = null;
        FileWriter fileEven = null;
        if (argv.length != 4) {
            AvgRawData.printUsage();
            System.exit(-1);
            return;
        }
        String howmanytoEven = argv[1];
        int weight = 5;
        try {
            weight = Integer.valueOf(howmanytoEven);
        }
        catch (Exception e) {
            System.out.println("Using 5 as default.");
        }
        fileRaw = new BufferedReader(new FileReader(new File(argv[0])));
        fileEven = new FileWriter(argv[2]);
        int col = 1;
        if (argv.length > 3) {
            try {
                col = Integer.valueOf(argv[3]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (col < 1) {
            col = 1;
        }
        System.out.println("Column number is " + col);
        boolean totalNumber = false;
        int lineNum = 0;
        float[][] rawArry = new float[col][weight];
        int i = 0;
        while (true) {
            int commonIdx;
            String line = fileRaw.readLine();
            ++lineNum;
            if (line == null) break;
            if ((line = line.trim()).length() <= 0 || (commonIdx = line.indexOf(58)) > 0 || (commonIdx = line.indexOf(95)) > 0) continue;
            try {
                ++i;
                float raw = 0.0f;
                float sumLine = 0.0f;
                System.out.println("reading line " + line);
                StringTokenizer st = new StringTokenizer(line, "\t");
                if (st.hasMoreTokens()) {
                    int colInd = 0;
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if (col == 1) {
                            sumLine += Float.valueOf(token).floatValue();
                            continue;
                        }
                        rawArry[colInd][i - 1] = raw = Float.valueOf(token).floatValue();
                        System.out.println("reading " + token);
                        ++colInd;
                    }
                    if (col == 1) {
                        rawArry[0][i - 1] = sumLine;
                    }
                } else {
                    rawArry[0][i - 1] = raw = Float.valueOf(line).floatValue();
                    System.out.println("reading " + line);
                }
                if (i % weight != 0) continue;
                System.out.println("do averageING now");
                try {
                    int ind;
                    float[] sum = new float[col];
                    for (ind = 0; ind < col; ++ind) {
                        sum[ind] = 0.0f;
                    }
                    for (ind = 0; ind < col; ++ind) {
                        for (int j = 0; j < weight; ++j) {
                            int n = ind;
                            sum[n] = sum[n] + rawArry[ind][j];
                        }
                        sum[ind] = sum[ind] / (float)weight;
                    }
                    for (ind = 0; ind < col - 1; ++ind) {
                        fileEven.write(sum[ind] + "\t");
                        System.out.println("writing <" + sum[ind] + ">");
                    }
                    fileEven.write(sum[col - 1] + "\n");
                    System.out.println("writing <" + sum[col - 1] + ">");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                i = 0;
            }
            catch (Exception e) {
                if (!(e instanceof NumberFormatException)) continue;
                --i;
            }
        }
        try {
            ((Writer)fileEven).close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

