/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.batch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.Vector;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AddValueRequest;
import net.handle.hdllib.AdminRecord;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.CreateHandleRequest;
import net.handle.hdllib.DeleteHandleRequest;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ModifyValueRequest;
import net.handle.hdllib.RemoveValueRequest;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.SecretKeyAuthenticationInfo;
import net.handle.hdllib.Util;
import net.handle.util.IntTable;

public abstract class DOIBatch {
    private AuthenticationInfo authInfo = null;
    public static final String DOI_ADMIN_NA = "10.admin";
    public static final int SEC_KEY_IDX = 300;
    private static HandleResolver resolver = new HandleResolver();
    private static FileWriter log = null;
    private static Writer logStat = null;
    private static FileWriter failedBatchDOIsWriter = null;
    private static File failedBatchDOIs = null;
    private static String FAILED_BATCH_FILE_NAME = "failedbatchfile$$";

    public static void printUsage() {
        System.err.println("Usage: java net.handle.apps.batch.DOIBatch {ACDNU}[sS] <batchfile> <username> <password> <logfile> <statistics_file>\nOptions:\n\t-A assign aliases for handles\n\t-C create handles\n\t-D delete handles\n\t-N remove aliases for handles\n\t-U update handles\n\t-s specify statistics file name\n\t-S use sessions\nArguments within braces ({}) indicate that one of the arguments must be specified.\nArguments within brackets ([]) indicate optional arguments.\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        if (argv.length < 5) {
            DOIBatch.printUsage();
            System.exit(-1);
            return;
        }
        String opt = argv[0];
        String username = argv[2];
        String passwd = argv[3];
        boolean useSession = false;
        log = new FileWriter(argv[4]);
        if (opt.indexOf(83) >= 0) {
            useSession = true;
        }
        if (opt.indexOf(115) >= 0) {
            if (argv.length > 5) {
                logStat = new FileWriter(argv[5]);
            } else {
                System.err.println("Statistics file name must be specified with 's' option.");
                System.exit(-1);
            }
        }
        if (DOIBatch.resolver.traceMessages) {
            try {
                System.setErr(new PrintStream(new FileOutputStream(argv[4] + "Trace", true), true));
            }
            catch (Exception e) {
                System.err.println("Can not reassign the standard error to file.");
            }
        }
        byte[] idHandle = Util.encodeString("10.admin/" + username);
        SecretKeyAuthenticationInfo auth = new SecretKeyAuthenticationInfo(idHandle, 300, Util.encodeString(passwd));
        failedBatchDOIs = new File(FAILED_BATCH_FILE_NAME);
        if (failedBatchDOIs.exists()) {
            failedBatchDOIs.delete();
        }
        failedBatchDOIs = null;
        boolean prepSessionSuccess = true;
        for (int trying = 0; trying == 0 || trying == 1 && failedBatchDOIs != null && failedBatchDOIs.exists(); ++trying) {
            String currProcessDOI = argv[1];
            if (trying > 0) {
                currProcessDOI = FAILED_BATCH_FILE_NAME;
                log = new FileWriter(argv[4], true);
                log.write("\n\n");
                log.write("====================================================================\n");
                log.write("             Retrying to process failed DOIs ....\n");
                log.write("====================================================================\n\n");
            }
            if (useSession) {
                // empty if block
            }
            try {
                FileInputStream f = new FileInputStream(currProcessDOI);
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)f, "UTF-8"));
                if (opt.indexOf(67) >= 0) {
                    DOIBatch.processBatchCreate(auth, in, new PrintWriter(System.out));
                    continue;
                }
                if (opt.indexOf(68) >= 0) {
                    DOIBatch.processBatchDelete(auth, in, new PrintWriter(System.out));
                    continue;
                }
                if (opt.indexOf(65) >= 0) {
                    DOIBatch.processBatchAlias(auth, in, new PrintWriter(System.out));
                    continue;
                }
                if (opt.indexOf(78) >= 0) {
                    DOIBatch.processBatchUnalias(auth, in, new PrintWriter(System.out));
                    continue;
                }
                if (opt.indexOf(85) >= 0) {
                    DOIBatch.processBatchUpdate(auth, in, new PrintWriter(System.out));
                    continue;
                }
                if (opt.indexOf(77) >= 0) {
                    DOIBatch.processBatchModify(auth, in, new PrintWriter(System.out));
                    continue;
                }
                DOIBatch.printUsage();
                System.exit(-1);
                continue;
            }
            catch (Exception e) {
                log.write("Error processing batch: " + e + "\n");
                e.printStackTrace();
                log.close();
                if (logStat != null) {
                    logStat.close();
                }
                System.exit(-1);
                continue;
            }
            finally {
                try {
                    log.close();
                    if (logStat != null) {
                        logStat.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (failedBatchDOIsWriter != null) {
                        failedBatchDOIsWriter.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        if (failedBatchDOIs != null && failedBatchDOIs.exists()) {
            failedBatchDOIs.delete();
        }
        FileOutputStream logOut = null;
        File tracefile = null;
        Object outfile = null;
        FileInputStream traceIn = null;
        try {
            if (DOIBatch.resolver.traceMessages) {
                logOut = new FileOutputStream(argv[4], true);
                logOut.write(Util.encodeString("\n     ---------------------------------"));
                logOut.write(Util.encodeString("\nHere comes the tracing messages ...\n"));
                tracefile = new File(argv[4] + "Trace");
                traceIn = new FileInputStream(tracefile);
                byte[] block = new byte[4096];
                int r = 0;
                do {
                    r = traceIn.read(block);
                    logOut.write(block, 0, r);
                    logOut.flush();
                } while (r >= 4096);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (logOut != null) {
                logOut.close();
            }
            if (traceIn != null) {
                traceIn.close();
            }
            System.err.close();
            if (tracefile != null && tracefile.exists()) {
                tracefile.delete();
            }
        }
        System.out.println("FINISHED.");
    }

    static void writeToBatchFailure(String failedLine) {
        if (failedBatchDOIs == null || failedBatchDOIsWriter == null) {
            try {
                failedBatchDOIs = new File(FAILED_BATCH_FILE_NAME);
                failedBatchDOIsWriter = new FileWriter(failedBatchDOIs);
            }
            catch (Exception e) {
                failedBatchDOIs = null;
                failedBatchDOIsWriter = null;
            }
        }
        try {
            if (failedBatchDOIsWriter != null) {
                failedBatchDOIsWriter.write(failedLine + "\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void processBatchCreate(AuthenticationInfo auth, BufferedReader in, PrintWriter out) throws Exception {
        int startIdx = 0;
        int endIdx = 0;
        int lineNum = 0;
        int successes = 0;
        int warnings = 0;
        int records = 0;
        long timeStarted = System.currentTimeMillis();
        Calendar calStart = Calendar.getInstance();
        String currenttime = calStart.getTime().toString();
        log.write("Batch started at " + currenttime + "\n");
        if (logStat != null) {
            logStat.write("Batch action: CREATE \n");
            logStat.write("Data: processing time per request in second \n");
            logStat.write("Note: please see your log file for success status\n\n");
        }
        long eachStart = 0L;
        while (true) {
            block20: {
                String line = in.readLine();
                ++lineNum;
                if (line == null) break;
                if ((line = line.trim()).length() <= 0) continue;
                int spaceIdx = line.indexOf(32);
                if (spaceIdx <= 0) {
                    log.write("Invalid line (" + lineNum + "): " + line + "\n");
                    continue;
                }
                if (logStat != null) {
                    eachStart = System.currentTimeMillis();
                }
                String handle = line.substring(0, spaceIdx);
                Vector<String> url = new Vector<String>();
                if (line.length() > 0) {
                    startIdx = line.indexOf(32, 0);
                    endIdx = line.indexOf(32, startIdx + 1);
                    for (int i = 0; i < line.length(); ++i) {
                        if (endIdx == -1) {
                            endIdx = line.length();
                            url.addElement(line.substring(startIdx + 1, endIdx).trim());
                            break;
                        }
                        if (line.substring(startIdx + 1, endIdx).trim().length() > 0) {
                            url.addElement(line.substring(startIdx + 1, endIdx).trim());
                        }
                        if (endIdx == 0) continue;
                        startIdx = endIdx;
                        endIdx = line.indexOf(32, startIdx + 1);
                    }
                }
                HandleValue[] values = new HandleValue[url.size() + 1];
                for (int j = 0; j < url.size(); ++j) {
                    values[j] = new HandleValue();
                    values[j].setIndex(j + 1);
                    values[j].setType(Common.STD_TYPE_URL);
                    values[j].setData(Util.encodeString((String)url.elementAt(j)));
                }
                values[url.size()] = new HandleValue();
                values[url.size()].setIndex(100);
                values[url.size()].setType(Common.STD_TYPE_HSADMIN);
                values[url.size()].setData(null);
                log.write("Operation: create\n");
                CreateHandleRequest chReq = new CreateHandleRequest(null, values, auth);
                chReq.handle = Util.encodeString(handle);
                AdminRecord admin = new AdminRecord(Util.encodeString("0.na/" + Util.decodeString(Util.getNAPart(chReq.handle))), 200, false, true, false, false, true, true, true, true, true, true, true, true);
                chReq.values[url.size()].setData(Encoder.encodeAdminRecord(admin));
                ++records;
                chReq.clearBuffers();
                AbstractResponse response = null;
                try {
                    response = resolver.processRequest(chReq);
                    if (response.responseCode == 1) {
                        ++successes;
                        log.write("SUCCESS:" + (lineNum - 1) + ":ADD:" + handle + "\n");
                    } else if (response.responseCode == 101) {
                        log.write("WARNING: HANDLE ALREADY EXISTS: line " + (lineNum - 1) + " " + line + "\n");
                        ++warnings;
                    } else {
                        log.write("ERROR: " + response + ": line " + (lineNum - 1) + " " + line + "\n");
                    }
                }
                catch (HandleException e) {
                    log.write("ERROR: " + e.getMessage() + ": line " + (lineNum - 1) + " " + line + "\n");
                    if (e.getCode() != 7) break block20;
                    DOIBatch.writeToBatchFailure(line);
                }
            }
            try {
                log.flush();
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (logStat == null) continue;
            double fl = (float)(System.currentTimeMillis() - eachStart) / 1000.0f;
            logStat.write(fl + "\n");
            try {
                logStat.flush();
            }
            catch (Throwable t) {}
        }
        long timeEnded = System.currentTimeMillis();
        Calendar calEnd = Calendar.getInstance();
        String currenttime1 = calEnd.getTime().toString();
        log.write("Batch started at " + currenttime + "\n");
        log.write("Batch finished at " + currenttime1 + "\n");
        float totalExec = (float)(timeEnded - timeStarted) / 1000.0f;
        log.write("Batch total execution time " + Float.toString(totalExec) + " seconds.\n");
        log.write("SUMMARY:CREATE: " + successes + '/' + records + " successes " + (records - successes - warnings) + '/' + records + " errors\n");
        float perRequestExec = records > 0 ? totalExec / (float)records : Float.NaN;
        log.write("STATISTICS SUMMARY:CREATE PROCESSING TIME: " + Float.toString(perRequestExec) + " seconds per request.\n\n");
        if (logStat != null) {
            logStat.write("\nTotal processing time: " + totalExec + " seconds for " + records + " records.");
            logStat.write("\nAverage processing time: " + perRequestExec + " second per request.");
        }
    }

    static void processBatchUpdate(AuthenticationInfo auth, BufferedReader in, PrintWriter out) throws Exception {
        int startIdx = 0;
        int endIdx = 0;
        int lineNum = 0;
        int successes = 0;
        int records = 0;
        long timeStarted = System.currentTimeMillis();
        Calendar calStart = Calendar.getInstance();
        String currenttime = calStart.getTime().toString();
        log.write("Batch started at " + currenttime + "\n");
        if (logStat != null) {
            logStat.write("Batch action: UPDATE \n");
            logStat.write("Data: processing time per request in second \n");
            logStat.write("Note: please see your log file for success status \n\n");
            logStat.write("RESOLUTION REMOVE_VAL ADD_VAL\n");
        }
        long eachStart = 0L;
        long eachReslDone = 0L;
        long eachRemValDone = 0L;
        while (true) {
            block38: {
                int[] indices;
                Vector<HandleValue> deleteValues;
                HandleValue[] currentValues;
                AbstractResponse response;
                String handle;
                Vector<String> newUrls;
                String line;
                block37: {
                    block36: {
                        line = in.readLine();
                        ++lineNum;
                        if (line == null) break;
                        if ((line = line.trim()).length() <= 0) continue;
                        int spaceIdx = line.indexOf(32);
                        if (spaceIdx <= 0) {
                            log.write("Invalid line (" + lineNum + "): " + line + "\n");
                            continue;
                        }
                        if (logStat != null) {
                            eachStart = System.currentTimeMillis();
                        }
                        newUrls = new Vector<String>();
                        if (line.length() > 0) {
                            startIdx = line.indexOf(32, 0);
                            endIdx = line.indexOf(32, startIdx + 1);
                            for (int i = 0; i < line.length(); ++i) {
                                if (endIdx == -1) {
                                    endIdx = line.length();
                                    newUrls.addElement(line.substring(startIdx + 1, endIdx).trim());
                                    break;
                                }
                                if (line.substring(startIdx + 1, endIdx).trim().length() > 0) {
                                    newUrls.addElement(line.substring(startIdx + 1, endIdx).trim());
                                }
                                if (endIdx == 0) continue;
                                startIdx = endIdx;
                                endIdx = line.indexOf(32, startIdx + 1);
                            }
                        }
                        handle = line.substring(0, spaceIdx);
                        ResolutionRequest rReq = new ResolutionRequest(Util.encodeString(handle), null, null, auth);
                        rReq.authoritative = true;
                        try {
                            response = resolver.processRequest(rReq);
                            if (response.responseCode == 1) {
                                currentValues = ((ResolutionResponse)response).getHandleValues();
                                break block36;
                            }
                            if (response.responseCode == 100) {
                                currentValues = null;
                                log.write("WARNING: HANDLE NOT FOUND: line " + (lineNum - 1) + " " + line + "\n");
                                continue;
                            }
                            log.write("ERROR: " + response.responseCode + " " + AbstractMessage.getResponseCodeMessage(response.responseCode) + ": trying to retrieve handle, line " + (lineNum - 1) + " " + line + "\n");
                        }
                        catch (HandleException e) {
                            log.write("ERROR: " + e.getCode() + " " + HandleException.getCodeStr(e.getCode()) + ": trying to retrieve handle, line " + (lineNum - 1) + " " + line + "\n");
                            if (e.getCode() != 7) continue;
                            DOIBatch.writeToBatchFailure(line);
                        }
                        continue;
                    }
                    if (logStat != null) {
                        eachReslDone = System.currentTimeMillis();
                        logStat.write((float)(eachReslDone - eachStart) / 1000.0f + "\t");
                    }
                    deleteValues = new Vector<HandleValue>();
                    indices = null;
                    if (currentValues != null) {
                        indices = new int[currentValues.length];
                    }
                    for (int i = 0; currentValues != null && i < currentValues.length; ++i) {
                        indices[i] = currentValues[i].getIndex();
                        if (!currentValues[i].hasType(Common.STD_TYPE_URL)) continue;
                        deleteValues.addElement(currentValues[i]);
                    }
                    RemoveValueRequest rmReq = new RemoveValueRequest(null, null, auth);
                    if (deleteValues != null) {
                        rmReq.handle = Util.encodeString(handle);
                        int[] indexesToDelete = new int[deleteValues.size()];
                        for (int i = 0; i < indexesToDelete.length; ++i) {
                            indexesToDelete[i] = ((HandleValue)deleteValues.elementAt(i)).getIndex();
                        }
                        rmReq.indexes = indexesToDelete;
                        rmReq.clearBuffers();
                        try {
                            response = resolver.processRequest(rmReq);
                            if (response.responseCode != 1 && response.responseCode != 200) {
                                log.write("ERROR: " + response.responseCode + " " + AbstractMessage.getResponseCodeMessage(response.responseCode) + ": removing old aliases, line " + (lineNum - 1) + " " + line + "\n");
                            }
                            break block37;
                        }
                        catch (HandleException e) {
                            log.write("ERROR: " + e.getCode() + " " + HandleException.getCodeStr(e.getCode()) + ": removing old aliases, line " + (lineNum - 1) + " " + line + "\n");
                            if (e.getCode() != 7) continue;
                            DOIBatch.writeToBatchFailure(line);
                        }
                        continue;
                    }
                }
                if (logStat != null) {
                    eachRemValDone = System.currentTimeMillis();
                    logStat.write((float)(eachRemValDone - eachReslDone) / 1000.0f + "\t");
                }
                HandleValue[] newValues = new HandleValue[newUrls.size()];
                int newIdx = 1;
                int test = 0;
                boolean found = true;
                for (int j = 0; j < newUrls.size(); ++j) {
                    while (test != -1) {
                        int currentLength = 0;
                        if (currentValues != null) {
                            currentLength = currentValues.length;
                        }
                        for (int i = 0; i < currentLength; ++i) {
                            if (indices[i] == newIdx) {
                                for (int k = 0; k < deleteValues.size(); ++k) {
                                    if (newIdx != ((HandleValue)deleteValues.elementAt(k)).getIndex()) continue;
                                    found = false;
                                    test = 2;
                                    break;
                                }
                                if (test == 2) break;
                                ++newIdx;
                                found = true;
                                break;
                            }
                            found = false;
                        }
                        if (found) continue;
                        test = -1;
                    }
                    newValues[j] = new HandleValue();
                    newValues[j].setIndex(newIdx);
                    newValues[j].setType(Common.STD_TYPE_URL);
                    newValues[j].setData(Util.encodeString((String)newUrls.elementAt(j)));
                    ++newIdx;
                    test = 0;
                    found = true;
                }
                log.write("Operation: update\n");
                AddValueRequest avReq = new AddValueRequest(null, newValues, auth);
                avReq.handle = Util.encodeString(handle);
                ++records;
                try {
                    response = resolver.processRequest(avReq);
                    if (response.responseCode == 1) {
                        ++successes;
                        log.write("SUCCESS:" + (lineNum - 1) + ":UPDATE:" + handle + "\n");
                    } else {
                        log.write("ERROR: " + response.responseCode + " " + AbstractMessage.getResponseCodeMessage(response.responseCode) + ": line " + (lineNum - 1) + " " + line + "\n");
                    }
                }
                catch (HandleException e) {
                    log.write("ERROR: " + e.getCode() + " " + HandleException.getCodeStr(e.getCode()) + ": line " + (lineNum - 1) + " " + line + "\n");
                    if (e.getCode() != 7) break block38;
                    DOIBatch.writeToBatchFailure(line);
                }
            }
            try {
                log.flush();
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (logStat == null) continue;
            logStat.write((float)(System.currentTimeMillis() - eachRemValDone) / 1000.0f + "\n");
            try {
                logStat.flush();
            }
            catch (Throwable t) {}
        }
        long timeEnded = System.currentTimeMillis();
        Calendar calEnd = Calendar.getInstance();
        String currenttime1 = calEnd.getTime().toString();
        log.write("Batch started at " + currenttime + "\n");
        log.write("Batch finished at " + currenttime1 + "\n");
        float totalExec = (float)(timeEnded - timeStarted) / 1000.0f;
        log.write("Batch total execution time " + totalExec + " seconds.\n");
        log.write("SUMMARY:UPDATE: " + successes + '/' + records + " successes " + (records - successes) + '/' + records + " errors\n");
        float perRequestExec = records > 0 ? totalExec / (float)records : Float.NaN;
        log.write("SUMMARY:UPDATE PROCESSING TIME: " + perRequestExec + " seconds per request.\n\n");
        if (logStat != null) {
            logStat.write("\nTotal processing time: " + totalExec + " seconds for " + records + " records.");
            logStat.write("\nAverage processing time: " + perRequestExec + " second per request.");
        }
    }

    static void processBatchModify(AuthenticationInfo auth, BufferedReader in, PrintWriter out) throws Exception {
        boolean startIdx = false;
        boolean endIdx = false;
        int lineNum = 0;
        int successes = 0;
        int records = 0;
        long timeStarted = System.currentTimeMillis();
        Calendar calStart = Calendar.getInstance();
        String currenttime = calStart.getTime().toString();
        log.write("Batch started at " + currenttime + "\n");
        if (logStat != null) {
            logStat.write("Batch action: MODIFY \n");
            logStat.write("Data: processing time per request in second \n");
            logStat.write("Note: please see your log file for success status \n\n");
        }
        long eachStart = 0L;
        while (true) {
            block30: {
                AbstractResponse response;
                HandleValue[] currentValues;
                String handle;
                Vector<HandleValue> newUrls;
                String line;
                block29: {
                    line = in.readLine();
                    ++lineNum;
                    if (line == null) break;
                    if ((line = line.trim()).length() <= 0) continue;
                    int spaceIdx = line.indexOf(32);
                    if (spaceIdx <= 0) {
                        log.write("Invalid line (" + lineNum + "): " + line + "\n");
                        continue;
                    }
                    if (logStat != null) {
                        eachStart = System.currentTimeMillis();
                    }
                    newUrls = new Vector<HandleValue>();
                    StringTokenizer st = new StringTokenizer(line, " ");
                    handle = "";
                    int indEle = 0;
                    while (st.hasMoreTokens()) {
                        if (indEle == 0) {
                            handle = st.nextToken();
                        }
                        if (indEle > 1) {
                            String idxStr = st.nextToken();
                            int index = -1;
                            try {
                                index = Integer.parseInt(idxStr);
                            }
                            catch (Exception e) {
                                log.write("ERROR: Index <" + idxStr + "> is not an integer, line " + (lineNum - 1) + " " + line + "\n");
                                continue;
                            }
                            if (index < 0) {
                                log.write("ERROR: Index <" + idxStr + "> is not a positive number, line " + (lineNum - 1) + " " + line + "\n");
                                continue;
                            }
                            String url = "";
                            if (!st.hasMoreElements()) {
                                log.write("ERROR: Missing url string, line " + (lineNum - 1) + " " + line + "\n");
                                continue;
                            }
                            url = st.nextToken();
                            HandleValue hv = new HandleValue();
                            hv.setIndex(index);
                            hv.setType(Common.STD_TYPE_URL);
                            hv.setData(Util.encodeString(url));
                            newUrls.addElement(hv);
                        }
                        ++indEle;
                    }
                    if (newUrls.size() <= 0 || handle.length() <= 0) continue;
                    ResolutionRequest rReq = new ResolutionRequest(Util.encodeString(handle), null, null, auth);
                    currentValues = null;
                    try {
                        response = resolver.processRequest(rReq);
                        if (response.responseCode == 1) {
                            currentValues = ((ResolutionResponse)response).getHandleValues();
                            break block29;
                        }
                        if (response.responseCode == 100) {
                            currentValues = null;
                            log.write("WARNING: HANDLE NOT FOUND: line " + (lineNum - 1) + " " + line + "\n");
                            continue;
                        }
                        log.write("ERROR: " + response.responseCode + " " + AbstractMessage.getResponseCodeMessage(response.responseCode) + ": trying to retrieve handle, line " + (lineNum - 1) + " " + line + "\n");
                    }
                    catch (HandleException e) {
                        log.write("ERROR: " + e.getCode() + " " + HandleException.getCodeStr(e.getCode()) + ": trying to retrieve handle, line " + (lineNum - 1) + " " + line + "\n");
                        if (e.getCode() != 7) continue;
                        DOIBatch.writeToBatchFailure(line);
                    }
                    continue;
                }
                IntTable curUrlIndex = new IntTable();
                for (int i = 0; currentValues != null && i < currentValues.length; ++i) {
                    if (!currentValues[i].hasType(Common.STD_TYPE_URL)) continue;
                    curUrlIndex.put(currentValues[i].getIndex(), currentValues[i]);
                }
                for (int j = 0; j < newUrls.size(); ++j) {
                    HandleValue hv = (HandleValue)newUrls.elementAt(j);
                    int indx = hv.getIndex();
                    if (curUrlIndex.containsKey(indx)) continue;
                    newUrls.removeElementAt(j);
                    --j;
                }
                log.write("Operation: Modify\n");
                HandleValue[] modVals = new HandleValue[newUrls.size()];
                try {
                    for (int k = 0; k < modVals.length; ++k) {
                        HandleValue hv = (HandleValue)newUrls.elementAt(k);
                        modVals[k] = new HandleValue();
                        modVals[k].setIndex(hv.getIndex());
                        modVals[k].setType(Common.STD_TYPE_URL);
                        modVals[k].setData(hv.getData());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ModifyValueRequest mReq = new ModifyValueRequest(Util.encodeString(handle), modVals, auth);
                ++records;
                try {
                    response = resolver.processRequest(mReq);
                    if (response.responseCode == 1) {
                        ++successes;
                        log.write("SUCCESS:" + (lineNum - 1) + ":MODIFY:" + handle + "\n");
                    } else {
                        log.write("ERROR: " + response.responseCode + " " + AbstractMessage.getResponseCodeMessage(response.responseCode) + ": line " + (lineNum - 1) + " " + line + "\n");
                    }
                }
                catch (HandleException e) {
                    log.write("ERROR: " + e.getCode() + " " + HandleException.getCodeStr(e.getCode()) + ": line " + (lineNum - 1) + " " + line + "\n");
                    if (e.getCode() != 7) break block30;
                    DOIBatch.writeToBatchFailure(line);
                }
            }
            try {
                log.flush();
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (logStat == null) continue;
            logStat.write((float)(System.currentTimeMillis() - eachStart) / 1000.0f + "\n");
            try {
                logStat.flush();
            }
            catch (Throwable t) {}
        }
        long timeEnded = System.currentTimeMillis();
        Calendar calEnd = Calendar.getInstance();
        String currenttime1 = calEnd.getTime().toString();
        log.write("Batch started at " + currenttime + "\n");
        log.write("Batch finished at " + currenttime1 + "\n");
        float totalExec = (timeEnded - timeStarted) / 1000L;
        log.write("Batch total execution time " + totalExec + " seconds.\n");
        log.write("SUMMARY:MODIFY: " + successes + '/' + records + " successes " + (records - successes) + '/' + records + " errors\n");
        float perRequestExec = records > 0 ? totalExec / (float)records : Float.NaN;
        log.write("SUMMARY:MODIFY PROCESSING TIME: " + perRequestExec + " seconds per request.\n\n");
        if (logStat != null) {
            logStat.write("\nTotal processing time: " + totalExec + " seconds for " + records + " records.");
            logStat.write("\nAverage processing time: " + perRequestExec + " second per request.");
        }
    }

    static void processBatchAlias(AuthenticationInfo auth, BufferedReader in, PrintWriter out) throws Exception {
        int lineNum = 0;
        log.write("Operation: alias\n");
        long timeStarted = System.currentTimeMillis();
        Calendar calStart = Calendar.getInstance();
        String currenttime = calStart.getTime().toString();
        log.write("Batch started at " + currenttime + "\n");
        HandleValue[] values = new HandleValue[]{new HandleValue()};
        values[0].setIndex(0);
        values[0].setType(Common.STD_TYPE_HSALIAS);
        values[0].setData(null);
        HandleValue[] addValues = new HandleValue[]{new HandleValue()};
        addValues[0].setIndex(0);
        addValues[0].setType(Common.STD_TYPE_HSALIAS);
        addValues[0].setData(null);
        HandleValue[] newValues = new HandleValue[2];
        newValues[0] = new HandleValue();
        newValues[0].setIndex(2);
        newValues[0].setType(Common.STD_TYPE_HSALIAS);
        newValues[0].setData(null);
        newValues[1] = new HandleValue();
        newValues[1].setIndex(100);
        newValues[1].setType(Common.STD_TYPE_HSADMIN);
        newValues[1].setData(null);
        ResolutionRequest rReq = new ResolutionRequest(null, null, null, auth);
        rReq.authoritative = true;
        ModifyValueRequest mvReq = new ModifyValueRequest(null, values, auth);
        AddValueRequest avReq = new AddValueRequest(null, addValues, auth);
        RemoveValueRequest rmReq = new RemoveValueRequest(null, null, auth);
        CreateHandleRequest chReq = new CreateHandleRequest(null, newValues, auth);
        int successes = 0;
        int records = 0;
        if (logStat != null) {
            logStat.write("Batch action: ALIAS \n");
            logStat.write("Data: processing time per request in second \n");
            logStat.write("Note: please see your log file for success status \n\n");
        }
        long eachStart = 0L;
        while (true) {
            block35: {
                HandleValue updateValue;
                AbstractResponse response;
                HandleValue[] currentValues;
                byte[] aliasHdl;
                byte[] handle;
                String handleStr;
                String line;
                block34: {
                    block33: {
                        try {
                            log.flush();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        line = in.readLine();
                        ++lineNum;
                        if (line == null) break;
                        if ((line = line.trim()).length() <= 0) continue;
                        int spaceIdx = line.indexOf(32);
                        if (spaceIdx <= 0) {
                            log.write("Invalid line (" + lineNum + "): " + line + "\n");
                            continue;
                        }
                        if (logStat != null) {
                            eachStart = System.currentTimeMillis();
                        }
                        handleStr = line.substring(0, spaceIdx);
                        handle = Util.encodeString(handleStr);
                        String aliasHdlStr = line.substring(spaceIdx + 1).trim();
                        aliasHdl = Util.encodeString(aliasHdlStr);
                        ++records;
                        rReq.handle = handle;
                        rReq.clearBuffers();
                        currentValues = null;
                        response = null;
                        try {
                            response = resolver.processRequest(rReq);
                            if (response.responseCode == 1) {
                                currentValues = ((ResolutionResponse)response).getHandleValues();
                                break block33;
                            }
                            if (response.responseCode == 100) {
                                currentValues = null;
                                break block33;
                            }
                            log.write("ERROR: " + response.responseCode + " " + AbstractMessage.getResponseCodeMessage(response.responseCode) + ": trying to retrieve handle, line " + (lineNum - 1) + " " + line + "\n");
                        }
                        catch (HandleException e) {
                            log.write("ERROR: " + e.getCode() + " " + HandleException.getCodeStr(e.getCode()) + ": trying to retrieve handle, line " + (lineNum - 1) + " " + line + "\n");
                            if (e.getCode() != 7) continue;
                            DOIBatch.writeToBatchFailure(line);
                        }
                        continue;
                    }
                    updateValue = null;
                    Vector<HandleValue> deleteValues = null;
                    for (int i = 0; currentValues != null && i < currentValues.length; ++i) {
                        if (!currentValues[i].hasType(Common.STD_TYPE_HSALIAS)) continue;
                        if (updateValue == null) {
                            updateValue = currentValues[i];
                            continue;
                        }
                        if (deleteValues == null) {
                            deleteValues = new Vector<HandleValue>();
                        }
                        deleteValues.addElement(currentValues[i]);
                    }
                    if (deleteValues != null) {
                        rmReq.handle = handle;
                        int[] indexesToDelete = new int[deleteValues.size()];
                        for (int i = 0; i < indexesToDelete.length; ++i) {
                            indexesToDelete[i] = ((HandleValue)deleteValues.elementAt(i)).getIndex();
                        }
                        rmReq.indexes = indexesToDelete;
                        rmReq.clearBuffers();
                        try {
                            response = resolver.processRequest(rmReq);
                            if (response.responseCode != 1 && response.responseCode != 200) {
                                log.write("ERROR: " + response.responseCode + " " + AbstractMessage.getResponseCodeMessage(response.responseCode) + ": removing old aliases, line " + (lineNum - 1) + " " + line + "\n");
                            }
                            break block34;
                        }
                        catch (HandleException e) {
                            log.write("ERROR: " + e.getCode() + " " + HandleException.getCodeStr(e.getCode()) + ": removing old aliases, line " + (lineNum - 1) + " " + line + "\n");
                        }
                        continue;
                    }
                }
                if (updateValue != null) {
                    mvReq.handle = handle;
                    mvReq.values[0].setData(aliasHdl);
                    mvReq.values[0].setIndex(updateValue.getIndex());
                    mvReq.values[0].setType(Common.STD_TYPE_HSALIAS);
                    mvReq.clearBuffers();
                    try {
                        response = resolver.processRequest(mvReq);
                        if (response.responseCode == 1) {
                            ++successes;
                            log.write("SUCCESS:" + (lineNum - 1) + ":ALIAS:" + handleStr + "\n");
                            break block35;
                        }
                        log.write("ERROR: " + response.responseCode + " " + AbstractMessage.getResponseCodeMessage(response.responseCode) + ": line " + (lineNum - 1) + " " + line + "\n");
                    }
                    catch (HandleException e) {
                        log.write("ERROR: " + e.getCode() + " " + HandleException.getCodeStr(e.getCode()) + ": line " + (lineNum - 1) + " " + line + "\n");
                        if (e.getCode() != 7) continue;
                        DOIBatch.writeToBatchFailure(line);
                    }
                    continue;
                }
                if (currentValues == null) {
                    chReq.handle = handle;
                    chReq.values[0].setData(aliasHdl);
                    AdminRecord admin = new AdminRecord(Util.encodeString("0.na/" + Util.decodeString(Util.getNAPart(chReq.handle))), 200, false, true, false, false, true, true, true, true, true, true, true, true);
                    chReq.values[1].setData(Encoder.encodeAdminRecord(admin));
                    chReq.clearBuffers();
                    try {
                        response = resolver.processRequest(chReq);
                        if (response.responseCode == 1) {
                            ++successes;
                            log.write("SUCCESS:" + (lineNum - 1) + ":ADD:" + handleStr + "\n");
                            break block35;
                        }
                        log.write("ERROR: " + response.responseCode + " " + AbstractMessage.getResponseCodeMessage(response.responseCode) + ": trying to create handle, line " + (lineNum - 1) + " " + line + "\n");
                    }
                    catch (HandleException e) {
                        log.write("ERROR: " + e.getCode() + " " + HandleException.getCodeStr(e.getCode()) + ": line " + (lineNum - 1) + " " + line + "\n");
                        if (e.getCode() != 7) break block35;
                        DOIBatch.writeToBatchFailure(line);
                    }
                } else {
                    avReq.handle = handle;
                    avReq.values[0].setData(aliasHdl);
                    avReq.values[0].setType(Common.STD_TYPE_HSALIAS);
                    avReq.values[0].setIndex(DOIBatch.getUnusedIndex(currentValues));
                    avReq.clearBuffers();
                    try {
                        response = resolver.processRequest(avReq);
                        if (response.responseCode == 1) {
                            ++successes;
                            log.write("SUCCESS:" + (lineNum - 1) + ":ALIAS:" + handleStr + "\n");
                            break block35;
                        }
                        log.write("ERROR: " + response.responseCode + " " + AbstractMessage.getResponseCodeMessage(response.responseCode) + ": line " + (lineNum - 1) + " " + line + "\n");
                    }
                    catch (HandleException e) {
                        log.write("ERROR: " + e.getCode() + " " + HandleException.getCodeStr(e.getCode()) + ": line " + (lineNum - 1) + " " + line + "\n");
                        if (e.getCode() != 7) continue;
                        DOIBatch.writeToBatchFailure(line);
                    }
                    continue;
                }
            }
            if (logStat == null) continue;
            logStat.write((float)(System.currentTimeMillis() - eachStart) / 1000.0f + "\n");
            try {
                logStat.flush();
            }
            catch (Throwable t) {}
        }
        long timeEnded = System.currentTimeMillis();
        Calendar calEnd = Calendar.getInstance();
        String currenttime1 = calEnd.getTime().toString();
        log.write("Batch started at " + currenttime + "\n");
        log.write("Batch finished at " + currenttime1 + "\n");
        float totalExec = (float)(timeEnded - timeStarted) / 1000.0f;
        log.write("Batch total execution time " + totalExec + " seconds.\n");
        log.write("SUMMARY:ALIAS: " + successes + '/' + records + " successes " + (records - successes) + '/' + records + " errors\n");
        float perRequestExec = records > 0 ? totalExec / (float)records : Float.NaN;
        log.write("SUMMARY:ALIAS PROCESSING TIME: " + perRequestExec + " seconds per request.\n\n");
        if (logStat != null) {
            logStat.write("\nTotal processing time: " + totalExec + " seconds for " + records + " records.");
            logStat.write("\nAverage processing time: " + perRequestExec + " second per request.");
        }
    }

    static void processBatchUnalias(AuthenticationInfo auth, BufferedReader in, PrintWriter out) throws Exception {
        int lineNum = 0;
        log.write("Operation: unalias\n");
        long timeStarted = System.currentTimeMillis();
        Calendar calStart = Calendar.getInstance();
        String currenttime = calStart.getTime().toString();
        log.write("Batch started at " + currenttime + "\n");
        ResolutionRequest rReq = new ResolutionRequest(null, null, null, auth);
        rReq.authoritative = true;
        RemoveValueRequest rmReq = new RemoveValueRequest(null, null, auth);
        int successes = 0;
        int records = 0;
        if (logStat != null) {
            logStat.write("Batch action: UNALIAS \n");
            logStat.write("Data: processing time per request in second \n");
            logStat.write("Note: please see your log file for success status \n\n");
        }
        long eachStart = 0L;
        while (true) {
            block20: {
                AbstractResponse response;
                HandleValue[] currentValues;
                byte[] handle;
                String line;
                block19: {
                    try {
                        log.flush();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    line = in.readLine();
                    ++lineNum;
                    if (line == null) break;
                    if ((line = line.trim()).length() <= 0) continue;
                    if (logStat != null) {
                        eachStart = System.currentTimeMillis();
                    }
                    String handleStr = line.trim();
                    handle = Util.encodeString(handleStr);
                    ++records;
                    rReq.handle = handle;
                    rReq.clearBuffers();
                    currentValues = null;
                    response = null;
                    try {
                        response = resolver.processRequest(rReq);
                        if (response.responseCode == 1) {
                            currentValues = ((ResolutionResponse)response).getHandleValues();
                            break block19;
                        }
                        log.write("ERROR: " + response.responseCode + " " + AbstractMessage.getResponseCodeMessage(response.responseCode) + ": trying to retrieve handle, line " + (lineNum - 1) + " " + line + "\n");
                    }
                    catch (HandleException e) {
                        log.write("ERROR: " + e.getCode() + " " + HandleException.getCodeStr(e.getCode()) + ": trying to retrieve handle, line " + (lineNum - 1) + " " + line + "\n");
                        if (e.getCode() != 7) continue;
                        DOIBatch.writeToBatchFailure(line);
                    }
                    continue;
                }
                Object updateValue = null;
                Vector<HandleValue> deleteValues = null;
                for (int i = 0; currentValues != null && i < currentValues.length; ++i) {
                    if (!currentValues[i].hasType(Common.STD_TYPE_HSALIAS)) continue;
                    if (deleteValues == null) {
                        deleteValues = new Vector<HandleValue>();
                    }
                    deleteValues.addElement(currentValues[i]);
                }
                if (deleteValues != null) {
                    rmReq.handle = handle;
                    int[] indexesToDelete = new int[deleteValues.size()];
                    for (int i = 0; i < indexesToDelete.length; ++i) {
                        indexesToDelete[i] = ((HandleValue)deleteValues.elementAt(i)).getIndex();
                    }
                    rmReq.indexes = indexesToDelete;
                    rmReq.clearBuffers();
                    try {
                        response = resolver.processRequest(rmReq);
                        if (response.responseCode != 1 && response.responseCode != 200) {
                            log.write("ERROR: " + response.responseCode + " " + AbstractMessage.getResponseCodeMessage(response.responseCode) + ": removing old aliases, line " + (lineNum - 1) + " " + line + "\n");
                        }
                        break block20;
                    }
                    catch (HandleException e) {
                        log.write("ERROR: " + e.getCode() + " " + HandleException.getCodeStr(e.getCode()) + ": removing old aliases, line " + (lineNum - 1) + " " + line + "\n");
                        if (e.getCode() != 7) continue;
                        DOIBatch.writeToBatchFailure(line);
                    }
                    continue;
                }
            }
            if (logStat != null) {
                logStat.write((float)(System.currentTimeMillis() - eachStart) / 1000.0f + "\n");
                try {
                    logStat.flush();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            ++successes;
        }
        long timeEnded = System.currentTimeMillis();
        Calendar calEnd = Calendar.getInstance();
        String currenttime1 = calEnd.getTime().toString();
        log.write("Batch started at " + currenttime + "\n");
        log.write("Batch finished at " + currenttime1 + "\n");
        float totalExec = (float)(timeEnded - timeStarted) / 1000.0f;
        log.write("Batch total execution time " + totalExec + " seconds.\n");
        log.write("SUMMARY:UNALIAS: " + successes + '/' + records + " successes " + (records - successes) + '/' + records + " errors\n");
        float perRequestExec = records > 0 ? totalExec / (float)records : Float.NaN;
        log.write("SUMMARY:UNALIAS PROCESSING TIME: " + perRequestExec + " seconds per request.");
        if (logStat != null) {
            logStat.write("\nTotal processing time: " + totalExec + " seconds for " + records + " records.");
            logStat.write("\nAverage processing time: " + perRequestExec + " second per request.");
        }
    }

    private static final int getUnusedIndex(HandleValue[] values) {
        int nextIdx = 2;
        for (int i = 0; values != null && i < values.length; ++i) {
            if (values[i] == null || values[i].getIndex() != nextIdx) continue;
            ++nextIdx;
            i = -1;
        }
        return nextIdx;
    }

    static void processBatchDelete(AuthenticationInfo auth, BufferedReader in, PrintWriter out) throws Exception {
        int lineNum = 0;
        log.write("Operation: delete\n");
        DeleteHandleRequest dhReq = new DeleteHandleRequest(null, auth);
        long timeStarted = System.currentTimeMillis();
        Calendar calStart = Calendar.getInstance();
        String currenttime = calStart.getTime().toString();
        log.write("Batch started at " + currenttime + "\n");
        if (logStat != null) {
            logStat.write("Batch action: DELETE \n");
            logStat.write("Data: processing time per request in second \n");
            logStat.write("Note: please see your log file for success status \n\n");
        }
        int successes = 0;
        int records = 0;
        long eachStart = 0L;
        long eachEnd = 0L;
        while (true) {
            block12: {
                String line = in.readLine();
                ++lineNum;
                if (line == null) break;
                if ((line = line.trim()).length() <= 0) continue;
                int spaceIdx = line.indexOf(32);
                String handle = spaceIdx > 0 ? line.substring(0, spaceIdx).trim() : line;
                if (logStat != null) {
                    eachStart = System.currentTimeMillis();
                }
                dhReq.handle = Util.encodeString(handle);
                ++records;
                dhReq.clearBuffers();
                AbstractResponse response = null;
                try {
                    response = resolver.processRequest(dhReq);
                    if (response.responseCode == 1) {
                        ++successes;
                        log.write("SUCCESS:" + (lineNum - 1) + ":DELETE:" + handle + "\n");
                    } else {
                        log.write("ERROR: " + response.responseCode + " " + AbstractMessage.getResponseCodeMessage(response.responseCode) + ": line " + (lineNum - 1) + " " + line + "\n");
                    }
                }
                catch (HandleException e) {
                    log.write("ERROR: " + e.getCode() + " " + HandleException.getCodeStr(e.getCode()) + ": line " + (lineNum - 1) + " " + line + "\n");
                    if (e.getCode() != 7) break block12;
                    DOIBatch.writeToBatchFailure(line);
                }
            }
            try {
                log.flush();
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (logStat == null) continue;
            double fl = (float)(System.currentTimeMillis() - eachStart) / 1000.0f;
            logStat.write(fl + "\n");
            try {
                logStat.flush();
            }
            catch (Throwable t) {}
        }
        long timeEnded = System.currentTimeMillis();
        Calendar calEnd = Calendar.getInstance();
        String currenttime1 = calEnd.getTime().toString();
        log.write("Batch started at " + currenttime + "\n");
        log.write("Batch finished at " + currenttime1 + "\n");
        float totalExec = (float)(timeEnded - timeStarted) / 1000.0f;
        log.write("Batch total execution time " + totalExec + " seconds.\n");
        log.write("SUMMARY:DELETE: " + successes + '/' + records + " successes " + (records - successes) + '/' + records + " errors\n");
        float perRequestExec = records > 0 ? totalExec / (float)records : Float.NaN;
        log.write("SUMMARY:DELETE PROCESSING TIME: " + perRequestExec + " seconds per request.\n\n");
        if (logStat != null) {
            logStat.write("\nTotal processing: " + totalExec + " seconds for " + records + " records.");
            logStat.write("\nAverage processing time: " + perRequestExec + " second per request.");
        }
    }

    static {
        resolver.setTcpTimeout(20000);
    }
}

