/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.batch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.security.PrivateKey;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AddValueRequest;
import net.handle.hdllib.AdminRecord;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ClientSessionTracker;
import net.handle.hdllib.Common;
import net.handle.hdllib.CreateHandleRequest;
import net.handle.hdllib.DeleteHandleRequest;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.GetSiteInfoResponse;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ModifyValueRequest;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.RemoveValueRequest;
import net.handle.hdllib.SecretKeyAuthenticationInfo;
import net.handle.hdllib.SessionSetupInfo;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;

public class GenericBatch {
    public static final String ENCODING = "UTF8";
    public static final String AUTH_STR = "AUTHENTICATE";
    public static final String SECKEY_STR = "SECKEY";
    public static final String PUBKEY_STR = "PUBKEY";
    public static final String CREATE_STR = "CREATE";
    public static final String DELETE_STR = "DELETE";
    public static final String ADD_STR = "ADD";
    public static final String MODIFY_STR = "MODIFY";
    public static final String REMOVE_STR = "REMOVE";
    public static final String HOME_STR = "HOME";
    public static final String UNHOME_STR = "UNHOME";
    public static final String SEPA_STR = " ";
    public static final String NEW_LINE = "\n";
    public static final String ADMIN_STR = "ADMIN";
    public static final String FILE_STR = "FILE";
    public static final String LIST_STR = "LIST";
    public static boolean debug = true;
    public static final String SESSION_STR = "SESSIONSETUP";
    private HandleResolver resolver = new HandleResolver();
    private ClientSessionTracker sessionTracker = null;
    private long lineNum = 0L;
    private long totalAcc = 0L;
    private long errAcc = 0L;
    private long succAcc = 0L;
    private AuthenticationInfo authInfo = null;
    private PrintWriter log = null;
    private BufferedReader batchReader = null;
    private CreateHandleRequest createReq = null;
    private DeleteHandleRequest deleteReq = null;
    private AddValueRequest addReq = null;
    private RemoveValueRequest removeReq = null;
    private ModifyValueRequest modifyReq = null;
    private GenericRequest homeNAReq = null;
    private GenericRequest siteReq = null;
    private volatile boolean stopFlag = false;
    private final String sessionFlagToken = "USESESSION:";
    private final String sessionPubExngKeyFileToken = "PUBEXNGKEYFILE:";
    private final String sessionPubExngKeyRefToken = "PUBEXNGKEYREF:";
    private final String sessionPrivExngKeyFileToken = "PRIVEXNGKEYFILE:";
    private final String sessionPrivExngKeyPasspraseToken = "PASSPHRASE:";
    private final String sessionOptionsToken = "OPTIONS:";
    private final String sessionTimeoutToken = "TIMEOUT:";

    public GenericBatch(BufferedReader batchReader, AuthenticationInfo authInfo, PrintWriter log) throws Exception {
        this(batchReader, authInfo, log, null);
    }

    public GenericBatch(BufferedReader batchReader, AuthenticationInfo authInfo, PrintWriter log, ClientSessionTracker sessTracker) throws Exception {
        this.resolver.traceMessages = debug;
        this.sessionTracker = sessTracker;
        if (this.sessionTracker == null) {
            this.sessionTracker = new ClientSessionTracker();
        }
        SessionSetupInfo sessionInfo = new SessionSetupInfo(authInfo);
        sessionInfo.encrypted = true;
        this.sessionTracker.setSessionSetupInfo(sessionInfo);
        this.resolver.setSessionTracker(this.sessionTracker);
        this.batchReader = batchReader;
        this.authInfo = authInfo;
        if (log != null) {
            this.log = log;
        } else {
            this.log = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, ENCODING), true);
            System.err.println("Batch process prints log on stdout ...");
        }
        this.createReq = new CreateHandleRequest(null, null, null);
        this.deleteReq = new DeleteHandleRequest(null, null);
        this.addReq = new AddValueRequest(null, (HandleValue[])null, null);
        this.removeReq = new RemoveValueRequest(null, null, null);
        this.modifyReq = new ModifyValueRequest(null, (HandleValue[])null, null);
        this.homeNAReq = new GenericRequest(null, -1, null);
        this.siteReq = new GenericRequest(Common.BLANK_HANDLE, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processBatch() throws Exception {
        long startTime = System.currentTimeMillis();
        try {
            String line;
            this.log.println("Start Time: " + new Date());
            this.log.flush();
            while (!this.stopFlag && (line = this.batchReader.readLine()) != null) {
                if (++this.lineNum % 1000L == 999L) {
                    System.gc();
                }
                line.trim();
                if (line.length() <= 0) continue;
                String commandStr = "";
                String restLine = "";
                int sepaInd = line.indexOf(SEPA_STR);
                if (sepaInd < 1) {
                    commandStr = line.trim().toUpperCase();
                } else {
                    commandStr = line.substring(0, sepaInd).trim().toUpperCase();
                    restLine = line.substring(sepaInd + 1, line.length()).trim();
                }
                if (commandStr.equals(AUTH_STR)) {
                    AuthenticationInfo tmpAuth = this.getAuthInfoFromBatch(restLine);
                    if (tmpAuth == null) continue;
                    this.authInfo = tmpAuth;
                    this.sessionTracker.setSessionSetupInfo(new SessionSetupInfo(this.authInfo));
                    continue;
                }
                if (commandStr.equals(CREATE_STR)) {
                    ++this.totalAcc;
                    this.processCreate(restLine);
                    continue;
                }
                if (commandStr.equals(DELETE_STR)) {
                    ++this.totalAcc;
                    this.processDelete(restLine);
                    continue;
                }
                if (commandStr.equals(ADD_STR)) {
                    ++this.totalAcc;
                    this.processAdd(restLine);
                    continue;
                }
                if (commandStr.equals(REMOVE_STR)) {
                    ++this.totalAcc;
                    this.processRemove(restLine);
                    continue;
                }
                if (commandStr.equals(MODIFY_STR)) {
                    ++this.totalAcc;
                    this.processModify(restLine);
                    continue;
                }
                if (commandStr.equals(HOME_STR)) {
                    this.processHomeNA(restLine, true);
                    continue;
                }
                if (commandStr.equals(UNHOME_STR)) {
                    this.processHomeNA(restLine, false);
                    continue;
                }
                if (commandStr.equals(SESSION_STR)) {
                    SessionSetupInfo sinfo = this.getSessionSetupInfo();
                    if (sinfo == null) continue;
                    this.resolver.getSessionTracker().setSessionSetupInfo(sinfo);
                    continue;
                }
                this.log.println("==>INVALID[" + this.lineNum + "]: error in command line");
            }
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            long endTime = System.currentTimeMillis();
            this.log.println("Successes/Total Entries: " + this.succAcc + "/" + this.totalAcc);
            this.log.println("Batch File Lines: " + this.lineNum);
            this.log.println("Finish Time: " + new Date());
            this.log.println("This batch took " + (endTime - startTime) / 1000L + " seconds to complete " + "at an average speed of " + (double)this.totalAcc / ((double)(endTime - startTime) / 1000.0) + " operations/second");
            throw throwable;
        }
        long endTime = System.currentTimeMillis();
        this.log.println("Successes/Total Entries: " + this.succAcc + "/" + this.totalAcc);
        this.log.println("Batch File Lines: " + this.lineNum);
        this.log.println("Finish Time: " + new Date());
        this.log.println("This batch took " + (endTime - startTime) / 1000L + " seconds to complete " + "at an average speed of " + (double)this.totalAcc / ((double)(endTime - startTime) / 1000.0) + " operations/second");
    }

    public void stopBatch() {
        if (debug) {
            System.err.println("Stop batch process ...");
        }
        this.stopFlag = true;
    }

    private AuthenticationInfo getAuthInfoFromBatch(String line) {
        try {
            StringTokenizer token = new StringTokenizer(line, ":");
            String keyStr = token.nextToken().trim().toUpperCase();
            int index = Integer.parseInt(token.nextToken().trim());
            String handleStr = token.nextToken().trim();
            if (keyStr.equals(SECKEY_STR)) {
                String password = this.readLine();
                if (password == null) {
                    throw new Exception("Secret key without password");
                }
                SecretKeyAuthenticationInfo seckeyAuthInfo = new SecretKeyAuthenticationInfo(Util.encodeString(handleStr), index, Util.encodeString(password));
                return seckeyAuthInfo;
            }
            if (keyStr.equals(PUBKEY_STR)) {
                File keyFile;
                String inLine = this.readLine();
                if (inLine == null) {
                    throw new Exception("Private key without key file");
                }
                int pipeInd = inLine.indexOf("|");
                String passphrase = null;
                if (pipeInd <= 0) {
                    keyFile = new File(inLine);
                } else {
                    keyFile = new File(inLine.substring(0, pipeInd).trim());
                    passphrase = inLine.substring(pipeInd + 1).trim();
                }
                byte[] rawKey = new byte[(int)keyFile.length()];
                FileInputStream in = new FileInputStream(keyFile);
                int r = 0;
                for (int n = 0; n < rawKey.length && (r = ((InputStream)in).read(rawKey, n, rawKey.length - n)) > 0; n += r) {
                }
                ((InputStream)in).close();
                byte[] keyBytes = Util.decrypt(rawKey, Util.encodeString(passphrase));
                PrivateKey privateKey = Util.getPrivateKeyFromBytes(keyBytes, 0);
                PublicKeyAuthenticationInfo pubkeyAuthInfo = new PublicKeyAuthenticationInfo(Util.encodeString(handleStr), index, privateKey);
                return pubkeyAuthInfo;
            }
            this.log.println("==>INVALID[" + this.lineNum + "]: error in authentication lines");
            return null;
        }
        catch (Exception e) {
            this.log.println("==>INVALID[" + this.lineNum + "]: error in authentication: " + e.getMessage());
            return null;
        }
    }

    private void processCreate(String handleStr) {
        if (handleStr == null || handleStr.length() <= 0) {
            this.log.println("==>INVALID[" + this.lineNum + "]: error in handle name string");
            return;
        }
        HandleValue[] values = this.readHandleValueArray();
        if (values == null) {
            this.log.println("==>INVALID[" + this.lineNum + "]: no handle values for " + handleStr);
            return;
        }
        this.createReq.authInfo = this.authInfo;
        this.createReq.handle = Util.encodeString(handleStr);
        this.createReq.values = values;
        this.createReq.clearBuffers();
        AbstractResponse response = null;
        try {
            response = this.resolver.processRequest(this.createReq);
            if (response.responseCode == 1) {
                ++this.succAcc;
                this.log.println("==>SUCCESS[" + this.lineNum + "]: create:" + handleStr);
            } else {
                this.log.println("==>FAILURE[" + this.lineNum + "]: create:" + handleStr + ": " + response);
            }
        }
        catch (Exception e) {
            this.log.println("==>FAILURE[" + this.lineNum + "]: create:" + handleStr + ": " + e.getMessage());
        }
    }

    private void processDelete(String handleStr) {
        if (handleStr == null || handleStr.length() <= 0) {
            this.log.println("==>INVALID[" + this.lineNum + "]: error in handle name string");
            return;
        }
        this.deleteReq.authInfo = this.authInfo;
        this.deleteReq.handle = Util.encodeString(handleStr);
        this.deleteReq.clearBuffers();
        AbstractResponse response = null;
        try {
            response = this.resolver.processRequest(this.deleteReq);
            if (response.responseCode == 1) {
                ++this.succAcc;
                this.log.println("==>SUCCESS[" + this.lineNum + "]: delete:" + handleStr);
            } else {
                this.log.println("==>FAILURE[" + this.lineNum + "]: delete:" + handleStr + ": " + response);
            }
        }
        catch (Exception e) {
            this.log.println("==>FAILURE[" + this.lineNum + "]: delete:" + handleStr + ": " + e.getMessage());
        }
    }

    private void processAdd(String handleStr) {
        if (handleStr == null || handleStr.length() <= 0) {
            this.log.println("==>INVALID[" + this.lineNum + "]: error in handle name string");
            return;
        }
        HandleValue[] values = this.readHandleValueArray();
        if (values == null) {
            this.log.println("==>INVALID[" + this.lineNum + "]: no handle values for " + handleStr);
            return;
        }
        this.addReq.authInfo = this.authInfo;
        this.addReq.handle = Util.encodeString(handleStr);
        this.addReq.values = values;
        this.addReq.clearBuffers();
        AbstractResponse response = null;
        try {
            response = this.resolver.processRequest(this.addReq);
            if (response.responseCode == 1) {
                ++this.succAcc;
                this.log.println("==>SUCCESS[" + this.lineNum + "]: add values:" + handleStr);
            } else {
                this.log.println("==>FAILURE[" + this.lineNum + "]: add values:" + handleStr + ": " + response);
            }
        }
        catch (Exception e) {
            this.log.println("==>FAILURE[" + this.lineNum + "]: add values:" + handleStr + ": " + e.getMessage());
        }
    }

    private void processModify(String handleStr) {
        if (handleStr == null || handleStr.length() <= 0) {
            this.log.println("==>INVALID[" + this.lineNum + "]: error in handle name string");
            return;
        }
        HandleValue[] values = this.readHandleValueArray();
        if (values == null) {
            this.log.println("==>INVALID[" + this.lineNum + "]: no handle values for " + handleStr);
            return;
        }
        this.modifyReq.authInfo = this.authInfo;
        this.modifyReq.handle = Util.encodeString(handleStr);
        this.modifyReq.values = values;
        this.modifyReq.clearBuffers();
        AbstractResponse response = null;
        try {
            response = this.resolver.processRequest(this.modifyReq);
            if (response.responseCode == 1) {
                ++this.succAcc;
                this.log.println("==>SUCCESS[" + this.lineNum + "]: modify values:" + handleStr);
            } else {
                this.log.println("==>FAILURE[" + this.lineNum + "]: modify values:" + handleStr + ": " + response);
            }
        }
        catch (Exception e) {
            this.log.println("==>FAILURE[" + this.lineNum + "]: modify values:" + handleStr + ": " + e.getMessage());
        }
    }

    private void processRemove(String line) {
        if (line == null || line.length() <= 0) {
            this.log.println("==>INVALID[" + this.lineNum + "]: error in remove handle line");
            return;
        }
        int colonInd = line.indexOf(":");
        if (colonInd <= 0) {
            this.log.println("==>INVALID[" + this.lineNum + "]: error in indexes string");
            return;
        }
        int[] indexes = this.readIndexArray(line.substring(0, colonInd));
        if (indexes == null) {
            this.log.println("==>INVALID[" + this.lineNum + "]: error in indexes string");
            return;
        }
        String handleStr = line.substring(colonInd + 1).trim();
        if (handleStr == null || handleStr.length() == 0) {
            this.log.println("==>INVALID[" + this.lineNum + "]: no handle name at remove handle line");
            return;
        }
        this.removeReq.authInfo = this.authInfo;
        this.removeReq.handle = Util.encodeString(handleStr);
        this.removeReq.indexes = indexes;
        this.removeReq.clearBuffers();
        AbstractResponse response = null;
        try {
            response = this.resolver.processRequest(this.removeReq);
            if (response.responseCode == 1) {
                ++this.succAcc;
                this.log.println("==>SUCCESS[" + this.lineNum + "]: remove values:" + handleStr);
            } else {
                this.log.println("==>FAILURE[" + this.lineNum + "]: remove values:" + handleStr + ": " + response);
            }
        }
        catch (Exception e) {
            this.log.println("==>FAILURE[" + this.lineNum + "]: remove values:" + handleStr + ": " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processHomeNA(String line, boolean homeFlag) {
        if (line == null || line.length() <= 0) {
            this.log.println("==>INVALID[" + this.lineNum + "]: error in homeNA handle line");
            return;
        }
        try {
            String handleStr;
            AbstractResponse response;
            block17: {
                StringTokenizer st = new StringTokenizer(line, ":");
                String ipstr = st.nextToken().trim();
                int port = Integer.parseInt(st.nextToken().trim());
                String protocol = st.nextToken().trim();
                InetAddress svrAddr = InetAddress.getByName(ipstr);
                this.siteReq.certify = true;
                response = null;
                try {
                    this.resolver.setCheckSignatures(false);
                    if (protocol.toUpperCase().equals("TCP")) {
                        response = this.resolver.sendHdlTcpRequest(this.siteReq, svrAddr, port);
                        break block17;
                    }
                    if (protocol.toUpperCase().equals("UDP")) {
                        response = this.resolver.sendHdlUdpRequest(this.siteReq, svrAddr, port);
                        break block17;
                    }
                    if (protocol.toUpperCase().equals("HTTP")) {
                        response = this.resolver.sendHttpRequest(this.siteReq, svrAddr, port);
                        break block17;
                    }
                    this.log.println("==>INVALID[" + this.lineNum + "]: error in protocol string");
                    return;
                }
                finally {
                    this.resolver.setCheckSignatures(true);
                }
            }
            SiteInfo siteInfo = null;
            if (response == null || response.responseCode != 1) {
                this.log.println("==>INVALID[" + this.lineNum + "]: error in home/unhome NA handle, invalide server: " + response);
                return;
            }
            siteInfo = ((GetSiteInfoResponse)response).siteInfo;
            if (!siteInfo.isPrimary) {
                this.log.println("==>INVALID[" + this.lineNum + "]: error in home/unhome NA handle, invalide server: not primary server");
                return;
            }
            this.homeNAReq.authInfo = this.authInfo;
            this.homeNAReq.certify = true;
            this.homeNAReq.opCode = homeFlag ? 300 : 301;
            while ((handleStr = this.readLine()) != null && handleStr.length() > 0) {
                ++this.totalAcc;
                byte[] naHandle = Util.encodeString(handleStr);
                if (!Util.startsWithCI(naHandle, Common.NA_HANDLE_PREFIX)) {
                    this.log.println("==>INVALID[" + this.lineNum + "]: invalid NA handle name: " + handleStr);
                    continue;
                }
                this.homeNAReq.handle = naHandle;
                this.homeNAReq.clearBuffers();
                try {
                    boolean flag = true;
                    for (int i = 0; i < siteInfo.servers.length; ++i) {
                        response = this.resolver.sendRequestToServer(this.homeNAReq, siteInfo.servers[i]);
                        if (response.responseCode == 1) continue;
                        this.log.println("==>FAILURE[" + this.lineNum + "]: home/unhome:" + handleStr + ": " + response);
                        flag = false;
                        break;
                    }
                    if (!flag) continue;
                    this.log.println("==>SUCCESS[" + this.lineNum + "]: home/unhome:" + handleStr);
                    ++this.succAcc;
                }
                catch (HandleException e) {
                    this.log.println("==>FAILURE[" + this.lineNum + "]: home/unhome:" + handleStr + ": " + e.getMessage());
                }
                catch (Exception e) {
                    this.log.println("==>INVALID[" + this.lineNum + "]: error in home/unhome:" + handleStr + ": " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.log.println("==>INVALID[" + this.lineNum + "]: error in home/unhome:" + e.getMessage());
        }
    }

    private SessionSetupInfo getSessionSetupInfo() {
        boolean useSession = false;
        byte[] pubkeyBytes = null;
        byte[] exchangeKeyHandle = null;
        int exchangeKeyIndex = -1;
        PrivateKey privateKey = null;
        String privKeyFile = null;
        String passpraze = null;
        boolean encrypted = false;
        boolean authenticated = false;
        int timeout = -1;
        try {
            String sessionLine = this.readLine();
            while (sessionLine != null) {
                block32: {
                    String sessionLinePrefix = sessionLine.substring(0, sessionLine.indexOf(":") + 1).trim().toUpperCase();
                    String sessionLineContent = sessionLine.substring(sessionLine.indexOf(":") + 1).trim();
                    if (sessionLinePrefix.startsWith("USESESSION:")) {
                        int flag = Integer.parseInt(sessionLineContent);
                        useSession = flag > 0;
                    } else if (sessionLinePrefix.startsWith("PUBEXNGKEYFILE:")) {
                        pubkeyBytes = Util.getBytesFromFile(new File(sessionLineContent));
                    } else if (sessionLinePrefix.startsWith("PUBEXNGKEYREF:")) {
                        int indexPos = sessionLineContent.indexOf(58);
                        exchangeKeyIndex = Integer.parseInt(sessionLineContent.substring(0, indexPos).trim());
                        String hdlString = sessionLineContent.substring(indexPos + 1, sessionLineContent.length()).trim();
                        exchangeKeyHandle = Util.encodeString(hdlString);
                    } else if (sessionLinePrefix.startsWith("PRIVEXNGKEYFILE:")) {
                        privKeyFile = sessionLineContent;
                    } else if (sessionLinePrefix.startsWith("PASSPHRASE:")) {
                        passpraze = sessionLineContent;
                    } else if (sessionLinePrefix.startsWith("OPTIONS:")) {
                        try {
                            encrypted = sessionLineContent.charAt(0) == '1';
                            if (sessionLineContent.charAt(1) == '1') {
                                authenticated = true;
                                break block32;
                            }
                            authenticated = false;
                        }
                        catch (Exception e) {
                            this.log.println("==>INVALID [" + this.lineNum + "]: Error specifying session options." + e);
                        }
                    } else if (sessionLinePrefix.startsWith("TIMEOUT:")) {
                        try {
                            timeout = Integer.parseInt(sessionLineContent) * 60 * 60;
                        }
                        catch (Exception e) {
                            this.log.println("==>INVALID [" + this.lineNum + "]: Error specifying session time out." + e + " Default or previous value will be used.");
                            timeout = -1;
                        }
                    } else {
                        this.log.println("==>INVALID [" + this.lineNum + "]: Not predefined session line encounted.");
                    }
                }
                sessionLine = this.readLine();
            }
            if (pubkeyBytes != null && exchangeKeyHandle != null && exchangeKeyIndex == -1) {
                this.log.println("==>INVALID[" + this.lineNum + "]: error in sessionsetup lines, public exchange key dupli-defined. Session not setup.");
                return null;
            }
            if (privKeyFile != null) {
                byte[] rawKey = Util.getBytesFromFile(new File(privKeyFile));
                byte[] secretKey = null;
                try {
                    if (Util.requiresSecretKey(rawKey)) {
                        if (passpraze == null) {
                            this.log.println("==>INVALID[" + this.lineNum + "]: error in sessionsetup lines, passphrase for private exchange key missed.  Session not setup.");
                            return null;
                        }
                        secretKey = Util.encodeString(passpraze);
                    }
                    byte[] keyBytes = Util.decrypt(rawKey, secretKey);
                    try {
                        privateKey = Util.getPrivateKeyFromBytes(keyBytes, 0);
                    }
                    catch (Exception e) {
                        this.log.println("==>INVALID[" + this.lineNum + "]: error in sessionsetup lines, passphrase for private exchange key wrong! " + e + " Session not setup.");
                        return null;
                    }
                }
                catch (Throwable e) {
                    this.log.println("==>INVALID[" + this.lineNum + "]: error in sessionsetup lines, can't decrypt private exchange key!" + e + " Session not setup.");
                    return null;
                }
            }
            if (!useSession) {
                return null;
            }
            SessionSetupInfo ssinfo = null;
            ssinfo = pubkeyBytes != null && privateKey != null ? new SessionSetupInfo(1, this.authInfo, pubkeyBytes, privateKey) : (exchangeKeyHandle != null && exchangeKeyIndex >= 0 && privateKey != null ? new SessionSetupInfo(this.authInfo, exchangeKeyHandle, exchangeKeyIndex, privateKey) : new SessionSetupInfo(this.authInfo));
            ssinfo.authenticated = authenticated;
            ssinfo.encrypted = encrypted;
            if (timeout > 0) {
                ssinfo.timeout = timeout;
            }
            return ssinfo;
        }
        catch (Exception e) {
            this.log.println("==>INVALID[" + this.lineNum + "]: error in session setup: " + e.getMessage());
            return null;
        }
    }

    private String readLine() throws Exception {
        String line = this.batchReader.readLine();
        if (line == null) {
            return null;
        }
        if (++this.lineNum % 1000L == 999L) {
            System.gc();
        }
        line.trim();
        if (line.length() <= 0) {
            return null;
        }
        return line;
    }

    private int[] readIndexArray(String line) {
        try {
            StringTokenizer st = new StringTokenizer(line, ",");
            int[] indexes = new int[st.countTokens()];
            for (int i = 0; i < indexes.length; ++i) {
                indexes[i] = Integer.parseInt(st.nextToken().trim());
            }
            return indexes;
        }
        catch (Exception e) {
            return null;
        }
    }

    private HandleValue[] readHandleValueArray() {
        Vector<HandleValue> vt = new Vector<HandleValue>();
        try {
            String line;
            while ((line = this.batchReader.readLine()) != null) {
                if (++this.lineNum % 1000L == 999L) {
                    System.gc();
                }
                line.trim();
                if (line.length() <= 0) break;
                HandleValue hv = this.readHandleValue(line);
                if (hv == null) {
                    return null;
                }
                vt.addElement(hv);
            }
            if (vt.size() < 1) {
                return null;
            }
            HandleValue[] values = new HandleValue[vt.size()];
            for (int i = 0; i < vt.size(); ++i) {
                values[i] = (HandleValue)vt.elementAt(i);
            }
            return values;
        }
        catch (Exception e) {
            this.log.println("==>INVALID[" + this.lineNum + "]: " + e.getMessage());
            return null;
        }
    }

    private HandleValue readHandleValue(String line) {
        try {
            StringTokenizer st = new StringTokenizer(line, SEPA_STR);
            HandleValue hv = new HandleValue();
            try {
                hv.setIndex(Integer.parseInt(st.nextToken().trim()));
            }
            catch (Exception e) {
                this.log.println("==>INVALID[" + this.lineNum + "]: error in handle value index string");
                return null;
            }
            hv.setType(Util.encodeString(st.nextToken().trim()));
            try {
                hv.setTTL(Integer.parseInt(st.nextToken().trim()));
            }
            catch (Exception e) {
                this.log.println("==>INVALID[" + this.lineNum + "]: error in handle value ttl string");
                return null;
            }
            String substr = st.nextToken().trim();
            if (substr.length() < 4) {
                this.log.println("==>INVALID[" + this.lineNum + "]: error in handle value permission string");
                return null;
            }
            hv.setAdminCanRead(substr.charAt(0) == '1');
            hv.setAdminCanWrite(substr.charAt(1) == '1');
            hv.setAnyoneCanRead(substr.charAt(2) == '1');
            hv.setAnyoneCanWrite(substr.charAt(3) == '1');
            substr = st.nextToken().trim().toUpperCase();
            if (substr.equals(ENCODING)) {
                hv.setData(Util.encodeString(st.nextToken(NEW_LINE).trim()));
            } else if (substr.equals(ADMIN_STR)) {
                AdminRecord record = new AdminRecord();
                try {
                    record.adminIdIndex = Integer.parseInt(st.nextToken(":").trim());
                }
                catch (Exception e) {
                    this.log.println("==>INVALID[" + this.lineNum + "]: error in admin index string");
                    return null;
                }
                substr = st.nextToken(":").trim();
                if (substr.length() != 12) {
                    this.log.println("==>INVALID[" + this.lineNum + "]: error in admin permission string");
                    return null;
                }
                for (int i = 0; i < substr.length(); ++i) {
                    record.perms[i] = substr.charAt(i) == '1';
                }
                substr = st.nextToken(NEW_LINE);
                record.adminId = Util.encodeString(substr.substring(1).trim());
                hv.setData(Encoder.encodeAdminRecord(record));
            } else if (substr.equals(FILE_STR)) {
                String filename = st.nextToken(NEW_LINE).trim();
                File file = new File(filename);
                if (file == null || !file.exists() || !file.canRead()) {
                    this.log.println("==>INVALID[" + this.lineNum + "]: error public key file: " + filename);
                    return null;
                }
                FileInputStream in = null;
                byte[] rawKey = new byte[(int)file.length()];
                in = new FileInputStream(file);
                int r = 0;
                for (int n = 0; n < rawKey.length && (r = ((InputStream)in).read(rawKey, n, rawKey.length - n)) > 0; n += r) {
                }
                ((InputStream)in).close();
                hv.setData(rawKey);
            } else if (substr.equals(LIST_STR)) {
                Vector<ValueReference> vt = new Vector<ValueReference>();
                substr = st.nextToken(NEW_LINE).trim();
                StringTokenizer stt = new StringTokenizer(substr, ";");
                while (stt.hasMoreTokens()) {
                    int index;
                    try {
                        index = Integer.parseInt(stt.nextToken(":").trim());
                    }
                    catch (Exception e) {
                        this.log.println("==>INVALID[" + this.lineNum + "]: error in admin index string");
                        return null;
                    }
                    String handleStr = stt.nextToken(";");
                    handleStr = handleStr.substring(1).trim();
                    if (handleStr == null || handleStr.length() <= 0) {
                        this.log.println("==>INVALID[" + this.lineNum + "]: error admin handle string");
                        return null;
                    }
                    vt.addElement(new ValueReference(Util.encodeString(handleStr), index));
                }
                if (vt.size() < 1) {
                    return null;
                }
                ValueReference[] refs = new ValueReference[vt.size()];
                for (int j = 0; j < refs.length; ++j) {
                    refs[j] = (ValueReference)vt.elementAt(j);
                }
                hv.setData(Encoder.encodeValueReferenceList(refs));
            } else {
                this.log.println("==>INVALID[" + this.lineNum + "]: error in handle data type string: '" + substr + "'");
                return null;
            }
            return hv;
        }
        catch (Exception e) {
            this.log.println("==>INVALID[" + this.lineNum + "]: " + e.getMessage());
            return null;
        }
    }

    public static void printUsage() {
        System.err.println("Usage: java net.handle.apps.batch.GenericBatch <batchfile> [<LogFile>]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        BufferedReader reader = null;
        if (args.length < 1) {
            GenericBatch.printUsage();
        } else if (args.length < 2) {
            try {
                System.err.println("Batch(" + args[0] + ") process started ...");
                FileInputStream f = new FileInputStream(args[0]);
                reader = new BufferedReader(new InputStreamReader((InputStream)f, "UTF-8"));
                GenericBatch batch = new GenericBatch(reader, null, null, null);
                batch.processBatch();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e1) {}
                }
                System.err.println("Batch process finished");
            }
        } else {
            PrintWriter log = null;
            try {
                System.err.println("Batch(" + args[0] + ") process started ...");
                FileInputStream f = new FileInputStream(args[0]);
                reader = new BufferedReader(new InputStreamReader((InputStream)f, "UTF-8"));
                log = new PrintWriter((Writer)new FileWriter(args[1]), true);
                GenericBatch batch = new GenericBatch(reader, null, log, null);
                batch.processBatch();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e1) {}
                }
                if (log != null) {
                    try {
                        log.close();
                    }
                    catch (Exception exception) {}
                }
                System.err.println("Batch process finished");
            }
        }
    }
}

