/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.db_tool;

import java.io.File;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.ScanCallback;
import net.handle.hdllib.Util;
import net.handle.server.HandleStorageFactory;
import net.handle.util.StreamTable;

public class DBList {
    private HandleStorage storage;

    public DBList(HandleStorage storage) {
        this.storage = storage;
        System.out.println("\nListing handles: ");
        try {
            storage.scanHandles(new ScanCallback(){

                public void scanHandle(byte[] handle) {
                    System.out.println(Util.decodeString(handle));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] argv) throws Exception {
        if (argv == null || argv.length < 1) {
            System.err.println("usage: java net.handle.apps.db_tool.DBList <server-directory>");
            return;
        }
        File serverDir = new File(argv[0]);
        StreamTable serverInfo = new StreamTable();
        serverInfo.readFromFile(new File(serverDir, "config.dct"));
        serverInfo = (StreamTable)serverInfo.get("server_config");
        HandleStorage storage = HandleStorageFactory.getStorage(serverDir, serverInfo, true);
        DBList dbList = new DBList(storage);
    }
}

