/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.db_tool;

import java.awt.Button;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;

public class ValueListInfoPanel
extends Panel
implements ActionListener,
ItemListener {
    private List referenceList;
    private Button newValueButton;
    private Button deleteValueButton;
    private Button upValueButton;
    private Button downValueButton;
    private TextField valueNameField;
    private TextField valueIndexField;
    private ValueReference currentValue = null;
    private Vector references = new Vector();

    public ValueListInfoPanel() {
        this.referenceList = new List(6);
        this.newValueButton = new Button("New Value");
        this.deleteValueButton = new Button("Delete Value");
        this.upValueButton = new Button("^");
        this.downValueButton = new Button("v");
        this.valueNameField = new TextField("", 15);
        this.valueIndexField = new TextField("0", 5);
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        int x = 0;
        int y = 0;
        Panel topPanel = new Panel(gridbag);
        topPanel.add((Component)this.referenceList, AwtUtil.getConstraints(x, y, 1.0, 1.0, 1, 4, true, true));
        topPanel.add((Component)this.newValueButton, AwtUtil.getConstraints(x + 1, y++, 1.0, 0.0, 2, 1, true, true));
        topPanel.add((Component)this.deleteValueButton, AwtUtil.getConstraints(x + 1, y++, 1.0, 0.0, 2, 1, true, true));
        topPanel.add((Component)this.upValueButton, AwtUtil.getConstraints(x + 1, y, 1.0, 0.0, 1, 1, true, true));
        topPanel.add((Component)this.downValueButton, AwtUtil.getConstraints(x + 2, y, 1.0, 0.0, 1, 1, true, true));
        y = 0;
        x = 0;
        this.add((Component)topPanel, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 2, 1, true, false));
        this.add((Component)new Label("Handle", 1), AwtUtil.getConstraints(x, y, 1.0, 0.0, 1, 1, true, false));
        this.add((Component)new Label("Index#", 1), AwtUtil.getConstraints(x + 1, y++, 1.0, 0.0, 1, 1, true, false));
        this.add((Component)this.valueNameField, AwtUtil.getConstraints(x, y, 1.0, 1.0, 1, 1, true, false));
        this.add((Component)this.valueIndexField, AwtUtil.getConstraints(x + 1, y++, 1.0, 1.0, 1, 1, true, false));
        this.newValueButton.addActionListener(this);
        this.deleteValueButton.addActionListener(this);
        this.upValueButton.addActionListener(this);
        this.downValueButton.addActionListener(this);
        this.referenceList.addItemListener(this);
        this.rebuildReferenceList();
        this.updateEntryFields();
    }

    public void setValueListInfo(ValueReference[] newRefs) {
        this.referenceList.removeAll();
        this.currentValue = null;
        this.referenceList.select(-1);
        this.updateEntryFields();
        if (newRefs != null) {
            for (int i = 0; i < newRefs.length; ++i) {
                this.references.addElement(new ValueReference(newRefs[i].handle, newRefs[i].index));
            }
        }
        this.rebuildReferenceList();
    }

    private void updateEntryFields() {
        int selectedIndex = this.referenceList.getSelectedIndex();
        System.err.println("updating fields, index=" + selectedIndex);
        if (selectedIndex < 0) {
            this.valueNameField.setText("");
            this.valueIndexField.setText("");
            this.currentValue = null;
        } else {
            ValueReference val = (ValueReference)this.references.elementAt(selectedIndex);
            this.valueNameField.setText(Util.decodeString(val.handle));
            this.valueIndexField.setText(String.valueOf(val.index));
            this.currentValue = val;
        }
        this.valueNameField.setEnabled(this.currentValue != null);
        this.valueIndexField.setEnabled(this.currentValue != null);
    }

    private void saveCurrentValue() {
        if (this.currentValue == null) {
            return;
        }
        this.currentValue.handle = Util.encodeString(this.valueNameField.getText());
        try {
            this.currentValue.index = Integer.parseInt(this.valueIndexField.getText().trim());
        }
        catch (Exception e) {
            System.err.println("Invalid index value: " + this.valueIndexField.getText());
            this.getToolkit().beep();
        }
        this.rebuildReferenceList();
    }

    private void rebuildReferenceList() {
        this.referenceList.removeAll();
        for (int i = 0; i < this.references.size(); ++i) {
            this.referenceList.addItem(String.valueOf(this.references.elementAt(i)));
        }
        int sel = -1;
        if (this.currentValue != null) {
            sel = this.references.indexOf(this.currentValue);
        }
        this.referenceList.select(sel);
    }

    public ValueReference[] getValueListInfo() {
        this.saveCurrentValue();
        ValueReference[] refs = new ValueReference[this.references.size()];
        for (int i = 0; i < refs.length; ++i) {
            ValueReference ref = (ValueReference)this.references.elementAt(i);
            System.err.println("getting value: " + ref);
            refs[i] = new ValueReference(ref.handle, ref.index);
        }
        return refs;
    }

    private void itemSelected() {
        this.saveCurrentValue();
        this.updateEntryFields();
    }

    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.referenceList) {
            this.itemSelected();
        }
    }

    public void actionPerformed(ActionEvent evt) {
        int idx;
        Object src = evt.getSource();
        if (src == this.newValueButton) {
            this.saveCurrentValue();
            this.references.addElement(new ValueReference(Util.encodeString(""), 0));
            this.rebuildReferenceList();
            this.referenceList.select(this.references.size() - 1);
            this.updateEntryFields();
        } else if (src == this.deleteValueButton) {
            if (this.currentValue != null) {
                this.references.removeElement(this.currentValue);
                this.currentValue = null;
                this.rebuildReferenceList();
            }
        } else if (src == this.upValueButton) {
            int idx2;
            if (this.currentValue != null && (idx2 = this.references.indexOf(this.currentValue)) > 0) {
                this.references.removeElement(this.currentValue);
                this.references.insertElementAt(this.currentValue, idx2 - 1);
                this.rebuildReferenceList();
            }
        } else if (src == this.downValueButton && this.currentValue != null && (idx = this.references.indexOf(this.currentValue)) >= 0 && idx < this.references.size() - 1) {
            this.references.removeElement(this.currentValue);
            this.references.insertElementAt(this.currentValue, idx + 1);
            this.rebuildReferenceList();
        }
    }
}

