/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.jwidget;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.handle.apps.gui.jutil.CommonDef;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.Interface;

public class InterfaceJPanel
extends JPanel {
    protected JTextField portField = new JTextField("", 5);
    protected JComboBox typeList;
    protected JComboBox protocolList;
    protected Interface interf;

    public InterfaceJPanel(boolean editFlag) {
        super(new GridBagLayout());
        int i;
        this.portField.setEnabled(editFlag);
        this.protocolList = new JComboBox();
        this.protocolList.setToolTipText("Choose interface protocol");
        this.protocolList.setEditable(false);
        this.protocolList.setEnabled(editFlag);
        for (i = 0; i < CommonDef.INTERFACE_PROTOCOL_STR.length; ++i) {
            this.protocolList.addItem(CommonDef.INTERFACE_PROTOCOL_STR[i]);
        }
        this.typeList = new JComboBox();
        this.typeList.setToolTipText("Choose interface type");
        this.typeList.setEditable(false);
        this.typeList.setEnabled(editFlag);
        for (i = 0; i < CommonDef.INTERFACE_ADMIN_STR.length; ++i) {
            this.typeList.addItem(CommonDef.INTERFACE_ADMIN_STR[i]);
        }
        int x = 0;
        int y = 0;
        Insets insets = new Insets(5, 5, 5, 5);
        this.add((Component)new JLabel(" Bind port: ", 4), AwtUtil.getConstraints(x, y, 1.0, 1.0, 1, 1, true, true));
        this.add((Component)this.portField, AwtUtil.getConstraints(x + 1, y++, 1.0, 1.0, 1, 1, insets, 17, false, true));
        this.add((Component)new JLabel("Protocol: ", 4), AwtUtil.getConstraints(x, y, 1.0, 1.0, 1, 1, insets, true, true));
        this.add((Component)this.protocolList, AwtUtil.getConstraints(x + 1, y, 1.0, 1.0, 1, 1, insets, 17, false, true));
        this.add((Component)new JLabel("Admin type: ", 4), AwtUtil.getConstraints(x + 2, y, 1.0, 1.0, 1, 1, true, true));
        this.add((Component)this.typeList, AwtUtil.getConstraints(x + 3, y++, 1.0, 1.0, 1, 1, insets, 17, false, true));
        this.interf = new Interface();
    }

    public void setInterface(Interface interf) {
        if (interf == null) {
            return;
        }
        try {
            this.protocolList.setSelectedIndex(interf.protocol);
            this.typeList.setSelectedIndex(interf.type);
            this.portField.setText(String.valueOf(interf.port));
        }
        catch (Exception e) {
            System.err.println("Interface: " + interf);
            e.printStackTrace(System.err);
        }
    }

    public void setPortEditable(boolean flag) {
        this.portField.setEditable(flag);
    }

    public Interface getInterface() {
        try {
            int ind = this.protocolList.getSelectedIndex();
            this.interf.protocol = CommonDef.INTERFACE_PROTOCOL_TYPE[ind];
            ind = this.typeList.getSelectedIndex();
            this.interf.type = CommonDef.INTERFACE_ADMIN_TYPE[ind];
            this.interf.port = Integer.parseInt(this.portField.getText().trim());
            return this.interf;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }
}

