/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.jwidget;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import net.handle.apps.gui.jutil.JUtil;
import net.handle.apps.gui.jwidget.DataListJPanel;
import net.handle.apps.gui.jwidget.InterfaceJPanel;
import net.handle.apps.gui.jwidget.PubkeyDataJPanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.Interface;
import net.handle.hdllib.ServerInfo;

public class ServerInfoJPanel
extends JPanel {
    protected JTextField ipField;
    protected JTextField indField;
    protected PubkeyDataJPanel pubkeyPanel;
    protected InterfaceList dataList;
    protected ServerInfo server;
    protected boolean editFlag;

    public ServerInfoJPanel(boolean editFlag) {
        super(new GridBagLayout());
        this.editFlag = editFlag;
        this.ipField = new JTextField("", 20);
        this.ipField.setEditable(editFlag);
        this.indField = new JTextField("", 5);
        this.indField.setEditable(editFlag);
        this.pubkeyPanel = new PubkeyDataJPanel(false, editFlag);
        this.dataList = new InterfaceList();
        int x = 0;
        int y = 0;
        Insets insets = new Insets(2, 5, 2, 5);
        this.add((Component)new JLabel(" IP address: ", 4), AwtUtil.getConstraints(x, y, 1.0, 1.0, 1, 1, true, true));
        this.add((Component)this.ipField, AwtUtil.getConstraints(x + 1, y++, 1.0, 1.0, 1, 1, insets, 17, false, false));
        this.add((Component)new JLabel(" ServerId: ", 4), AwtUtil.getConstraints(x, y, 1.0, 1.0, 1, 1, true, true));
        this.add((Component)this.indField, AwtUtil.getConstraints(x + 1, y++, 1.0, 1.0, 1, 1, insets, 17, false, false));
        EtchedBorder etchBorder = new EtchedBorder();
        this.pubkeyPanel.setBorder(etchBorder);
        this.add((Component)this.pubkeyPanel, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 2, 1, insets, 17, true, true));
        this.dataList.setBorder(new TitledBorder(etchBorder, " Interfaces: "));
        this.add((Component)this.dataList, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 2, 1, true, true));
        this.server = new ServerInfo();
    }

    public ServerInfo getServerInfo() {
        try {
            this.server.serverId = this.getServerId();
            this.server.ipAddress = this.getByteIP();
            this.server.publicKey = this.pubkeyPanel.getValueData();
            Vector v = this.dataList.getItems();
            if (v != null) {
                Interface[] interf = new Interface[v.size()];
                for (int i = 0; i < v.size(); ++i) {
                    interf[i] = (Interface)v.elementAt(i);
                }
                this.server.interfaces = interf;
            }
            return this.server;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public void setServerInfo(ServerInfo serv) {
        if (serv == null) {
            return;
        }
        try {
            this.indField.setText(Integer.toString(serv.serverId));
            this.ipField.setText(serv.getAddressString());
            if (serv.interfaces != null) {
                for (int i = 0; i < serv.interfaces.length; ++i) {
                    this.dataList.appendItem(serv.interfaces[i]);
                }
            }
            if (serv.publicKey != null) {
                this.pubkeyPanel.setValueData(serv.publicKey);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void setIP(int ip) {
        this.ipField.setText(String.valueOf(ip));
    }

    public int getIP() {
        try {
            return Integer.parseInt(this.ipField.getText().trim());
        }
        catch (Exception e) {
            return -1;
        }
    }

    public String getIPStr() {
        return this.ipField.getText().trim();
    }

    public byte[] getByteIP() {
        return JUtil.getByteIP(this.getIPStr());
    }

    public int getServerId() {
        try {
            return Integer.parseInt(this.indField.getText().trim());
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void setServerId(int ind) {
        this.indField.setText(String.valueOf(ind));
    }

    class InterfaceList
    extends DataListJPanel {
        InterfaceList() {
            int x = 0;
            int y = 0;
            GridBagLayout gridbag = new GridBagLayout();
            this.buttonPanel = new JPanel(gridbag);
            if (ServerInfoJPanel.this.editFlag) {
                this.buttonPanel.add((Component)this.addItemButton, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, true));
                this.buttonPanel.add((Component)this.editItemButton, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, true));
                this.buttonPanel.add((Component)this.remItemButton, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, true));
                this.buttonPanel.add((Component)this.clearButton, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, true));
            }
            this.buttonPanel.add((Component)this.viewItemButton, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, ServerInfoJPanel.this.editFlag));
            this.add((Component)this.pane, AwtUtil.getConstraints(0, 0, 1.0, 1.0, 2, 10, true, true));
            this.add((Component)this.buttonPanel, AwtUtil.getConstraints(2, 0, 1.0, 1.0, 1, 8, false, true));
        }

        protected Object addData() {
            InterfaceJPanel p = new InterfaceJPanel(true);
            if (2 == JOptionPane.showConfirmDialog(null, p, " Add Interface: ", 2, -1)) {
                return null;
            }
            return p.getInterface();
        }

        protected Object modifyData(int ind) {
            Interface interf = (Interface)this.items.elementAt(ind);
            InterfaceJPanel p = new InterfaceJPanel(true);
            p.setInterface(interf);
            if (2 == JOptionPane.showConfirmDialog(null, p, " Modify Interface: ", 2, -1)) {
                return null;
            }
            return p.getInterface();
        }

        protected boolean removeData(int ind) {
            return true;
        }

        protected void viewData(int ind) {
            Interface interf = (Interface)this.items.elementAt(ind);
            InterfaceJPanel p = new InterfaceJPanel(false);
            p.setInterface(interf);
            JOptionPane.showMessageDialog(this, p, "View Interface: ", -1);
        }
    }
}

