/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.test;

import java.io.File;
import net.handle.apps.test.ClientTest;
import net.handle.apps.test.ServerTest;
import net.handle.util.StreamTable;

public class Test {
    private static File configDir;
    private static StreamTable configTable;

    public static void printUsage() {
        System.err.println("USAGE_1: java -classpath <classpath> net.handle.apps.test.Test [server|write|all] <config.dct directory>");
        System.err.println("USAGE_2: java -classpath <classpath> net.handle.apps.test.Test client [naming authority]");
    }

    public static void getConfig(String configDirStr) {
        try {
            configDir = new File(configDirStr);
            configTable.readFromFile(new File(configDir, "config.dct"));
        }
        catch (Exception e) {
            System.err.println("ERROR READING CONFIGURATION");
            System.exit(-1);
        }
        if (!configDir.exists() || !configDir.isDirectory()) {
            System.err.println("INVALID CONFIGURATION DIRECTORY");
            System.exit(-1);
        }
    }

    public static void main(String[] argv) {
        if (argv == null || argv.length <= 0) {
            Test.printUsage();
            System.exit(-1);
        }
        String inputStr = null;
        for (int i = 1; i < argv.length; ++i) {
            if (inputStr != null) continue;
            inputStr = argv[i];
        }
        String action = argv[0].toUpperCase().trim();
        if (inputStr == null && !action.equals("CLIENT")) {
            Test.printUsage();
            System.exit(-1);
        }
        try {
            if (action.equals("CLIENT")) {
                System.out.println("*****Begin Client Test*****");
                ClientTest clientTester = new ClientTest();
                if (inputStr == null) {
                    clientTester.testGlobalSites();
                } else {
                    ClientTest.testNASites(argv[1].toUpperCase().trim());
                }
            } else if (action.equals("SERVER")) {
                Test.getConfig(inputStr);
                System.out.println("*****Begin Server Test*****");
                ServerTest serverTester = new ServerTest(configTable, configDir);
            } else if (action.equals("ALL")) {
                Test.getConfig(inputStr);
                System.out.println("\n******Begin Client Test******");
                ClientTest clientTester = new ClientTest();
                clientTester.testGlobalSites();
                System.out.println("\n******Begin Server Test******");
                ServerTest serverTester = new ServerTest(configTable, configDir);
            } else {
                Test.printUsage();
                System.exit(-1);
            }
        }
        catch (Exception e) {
            System.exit(-1);
        }
    }

    static {
        configTable = new StreamTable();
    }
}

