/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.tools;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.PrivateKey;
import net.handle.hdllib.Util;

public class KeyUtil {
    private static final void printUsage() {
        System.err.println("usage: net.handle.apps.tools.KeyUtil <privatekeyfile>");
    }

    public static void main(String[] argv) throws Exception {
        InputStream in;
        if (argv.length < 1) {
            KeyUtil.printUsage();
            return;
        }
        PrivateKey privateKey = null;
        File privateKeyFile = null;
        try {
            int i;
            int r;
            privateKeyFile = new File(argv[0]);
            if (!privateKeyFile.exists() || !privateKeyFile.canRead()) {
                System.err.println("Missing or inaccessible private key file: " + privateKeyFile.getAbsolutePath());
                return;
            }
            in = new FileInputStream(privateKeyFile);
            byte[] encKeyBytes = new byte[(int)privateKeyFile.length()];
            for (int n = 0; n < encKeyBytes.length && (r = ((FileInputStream)in).read(encKeyBytes, n, encKeyBytes.length - n)) >= 0; n += r) {
            }
            byte[] keyBytes = null;
            byte[] secKey = null;
            if (Util.requiresSecretKey(encKeyBytes)) {
                secKey = Util.getPassphrase("Enter the passphrase for this private key: ");
            }
            keyBytes = Util.decrypt(encKeyBytes, secKey);
            for (i = 0; secKey != null && i < secKey.length; ++i) {
                secKey[i] = 0;
            }
            privateKey = Util.getPrivateKeyFromBytes(keyBytes, 0);
            for (i = 0; i < keyBytes.length; ++i) {
                keyBytes[i] = 0;
            }
        }
        catch (Exception e) {
            System.err.println("Unable to read private key: " + e);
            return;
        }
        in = new DataInputStream(System.in);
        while (true) {
            System.out.println("\nChoose an operation:");
            System.out.println("  1: Encrypt private key with passphrase");
            System.out.println("  2: Save private key without encryption");
            System.out.println("  3: Exit");
            System.out.flush();
            String line = ((DataInputStream)in).readLine();
            if (line == null) break;
            if ((line = line.trim()).equals("1")) {
                KeyUtil.encryptKey(privateKey, privateKeyFile, (DataInputStream)in, 0);
                continue;
            }
            if (line.equals("2")) {
                KeyUtil.encryptKey(privateKey, privateKeyFile, (DataInputStream)in, 1);
                continue;
            }
            if (line.equals("3")) {
                System.exit(0);
                continue;
            }
            System.out.println("Huh?  Please enter 1, 2, or 3");
        }
    }

    private static void encryptKey(PrivateKey privateKey, File privateKeyFile, DataInputStream in, int encryptionType) throws Exception {
        byte[] keyBytes = Util.getBytesFromPrivateKey(privateKey);
        byte[] encKeyBytes = null;
        if (encryptionType == 1) {
            encKeyBytes = Util.encrypt(keyBytes, null, encryptionType);
        } else {
            byte[] secKey2;
            byte[] secKey = null;
            while (!Util.equals(secKey = Util.getPassphrase("Please enter a new private key passphrase: "), secKey2 = Util.getPassphrase("Please re-enter the private key passphrase: "))) {
                System.out.println("Passphrases do not match!  Try again.\n");
            }
            encKeyBytes = Util.encrypt(keyBytes, secKey, encryptionType);
        }
        FileOutputStream out = new FileOutputStream(privateKeyFile);
        out.write(encKeyBytes);
        out.close();
        System.out.println("Private key saved to file: " + privateKeyFile);
    }
}

