/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;
import net.handle.hdllib.AdminRecord;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import net.handle.server.HandleStorageFactory;
import net.handle.util.StreamTable;

public class SplitHandlesIntoStorage {
    public static final String ENCODING = "UTF8";
    public static final String AUTH_STR = "AUTHENTICATE";
    public static final String SECKEY_STR = "SECKEY";
    public static final String PUBKEY_STR = "PUBKEY";
    public static final String CREATE_STR = "CREATE";
    public static final String DELETE_STR = "DELETE";
    public static final String ADD_STR = "ADD";
    public static final String MODIFY_STR = "MODIFY";
    public static final String REMOVE_STR = "REMOVE";
    public static final String HOME_STR = "HOME";
    public static final String UNHOME_STR = "UNHOME";
    public static final String SEPA_STR = " ";
    public static final String NEW_LINE = "\n";
    public static final String ADMIN_STR = "ADMIN";
    public static final String FILE_STR = "FILE";
    public static final String LIST_STR = "LIST";
    private HandleStorage[] destDBs;
    private BufferedReader batchReader;
    private PrintStream log = System.err;
    private int numDBs;
    private int lineNum = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        if (argv.length < 3) {
            System.err.println("usage: java net.handle.apps.tools.SplitHandlesIntoStorage <sourcefile> <destdir1> <destdir2> ...");
            System.err.println("If <sourcefile> is '-' then the handles are read from STDIN");
            return;
        }
        SplitHandlesIntoStorage splitServer = new SplitHandlesIntoStorage();
        try {
            splitServer.init(argv);
            splitServer.doit();
        }
        finally {
            splitServer.cleanup();
        }
    }

    public void init(String[] argv) throws Exception {
        String origFileStr = argv[0];
        InputStream in = origFileStr.equals("-") ? System.in : new FileInputStream(origFileStr);
        this.batchReader = new BufferedReader(new InputStreamReader(in, ENCODING));
        this.numDBs = argv.length - 1;
        this.destDBs = new HandleStorage[this.numDBs];
        boolean completed = false;
        for (int i = 0; i < this.destDBs.length; ++i) {
            String destDirStr = argv[i] + 1;
            this.log.println("loading dest db: " + destDirStr);
            File destDir = new File(destDirStr);
            StreamTable config = new StreamTable();
            try {
                config.readFromFile(new File(destDir, "config.dct"));
            }
            catch (Exception e) {
                this.log.println("Error reading config.dct file from directory: " + destDir.getAbsolutePath());
                throw e;
            }
            if (!config.containsKey("server_config")) {
                throw new Exception("Invalid config file in directory: " + destDir.getAbsolutePath());
            }
            this.destDBs[i] = HandleStorageFactory.getStorage(destDir, config, true);
        }
    }

    final void doit() throws Exception {
        while (true) {
            String line = this.batchReader.readLine();
            ++this.lineNum;
            if (line == null) break;
            if (line.trim().length() <= 0) continue;
            int spaceIdx = line.indexOf(32);
            if (spaceIdx < 0) {
                throw new Exception("Invalid batch command line: '" + line + "'");
            }
            String command = line.substring(0, spaceIdx);
            byte[] handle = Util.encodeString(line.substring(spaceIdx + 1).trim());
            if (!command.equalsIgnoreCase("create")) continue;
            HandleValue[] values = this.readHandleValueArray();
            int serverNum = SiteInfo.determineServerNum(handle, 2, this.destDBs.length);
            this.destDBs[serverNum].createHandle(handle, values);
        }
    }

    void cleanup() {
        for (int i = 0; this.destDBs != null && i < this.destDBs.length; ++i) {
            try {
                if (this.destDBs[i] == null) continue;
                this.destDBs[i].shutdown();
                continue;
            }
            catch (Throwable t) {
                this.log.println("Error shutting down server " + i + " (starting with zero): " + t);
            }
        }
    }

    private HandleValue[] readHandleValueArray() {
        Vector<HandleValue> vt = new Vector<HandleValue>();
        try {
            String line;
            while ((line = this.batchReader.readLine()) != null) {
                if (++this.lineNum % 1000 == 999) {
                    System.gc();
                }
                line.trim();
                if (line.length() <= 0) break;
                HandleValue hv = this.readHandleValue(line);
                if (hv == null) {
                    return null;
                }
                vt.addElement(hv);
            }
            if (vt.size() < 1) {
                return null;
            }
            HandleValue[] values = new HandleValue[vt.size()];
            for (int i = 0; i < vt.size(); ++i) {
                values[i] = (HandleValue)vt.elementAt(i);
            }
            return values;
        }
        catch (Exception e) {
            this.log.println("==>INVALID[" + this.lineNum + "]: " + e.getMessage());
            return null;
        }
    }

    private HandleValue readHandleValue(String line) {
        try {
            StringTokenizer st = new StringTokenizer(line, SEPA_STR);
            HandleValue hv = new HandleValue();
            try {
                hv.setIndex(Integer.parseInt(st.nextToken().trim()));
            }
            catch (Exception e) {
                this.log.println("==>INVALID[" + this.lineNum + "]: error in handle value index string");
                return null;
            }
            hv.setType(Util.encodeString(st.nextToken().trim()));
            try {
                hv.setTTL(Integer.parseInt(st.nextToken().trim()));
            }
            catch (Exception e) {
                this.log.println("==>INVALID[" + this.lineNum + "]: error in handle value ttl string");
                return null;
            }
            String substr = st.nextToken().trim();
            if (substr.length() < 4) {
                this.log.println("==>INVALID[" + this.lineNum + "]: error in handle value permission string");
                return null;
            }
            hv.setAdminCanRead(substr.charAt(0) == '1');
            hv.setAdminCanWrite(substr.charAt(1) == '1');
            hv.setAnyoneCanRead(substr.charAt(2) == '1');
            hv.setAnyoneCanWrite(substr.charAt(3) == '1');
            substr = st.nextToken().trim().toUpperCase();
            if (substr.equals(ENCODING)) {
                hv.setData(Util.encodeString(st.nextToken(NEW_LINE).trim()));
            } else if (substr.equals(ADMIN_STR)) {
                AdminRecord record = new AdminRecord();
                try {
                    record.adminIdIndex = Integer.parseInt(st.nextToken(":").trim());
                }
                catch (Exception e) {
                    this.log.println("==>INVALID[" + this.lineNum + "]: error in admin index string");
                    return null;
                }
                substr = st.nextToken(":").trim();
                if (substr.length() != 12) {
                    this.log.println("==>INVALID[" + this.lineNum + "]: error in admin permission string");
                    return null;
                }
                for (int i = 0; i < substr.length(); ++i) {
                    record.perms[i] = substr.charAt(i) == '1';
                }
                substr = st.nextToken(NEW_LINE);
                record.adminId = Util.encodeString(substr.substring(1).trim());
                hv.setData(Encoder.encodeAdminRecord(record));
            } else if (substr.equals(FILE_STR)) {
                String filename = st.nextToken(NEW_LINE).trim();
                File file = new File(filename);
                if (file == null || !file.exists() || !file.canRead()) {
                    this.log.println("==>INVALID[" + this.lineNum + "]: error public key file: " + filename);
                    return null;
                }
                FileInputStream in = null;
                byte[] rawKey = new byte[(int)file.length()];
                in = new FileInputStream(file);
                int r = 0;
                for (int n = 0; n < rawKey.length && (r = ((InputStream)in).read(rawKey, n, rawKey.length - n)) > 0; n += r) {
                }
                ((InputStream)in).close();
                hv.setData(rawKey);
            } else if (substr.equals(LIST_STR)) {
                Vector<ValueReference> vt = new Vector<ValueReference>();
                substr = st.nextToken(NEW_LINE).trim();
                StringTokenizer stt = new StringTokenizer(substr, ";");
                while (stt.hasMoreTokens()) {
                    int index;
                    try {
                        index = Integer.parseInt(stt.nextToken(":").trim());
                    }
                    catch (Exception e) {
                        this.log.println("==>INVALID[" + this.lineNum + "]: error in admin index string");
                        return null;
                    }
                    String handleStr = stt.nextToken(";");
                    handleStr = handleStr.substring(1).trim();
                    if (handleStr == null || handleStr.length() <= 0) {
                        this.log.println("==>INVALID[" + this.lineNum + "]: error admin handle string");
                        return null;
                    }
                    vt.addElement(new ValueReference(Util.encodeString(handleStr), index));
                }
                if (vt.size() < 1) {
                    return null;
                }
                ValueReference[] refs = new ValueReference[vt.size()];
                for (int j = 0; j < refs.length; ++j) {
                    refs[j] = (ValueReference)vt.elementAt(j);
                }
                hv.setData(Encoder.encodeValueReferenceList(refs));
            } else {
                this.log.println("==>INVALID[" + this.lineNum + "]: error in handle data type string: '" + substr + "'");
                return null;
            }
            return hv;
        }
        catch (Exception e) {
            this.log.println("==>INVALID[" + this.lineNum + "]: " + e.getMessage());
            return null;
        }
    }
}

