/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;
import net.handle.server.DBTxn;

class ViewJDBLog {
    private File txnFile;

    ViewJDBLog(File txnFile) {
        this.txnFile = txnFile;
    }

    void viewLog(String[] hdlsToView) throws Exception {
        byte[][] encHdls = new byte[hdlsToView.length][];
        for (int i = 0; i < encHdls.length; ++i) {
            encHdls[i] = Util.encodeString(hdlsToView[i].toUpperCase());
        }
        boolean showAll = hdlsToView.length == 0;
        System.out.println("Restoring from transactions...");
        System.out.flush();
        BufferedInputStream txnInput = new BufferedInputStream(new FileInputStream(this.txnFile));
        DBTxn txn = null;
        block1: while ((txn = DBTxn.readTxn(txnInput)) != null) {
            if (showAll) {
                System.out.println(ViewJDBLog.txnToString(txn));
                continue;
            }
            byte[] hdl = txn.getKey();
            Util.upperCaseInPlace(hdl);
            for (int i = 0; i < encHdls.length; ++i) {
                if (!Util.equals(hdl, encHdls[i])) continue;
                System.out.println(ViewJDBLog.txnToString(txn));
                System.out.flush();
                continue block1;
            }
        }
    }

    private static final String txnToString(DBTxn txn) throws Exception {
        StringBuffer sb = new StringBuffer();
        switch (txn.getAction()) {
            case 0: {
                sb.append("SET  ");
                break;
            }
            case 1: {
                sb.append("DELETE  ");
                break;
            }
            case 2: {
                sb.append("SET NA  ");
                break;
            }
            case 3: {
                sb.append("DELETE NA  ");
                break;
            }
            case 4: {
                sb.append("DELETE EVERYTHING!!!  ");
            }
        }
        sb.append(Util.decodeString(txn.getKey()));
        sb.append("   ");
        sb.append(new Date(txn.getDate()));
        sb.append("\n");
        if (txn.getAction() != 0) {
            return sb.toString();
        }
        byte[] value = txn.getValue();
        int bufPos = 0;
        int numValues = Encoder.readInt(value, bufPos);
        bufPos += 4;
        HandleValue[] values = new HandleValue[numValues];
        for (int i = 0; i < numValues; ++i) {
            int clumpLen = Encoder.readInt(value, bufPos);
            values[i] = new HandleValue();
            Encoder.decodeHandleValue(value, bufPos += 4, values[i]);
            sb.append("  ");
            sb.append(values[i]);
            sb.append("\n");
            bufPos += clumpLen;
        }
        return sb.toString();
    }

    private static final void printUsage() {
        System.err.println("usage: java net.handle.apps.tools.ViewJDBLog <server_directory> <handle-to-show> [<handle-to-show>...]");
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length < 1) {
            ViewJDBLog.printUsage();
            System.exit(1);
            return;
        }
        File hsDir = new File(argv[0]);
        System.err.println("directory: " + hsDir);
        if (!hsDir.exists() || !hsDir.isDirectory()) {
            System.err.println("Server directory doesn't exist!");
            System.exit(1);
            return;
        }
        File txnFile = new File(hsDir, "dbtxns.log");
        if (!txnFile.exists()) {
            System.err.println("Error: Transaction log file (dbtxns.log) doesn't exist!");
            System.exit(1);
            return;
        }
        String[] hdls = new String[argv.length - 1];
        System.arraycopy(argv, 1, hdls, 0, hdls.length);
        ViewJDBLog recoverer = new ViewJDBLog(txnFile);
        recoverer.viewLog(hdls);
    }
}

