/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.util.Vector;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ClientSideSessionInfo;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.SessionInfo;
import net.handle.hdllib.SessionSetupInfo;
import net.handle.hdllib.Util;

public class ClientSessionTracker {
    private static final String ANONYMOUS_PLACEHOLDER = "anonymous";
    private Vector serverList = new Vector();
    private Vector sessionList = new Vector();
    private Vector authList = new Vector();
    private SessionSetupInfo sessionSetupInfo = null;

    public ClientSessionTracker() {
    }

    public ClientSessionTracker(SessionSetupInfo setupInfo) {
        this.sessionSetupInfo = setupInfo;
    }

    public void setSessionSetupInfo(SessionSetupInfo setupInfo) {
        this.sessionSetupInfo = setupInfo;
    }

    public SessionSetupInfo getSessionSetupInfo() {
        return this.sessionSetupInfo;
    }

    public synchronized ClientSideSessionInfo getSession(ServerInfo server, AuthenticationInfo authInfo) {
        SessionInfo session = null;
        int listSize = this.authList.size();
        for (int i = this.authList.size() - 1; i >= 0; --i) {
            if (server.equals(this.serverList.elementAt(i)) && (authInfo == null && this.authList.elementAt(i) == ANONYMOUS_PLACEHOLDER || authInfo != null && this.authList.elementAt(i).equals(authInfo))) {
                session = (ClientSideSessionInfo)this.sessionList.elementAt(i);
            }
            if (session != null && session.hasExpired()) {
                for (int j = this.authList.size() - 1; j >= 0; --j) {
                    if (!((ClientSideSessionInfo)session).equals(this.sessionList.elementAt(j))) continue;
                    this.sessionList.removeElementAt(j);
                    this.authList.removeElementAt(j);
                    this.serverList.removeElementAt(j);
                }
                session = null;
                continue;
            }
            if (session == null) continue;
            return session;
        }
        return null;
    }

    synchronized AuthenticationInfo getAuthenticationInfo(ClientSideSessionInfo sessionInfo) {
        if (sessionInfo == null) {
            return null;
        }
        for (int i = this.sessionList.size() - 1; i >= 0; --i) {
            if (!this.sessionList.elementAt(i).equals(sessionInfo)) continue;
            return (AuthenticationInfo)this.authList.elementAt(i);
        }
        return null;
    }

    public synchronized ClientSideSessionInfo[] getAllSessions() {
        Vector tempSessions = new Vector();
        for (int i = this.sessionList.size() - 1; i >= 0; --i) {
            Object obj = this.sessionList.elementAt(i);
            if (tempSessions.contains(obj)) continue;
            tempSessions.addElement(obj);
        }
        ClientSideSessionInfo[] sessions = new ClientSideSessionInfo[tempSessions.size()];
        tempSessions.toArray(sessions);
        return sessions;
    }

    public synchronized void putSession(ClientSideSessionInfo session, ServerInfo server, AuthenticationInfo authInfo) {
        this.serverList.addElement(server);
        this.sessionList.addElement(session);
        if (authInfo == null) {
            this.authList.addElement(ANONYMOUS_PLACEHOLDER);
        } else {
            this.authList.addElement(authInfo);
        }
    }

    public synchronized void removeSession(ClientSideSessionInfo session) {
        for (int j = this.authList.size() - 1; j >= 0; --j) {
            if (!session.equals(this.sessionList.elementAt(j))) continue;
            this.sessionList.removeElementAt(j);
            this.authList.removeElementAt(j);
            this.serverList.removeElementAt(j);
        }
    }

    public static boolean sessionOptionChanged(ClientSideSessionInfo csinfo, SessionSetupInfo option) {
        if (csinfo == null || option == null) {
            return false;
        }
        return !Util.equals(csinfo.getExchangeKeyRefHandle(), option.exchangeKeyHandle) || csinfo.getExchangeKeyRefindex() != option.exchangeKeyIndex || !Util.equals(csinfo.getExchagePublicKey(), option.publicExchangeKey) || csinfo.getTimeOut() != option.timeout || csinfo.encryptMessage != option.encrypted || csinfo.authenticateMessage != option.authenticated;
    }
}

