/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.security.MessageDigest;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ChallengeResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.Util;

public class SecretKeyAuthenticationInfo
extends AuthenticationInfo {
    private static Integer md5Lock = new Integer(123);
    private static MessageDigest md5 = null;
    private byte[] secretKey;
    private byte[] userIdHandle;
    private int userIdIndex;

    public SecretKeyAuthenticationInfo(byte[] userIDHandle, int userIDIndex, byte[] secretKey) {
        this.secretKey = secretKey;
        this.userIdHandle = userIDHandle;
        this.userIdIndex = userIDIndex;
    }

    public SecretKeyAuthenticationInfo(byte[] userIDHandle, int userIDIndex, byte[] secretKey, boolean shadow) throws Exception {
        this.secretKey = Encoder.encodeSecretKey(secretKey, shadow);
        this.userIdHandle = userIDHandle;
        this.userIdIndex = userIDIndex;
    }

    public byte[] getAuthType() {
        return Common.MD5_SECRET_KEY_TYPE;
    }

    public byte[] authenticate(ChallengeResponse challenge, AbstractRequest request) throws HandleException {
        boolean oldFormat;
        byte[] origMessage = request.getEncodedMessageBody();
        byte[] origDigest = Util.doDigest(challenge.rdHashType, origMessage);
        if (!Util.equals(origDigest, challenge.requestDigest)) {
            throw new HandleException(10, "Asked to sign unidentified request!");
        }
        byte digestAlg = 2;
        boolean bl = oldFormat = challenge.majorProtocolVersion == 5 && challenge.minorProtocolVersion == 0 || challenge.majorProtocolVersion == 2 && challenge.minorProtocolVersion == 0;
        if (oldFormat) {
            digestAlg = 0;
        }
        byte[] digest = Util.doDigest(digestAlg, this.secretKey, challenge.nonce, challenge.requestDigest, this.secretKey);
        if (oldFormat) {
            return digest;
        }
        byte[] authResponse = new byte[digest.length + 1];
        authResponse[0] = digestAlg;
        System.arraycopy(digest, 0, authResponse, 1, digest.length);
        return authResponse;
    }

    public byte[] getUserIdHandle() {
        return this.userIdHandle;
    }

    public int getUserIdIndex() {
        return this.userIdIndex;
    }

    public byte[] getSecretKey() {
        return this.secretKey;
    }

    public String toString() {
        return "secret_key:" + String.valueOf(this.userIdIndex) + ':' + (this.userIdHandle == null ? "null" : Util.decodeString(this.userIdHandle));
    }
}

