/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.ErrorResponse;
import net.handle.hdllib.MessageEnvelope;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.Util;
import net.handle.server.AbstractServer;
import net.handle.server.HandleServer;
import net.handle.server.HdlUdpInterface;
import net.handle.server.HdlUdpPendingRequest;
import net.handle.server.Main;
import net.handle.server.RequestHandler;
import net.handle.server.RequestHandlerPool;
import net.handle.server.ServerSideSessionInfo;

public class HdlUdpRequestHandler
implements Runnable,
RequestHandler,
ResponseMessageCallback {
    private DatagramPacket packet;
    private DatagramSocket dsocket;
    private AbstractServer server;
    private Main main;
    private HdlUdpInterface listener;
    private Thread handlerThread;
    private int invocations = 0;
    private boolean isActive = true;
    private boolean isRunning = false;
    private boolean logAccesses = false;
    private RequestHandlerPool handlerPool = null;
    private MessageEnvelope envelope = new MessageEnvelope();
    private AbstractRequest currentRequest;
    private long recvTime;
    public static final String ACCESS_TYPE = "UDP:HDL";
    private static final byte[] MSG_MESSAGE_TOO_LONG = Util.encodeString("Message too long");
    private static final byte[] MSG_CANNOT_STREAM_UDP = Util.encodeString("Cannot stream UDP messages");

    public HdlUdpRequestHandler(Main main, DatagramSocket dsock, RequestHandlerPool handlerPool, HdlUdpInterface listener, boolean logAccesses) {
        this.main = main;
        this.server = main.getServer();
        this.dsocket = dsock;
        this.handlerPool = handlerPool;
        this.logAccesses = logAccesses;
        this.listener = listener;
        this.handlerThread = new Thread(this);
        this.handlerThread.start();
    }

    public void resetThread() {
    }

    public RequestHandler newHandler() {
        return new HdlUdpRequestHandler(this.main, this.dsocket, this.handlerPool, this.listener, this.logAccesses);
    }

    public synchronized void deactivate() {
        this.isActive = false;
        this.resetState();
    }

    public int getInvocationCount() {
        return this.invocations;
    }

    public void resetState() {
        this.isRunning = false;
        this.packet = null;
    }

    public synchronized void serviceRequest(DatagramPacket packet, long recvTime) {
        this.packet = packet;
        this.recvTime = recvTime;
        this.isRunning = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (this.isActive) {
            boolean multiPartRequest = false;
            byte[] pkt = null;
            int pktLen = 0;
            int offset = 20;
            HdlUdpRequestHandler hdlUdpRequestHandler = this;
            synchronized (hdlUdpRequestHandler) {
                while (!this.isRunning && this.isActive) {
                    try {
                        this.wait();
                        if (this.isRunning) continue;
                        this.main.logError(75, "hdl-udp error: invalid handler thread state");
                    }
                    catch (Exception e) {
                        this.main.logError(75, String.valueOf(this.getClass()) + "Got exception: " + e);
                    }
                }
                if (!this.isActive) continue;
            }
            try {
                pktLen = this.packet.getLength();
                pkt = this.packet.getData();
                Encoder.decodeEnvelope(pkt, this.envelope);
                if (this.envelope.messageLength > 262144 || this.envelope.messageLength < 0) {
                    this.handleResponse(new ErrorResponse(0, 2, MSG_MESSAGE_TOO_LONG));
                    continue;
                }
                if (this.envelope.truncated) {
                    HdlUdpPendingRequest req = this.listener.addMultiPacketListener(this.envelope, this.packet, this.packet.getAddress(), this);
                    if (req == null) continue;
                    pkt = req.getMessage();
                    offset = 0;
                }
                this.currentRequest = (AbstractRequest)Encoder.decodeMessage(pkt, offset, this.envelope);
                String errMsg = this.listener.canProcessMsg(this.currentRequest);
                if (errMsg != null) {
                    this.main.logError(75, errMsg);
                    this.handleResponse(new ErrorResponse(this.currentRequest.opCode, 4, Util.encodeString(errMsg)));
                    return;
                }
                this.server.processRequest(this.currentRequest, this);
            }
            catch (Throwable e) {
                this.main.logError(75, String.valueOf(this.getClass()) + ": Exception processing request: " + e);
            }
            finally {
                this.handlerPool.returnHandler(this);
            }
        }
    }

    public void handleResponseError(String error) {
        this.main.logError(50, String.valueOf(this.getClass()) + ": Server error: " + error);
    }

    public void handleResponse(AbstractResponse response) {
        try {
            byte[] msg = response.getEncodedMessage();
            boolean encrypted = false;
            if (response.encrypt && response.sessionId > 0) {
                ServerSideSessionInfo sssinfo = null;
                if (this.server instanceof HandleServer) {
                    sssinfo = ((HandleServer)this.server).getSession(response.sessionId);
                    if (sssinfo != null && sssinfo.lastRequestId > 0) {
                        try {
                            msg = AbstractMessage.encryptMessage(msg, sssinfo.getSessionKey());
                            encrypted = true;
                        }
                        catch (Exception e) {
                            this.main.logError(50, "Exception encrypting response: " + e);
                            System.err.println("Exception encrypting message with session key: " + e.getMessage());
                            encrypted = false;
                        }
                    }
                } else {
                    this.main.logError(50, "Session manager not available. Message not encrypted.");
                    System.err.println("Session manager not available. Message not encrypted.");
                    encrypted = false;
                }
            }
            this.envelope.encrypted = encrypted;
            this.envelope.messageLength = msg.length;
            this.envelope.messageId = 0;
            this.envelope.sessionId = response.sessionId;
            this.envelope.protocolMajorVersion = response.majorProtocolVersion;
            this.envelope.protocolMinorVersion = response.minorProtocolVersion;
            if (msg.length > 492) {
                int bytesRemaining = msg.length;
                while (bytesRemaining > 0) {
                    byte[] buf;
                    if (bytesRemaining <= 492) {
                        buf = new byte[bytesRemaining + 20];
                        System.arraycopy(msg, msg.length - bytesRemaining, buf, 20, bytesRemaining);
                    } else {
                        buf = new byte[512];
                        System.arraycopy(msg, msg.length - bytesRemaining, buf, 20, 492);
                    }
                    Encoder.encodeEnvelope(this.envelope, buf);
                    this.dsocket.send(new DatagramPacket(buf, buf.length, this.packet.getAddress(), this.packet.getPort()));
                    bytesRemaining -= 492;
                    ++this.envelope.messageId;
                }
            } else {
                byte[] buf = new byte[msg.length + 20];
                Encoder.encodeEnvelope(this.envelope, buf);
                System.arraycopy(msg, 0, buf, 20, msg.length);
                this.dsocket.send(new DatagramPacket(buf, buf.length, this.packet.getAddress(), this.packet.getPort()));
            }
        }
        catch (Exception e) {
            this.main.logError(75, String.valueOf(this.getClass()) + ": Exception sending response: " + e);
            e.printStackTrace(System.err);
        }
        if (this.logAccesses) {
            long time = System.currentTimeMillis() - this.recvTime;
            this.main.logAccess(ACCESS_TYPE, this.packet.getAddress(), this.currentRequest.opCode, response != null ? response.responseCode : 2, Util.decodeString(this.currentRequest.handle), time);
        }
    }
}

