/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ScanCallback;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import net.handle.util.StreamTable;
import net.handle.util.StringUtils;

public class SQLHandleStorage
implements HandleStorage {
    private static final String SQL_URL = "sql_url";
    private static final String SQL_LOGIN = "sql_login";
    private static final String SQL_PASSWD = "sql_passwd";
    private static final String SQL_DRIVER_CLASS = "sql_driver";
    private static final String SQL_READ_ONLY = "sql_read_only";
    private static final long CONN_LIFE_TIME = 21600000L;
    private static final long MAX_OPS_PER_CONN = 500L;
    private Connection sqlConnection = null;
    private String databaseURL;
    private String username;
    private String passwd;
    private boolean readOnly = true;
    private boolean compensateForOracleJDBCBug = false;
    private long lastConnectTime = 0L;
    private long numOperations = 0L;
    private PreparedStatement haveNAStatement = null;
    private PreparedStatement addNAStatement = null;
    private PreparedStatement delNAStatement = null;
    private PreparedStatement addHasNAStatement = null;
    private PreparedStatement createHandleStatement = null;
    private PreparedStatement getHandleStatement = null;
    private PreparedStatement handleExistsStatement = null;
    private PreparedStatement deleteHandleStatement = null;
    private PreparedStatement modifyValueStatement = null;
    private String HAVE_NA_STMT = "select count(*) from nas where na = ?";
    private String DEL_NA_STMT = "delete from nas where na = ?";
    private String ADD_NA_STMT = "insert into nas ( na ) values ( ? )";
    private String SCAN_HANDLES_STMT = "select distinct handle from handles";
    private String SCAN_BYPREFIX_STMT = "select distinct handle from handles where handle like ?";
    private String SCAN_NAS_STMT = "select distinct na from nas";
    private String DELETE_ALL_HDLS_STMT = "delete from handles";
    private String DELETE_ALL_NAS_STMT = "delete from nas";
    private String CREATE_HDL_STMT = "insert into handles ( handle, idx, type, data, ttl_type, ttl, timestamp, refs, admin_read, admin_write, pub_read, pub_write) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private String GET_HDL_STMT = "select idx, type, data, ttl_type, ttl, timestamp, refs, admin_read, admin_write, pub_read, pub_write from handles where handle = ?";
    private String HDL_EXISTS_STMT = "select count(*) from handles where handle = ?";
    private String DELETE_HDL_STMT = "delete from handles where handle = ?";
    private String MOD_VALUE_STMT = "update handles set type = ?, data = ?, ttl_type = ?, ttl = ?, timestamp = ?, refs = ?, admin_read = ?, admin_write = ?, pub_read = ?, pub_write = ? where handle = ? and idx = ?";
    private static final String CFG_HAVE_NA_STMT = "have_na_stmt";
    private static final String CFG_DEL_NA_STMT = "del_na_stmt";
    private static final String CFG_ADD_NA_STMT = "add_na_stmt";
    private static final String CFG_SCAN_HANDLES_STMT = "scan_handles_stmt";
    private static final String CFG_SCAN_BYPREFIX_STMT = "scan_by_prefix_stmt";
    private static final String CFG_SCAN_NAS_STMT = "scan_nas_stmt";
    private static final String CFG_DELETE_ALL_HDLS_STMT = "delete_all_handles_stmt";
    private static final String CFG_DELETE_ALL_NAS_STMT = "delete_all_nas_stmt";
    private static final String CFG_CREATE_HDL_STMT = "create_handle_stmt";
    private static final String CFG_GET_HDL_STMT = "get_handle_stmt";
    private static final String CFG_HDL_EXISTS_STMT = "handle_exists_stmt";
    private static final String CFG_DELETE_HDL_STMT = "delete_handle_stmt";
    private static final String CFG_MOD_VALUE_STMT = "modify_value_stmt";
    private static final String CFG_FIX_ORACLE_BUG = "compensate_for_oracle_jdbc_bug";
    private static final char[] HEX_VALUES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public void init(StreamTable config) throws Exception {
        if (config.containsKey(SQL_DRIVER_CLASS)) {
            Class.forName(String.valueOf(config.get(SQL_DRIVER_CLASS)));
        }
        this.databaseURL = (String)config.get(SQL_URL);
        this.username = (String)config.get(SQL_LOGIN);
        this.passwd = (String)config.get(SQL_PASSWD);
        this.readOnly = config.getBoolean(SQL_READ_ONLY, false);
        this.compensateForOracleJDBCBug = config.getBoolean(CFG_FIX_ORACLE_BUG, false);
        this.HAVE_NA_STMT = config.getStr(CFG_HAVE_NA_STMT, this.HAVE_NA_STMT);
        this.DEL_NA_STMT = config.getStr(CFG_DEL_NA_STMT, this.DEL_NA_STMT);
        this.ADD_NA_STMT = config.getStr(CFG_ADD_NA_STMT, this.ADD_NA_STMT);
        this.SCAN_HANDLES_STMT = config.getStr(CFG_SCAN_HANDLES_STMT, this.SCAN_HANDLES_STMT);
        this.SCAN_BYPREFIX_STMT = config.getStr(CFG_SCAN_BYPREFIX_STMT, this.SCAN_BYPREFIX_STMT);
        this.SCAN_NAS_STMT = config.getStr(CFG_SCAN_NAS_STMT, this.SCAN_NAS_STMT);
        this.DELETE_ALL_HDLS_STMT = config.getStr(CFG_DELETE_ALL_HDLS_STMT, this.DELETE_ALL_HDLS_STMT);
        this.DELETE_ALL_NAS_STMT = config.getStr(CFG_DELETE_ALL_NAS_STMT, this.DELETE_ALL_NAS_STMT);
        this.CREATE_HDL_STMT = config.getStr(CFG_CREATE_HDL_STMT, this.CREATE_HDL_STMT);
        this.GET_HDL_STMT = config.getStr(CFG_GET_HDL_STMT, this.GET_HDL_STMT);
        this.HDL_EXISTS_STMT = config.getStr(CFG_HDL_EXISTS_STMT, this.HDL_EXISTS_STMT);
        this.DELETE_HDL_STMT = config.getStr(CFG_DELETE_HDL_STMT, this.DELETE_HDL_STMT);
        this.MOD_VALUE_STMT = config.getStr(CFG_MOD_VALUE_STMT, this.MOD_VALUE_STMT);
        this.getConnection();
    }

    private synchronized Connection getConnection() throws HandleException {
        long now = System.currentTimeMillis();
        if (this.sqlConnection != null && (this.lastConnectTime < now - 21600000L || this.numOperations > 500L)) {
            Connection oldConnection = this.sqlConnection;
            try {
                this.sqlConnection = null;
                oldConnection.close();
            }
            catch (Exception e) {
                System.err.println("Error resetting old connection: " + e);
                e.printStackTrace(System.err);
            }
        }
        try {
            if (this.sqlConnection != null && !this.sqlConnection.isClosed()) {
                return this.sqlConnection;
            }
        }
        catch (SQLException e) {
            System.err.println(e);
            e.printStackTrace(System.err);
        }
        if (this.sqlConnection != null) {
            try {
                this.sqlConnection.close();
            }
            catch (Throwable t) {
                System.err.println("Error cleaning up SQL connection: " + t);
                t.printStackTrace(System.err);
            }
            this.sqlConnection = null;
        }
        try {
            this.sqlConnection = DriverManager.getConnection(this.databaseURL, this.username, this.passwd);
            this.lastConnectTime = now;
            this.numOperations = 0L;
            this.haveNAStatement = this.sqlConnection.prepareStatement(this.HAVE_NA_STMT);
            this.delNAStatement = this.sqlConnection.prepareStatement(this.DEL_NA_STMT);
            this.addNAStatement = this.sqlConnection.prepareStatement(this.ADD_NA_STMT);
            this.createHandleStatement = this.sqlConnection.prepareStatement(this.CREATE_HDL_STMT);
            this.getHandleStatement = this.sqlConnection.prepareStatement(this.GET_HDL_STMT);
            this.handleExistsStatement = this.sqlConnection.prepareStatement(this.HDL_EXISTS_STMT);
            this.deleteHandleStatement = this.sqlConnection.prepareStatement(this.DELETE_HDL_STMT);
            this.modifyValueStatement = this.sqlConnection.prepareStatement(this.MOD_VALUE_STMT);
        }
        catch (SQLException e) {
            SQLException origE = e;
            while (e != null) {
                System.err.println("Got SQL Exception " + e);
                e = e.getNextException();
            }
            throw new HandleException(1, "Error connecting: " + origE);
        }
        catch (Exception e) {
            throw new HandleException(1, "Unable to setup sql connection: " + e);
        }
        return this.sqlConnection;
    }

    public synchronized boolean haveNA(byte[] authHandle) throws HandleException {
        Connection sql = this.getConnection();
        ResultSet results = null;
        try {
            authHandle = Util.upperCase(authHandle);
            this.haveNAStatement.setBytes(1, authHandle);
            results = this.haveNAStatement.executeQuery();
            ++this.numOperations;
            if (results.next()) {
                boolean bl = results.getInt(1) > 0;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.sqlConnection = null;
            throw new HandleException(1, "Error accessing NA data: " + e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    public synchronized void setHaveNA(byte[] authHandle, boolean flag) throws HandleException {
        if (this.readOnly) {
            throw new HandleException(18, "Server is read-only");
        }
        this.getConnection();
        boolean currentlyHaveIt = this.haveNA(authHandle);
        if (currentlyHaveIt == flag) {
            return;
        }
        try {
            authHandle = Util.upperCase(authHandle);
            if (currentlyHaveIt) {
                this.delNAStatement.setBytes(1, authHandle);
                int result = this.delNAStatement.executeUpdate();
            } else {
                this.addNAStatement.setBytes(1, authHandle);
                int result = this.addNAStatement.executeUpdate();
            }
            ++this.numOperations;
        }
        catch (Exception e) {
            this.sqlConnection = null;
            throw new HandleException(1, "Error accessing NA data: " + e);
        }
    }

    private synchronized boolean handleExists(byte[] handle) throws HandleException {
        ResultSet results = null;
        try {
            this.handleExistsStatement.setBytes(1, handle);
            results = this.handleExistsStatement.executeQuery();
            if (results.next() && results.getInt(1) > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.sqlConnection = null;
            throw new HandleException(1, "Error checking for existing handle: " + e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    private byte[] getByteData(String str) {
        return Util.encodeString(str);
    }

    private String getStrData(HandleValue val) {
        if (val.hasType(Common.STD_TYPE_URL) || val.hasType(Common.STD_TYPE_EMAIL) || val.hasType(Common.STD_TYPE_URN) || val.hasType(Common.STD_TYPE_HSSERV) || val.hasType(Common.STD_TYPE_HOSTNAME)) {
            return Util.decodeString(val.getData());
        }
        return SQLHandleStorage.encodeString(Util.decodeString(val.getData()));
    }

    public static final String encodeString(String str) {
        int len = str.length();
        StringBuffer sb = new StringBuffer(len + 4);
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch >= '\u007f' || ch < ' ' || ch == '%') {
                sb.append('%');
                sb.append(HEX_VALUES[ch >> 12 & 0xF]);
                sb.append(HEX_VALUES[ch >> 8 & 0xF]);
                sb.append(HEX_VALUES[ch >> 4 & 0xF]);
                sb.append(HEX_VALUES[ch & 0xF]);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static final char decodeChar(char ch1, char ch2, char ch3, char ch4) {
        int ich3;
        int ich2;
        int ich1;
        int n = ch1 >= 'a' ? ch1 - 97 + 10 : (ich1 = ch1 >= 'A' ? ch1 - 65 + 10 : ch1 - 48);
        int n2 = ch2 >= 'a' ? ch2 - 97 + 10 : (ich2 = ch2 >= 'A' ? ch2 - 65 + 10 : ch2 - 48);
        int n3 = ch3 >= 'a' ? ch3 - 97 + 10 : (ich3 = ch3 >= 'A' ? ch3 - 65 + 10 : ch3 - 48);
        int ich4 = ch4 >= 'a' ? ch4 - 97 + 10 : (ch4 >= 'A' ? ch4 - 65 + 10 : ch4 - 48);
        return (char)(ich1 << 12 | ich2 << 8 | ich3 << 4 | ich4);
    }

    public static final String decodeString(String str) {
        int len = str.length();
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '%' && i < len - 4) {
                char encCh1 = str.charAt(++i);
                char encCh2 = str.charAt(++i);
                char encCh3 = str.charAt(++i);
                char encCh4 = str.charAt(++i);
                sb.append(SQLHandleStorage.decodeChar(encCh1, encCh2, encCh3, encCh4));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void createHandle(byte[] handle, HandleValue[] values) throws HandleException {
        if (this.readOnly) {
            throw new HandleException(18, "Server is read-only");
        }
        this.getConnection();
        String handleStr = Util.decodeString(handle);
        if (this.handleExists(handle)) {
            throw new HandleException(5, handleStr);
        }
        if (values == null) {
            throw new HandleException(0);
        }
        boolean success = false;
        Throwable e = null;
        try {
            this.sqlConnection.setAutoCommit(false);
            for (int i = 0; i < values.length; ++i) {
                HandleValue val = values[i];
                this.createHandleStatement.setBytes(1, handle);
                this.createHandleStatement.setInt(2, val.getIndex());
                this.createHandleStatement.setBytes(3, val.getType());
                this.createHandleStatement.setBytes(4, val.getData());
                this.createHandleStatement.setByte(5, val.getTTLType());
                this.createHandleStatement.setInt(6, val.getTTL());
                this.createHandleStatement.setInt(7, val.getTimestamp());
                StringBuffer sb = new StringBuffer();
                ValueReference[] refs = val.getReferences();
                for (int rv = 0; refs != null && rv < refs.length; ++rv) {
                    if (rv != 0) {
                        sb.append('\t');
                    }
                    sb.append(refs[rv].index);
                    sb.append(':');
                    sb.append(StringUtils.encode(Util.decodeString(refs[rv].handle)));
                }
                this.createHandleStatement.setString(8, SQLHandleStorage.encodeString(sb.toString()));
                this.createHandleStatement.setBoolean(9, val.getAdminCanRead());
                this.createHandleStatement.setBoolean(10, val.getAdminCanWrite());
                this.createHandleStatement.setBoolean(11, val.getAnyoneCanRead());
                this.createHandleStatement.setBoolean(12, val.getAnyoneCanWrite());
                this.createHandleStatement.executeUpdate();
            }
            success = true;
        }
        catch (Exception sqlExc) {
            e = sqlExc;
        }
        finally {
            try {
                if (success) {
                    this.sqlConnection.commit();
                } else {
                    this.sqlConnection.rollback();
                }
            }
            catch (Throwable t) {
                e = t;
            }
            finally {
                block47: {
                    try {
                        this.sqlConnection.setAutoCommit(true);
                    }
                    catch (Throwable t2) {
                        if (e == null) break block47;
                        e = t2;
                    }
                }
            }
        }
        ++this.numOperations;
        if (e != null) {
            this.sqlConnection = null;
            e.printStackTrace(System.err);
            throw new HandleException(1, "Error creating handle: " + e);
        }
    }

    public synchronized boolean deleteHandle(byte[] handle) throws HandleException {
        boolean deleted;
        if (this.readOnly) {
            throw new HandleException(18, "Server is read-only");
        }
        this.getConnection();
        try {
            this.deleteHandleStatement.setBytes(1, handle);
            deleted = this.deleteHandleStatement.executeUpdate() > 0;
            ++this.numOperations;
        }
        catch (Exception e) {
            this.sqlConnection = null;
            throw new HandleException(1, "Error deleting handle");
        }
        return deleted;
    }

    public synchronized byte[][] getRawHandleValues(byte[] handle, int[] indexList, byte[][] typeList) throws HandleException {
        this.getConnection();
        ResultSet results = null;
        try {
            this.getHandleStatement.setBytes(1, handle);
            results = this.getHandleStatement.executeQuery();
            boolean allValues = !(typeList != null && typeList.length != 0 || indexList != null && indexList.length != 0);
            Vector<HandleValue> values = new Vector<HandleValue>();
            while (results.next()) {
                HandleValue value = new HandleValue();
                value.setIndex(results.getInt(1));
                value.setType(this.getBytesFromResults(results, 2));
                if (!allValues && !Util.isParentTypeInArray(typeList, value.getType()) && !Util.isInArray(indexList, value.getIndex())) continue;
                value.setData(this.getBytesFromResults(results, 3));
                value.setTTLType(results.getByte(4));
                value.setTTL(results.getInt(5));
                value.setTimestamp(results.getInt(6));
                String referencesStr = this.getStringFromResults(results, 7);
                String[] references = StringUtils.split(referencesStr, '\t');
                if (references != null && referencesStr.length() > 0 && references.length > 0) {
                    ValueReference[] valReferences = new ValueReference[references.length];
                    for (int i = 0; i < references.length; ++i) {
                        valReferences[i] = new ValueReference();
                        int colIdx = references[i].indexOf(58);
                        try {
                            valReferences[i].index = Integer.parseInt(references[i].substring(0, colIdx));
                        }
                        catch (Exception t) {
                            // empty catch block
                        }
                        valReferences[i].handle = Util.encodeString(StringUtils.decode(references[i].substring(colIdx + 1)));
                    }
                    value.setReferences(valReferences);
                }
                value.setAdminCanRead(results.getBoolean(8));
                value.setAdminCanWrite(results.getBoolean(9));
                value.setAnyoneCanRead(results.getBoolean(10));
                value.setAnyoneCanWrite(results.getBoolean(11));
                values.addElement(value);
            }
            ++this.numOperations;
            if (values.size() <= 0) {
                return null;
            }
            byte[][] rawValues = new byte[values.size()][];
            for (int i = 0; i < rawValues.length; ++i) {
                HandleValue value = (HandleValue)values.elementAt(i);
                rawValues[i] = new byte[Encoder.calcStorageSize(value)];
                Encoder.encodeHandleValue(rawValues[i], 0, value);
            }
            return rawValues;
        }
        catch (Exception e) {
            this.sqlConnection = null;
            e.printStackTrace();
            throw new HandleException(1, "Error retrieving handle");
        }
    }

    public synchronized void updateValue(byte[] handle, HandleValue[] values) throws HandleException {
        if (this.readOnly) {
            throw new HandleException(18, "Server is read-only");
        }
        if (!this.handleExists(handle)) {
            throw new HandleException(9);
        }
        boolean success = false;
        Exception e = null;
        try {
            this.deleteHandle(handle);
            this.createHandle(handle, values);
        }
        catch (Exception sqlExc) {
            e = sqlExc;
        }
        if (e != null) {
            throw new HandleException(1, "Error updating values: " + e);
        }
    }

    public void addValues(byte[] handle, HandleValue[] values) throws HandleException {
        if (this.readOnly) {
            throw new HandleException(18, "Server is read-only");
        }
        throw new HandleException(1, "Not implemented yet!!");
    }

    public void removeValues(byte[] handle, byte[][] typeList, int[] indexList) throws HandleException {
        if (this.readOnly) {
            throw new HandleException(18, "Server is read-only");
        }
        throw new HandleException(1, "Not implemented yet!!");
    }

    public void scanHandles(ScanCallback callback) throws HandleException {
        this.getConnection();
        PreparedStatement scanStatement = null;
        ResultSet results = null;
        try {
            scanStatement = this.sqlConnection.prepareStatement(this.SCAN_HANDLES_STMT);
            results = scanStatement.executeQuery();
            while (results.next()) {
                byte[] b = this.getBytesFromResults(results, 1);
                callback.scanHandle(b);
            }
            ++this.numOperations;
        }
        catch (SQLException e) {
            this.sqlConnection = null;
            throw new HandleException(1, "SQL Error: " + e);
        }
        finally {
            if (scanStatement != null) {
                try {
                    scanStatement.close();
                }
                catch (Throwable e) {}
            }
            if (results != null) {
                try {
                    results.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    public void scanNAs(ScanCallback callback) throws HandleException {
        this.getConnection();
        PreparedStatement scanStatement = null;
        ResultSet results = null;
        try {
            scanStatement = this.sqlConnection.prepareStatement(this.SCAN_NAS_STMT);
            results = scanStatement.executeQuery();
            while (results.next()) {
                byte[] b = this.getBytesFromResults(results, 1);
                callback.scanHandle(b);
            }
            ++this.numOperations;
        }
        catch (SQLException e) {
            this.sqlConnection = null;
            throw new HandleException(1, "SQL Error: " + e);
        }
        finally {
            if (scanStatement != null) {
                try {
                    scanStatement.close();
                }
                catch (Throwable e) {}
            }
            if (results != null) {
                try {
                    results.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    public final Enumeration getHandlesForNA(byte[] naHdl) throws HandleException {
        if (!this.haveNA(naHdl)) {
            throw new HandleException(0, "The requested naming authority doesn't live here");
        }
        return new ListHdlsEnum(Util.getIDPart(naHdl));
    }

    public synchronized void deleteAllRecords() throws HandleException {
        if (this.readOnly) {
            throw new HandleException(18, "Server is read-only");
        }
    }

    public void checkpointDatabase() throws HandleException {
        throw new HandleException(15, "Checkpoint not supported in this storage type");
    }

    public synchronized void shutdown() {
        if (this.sqlConnection != null) {
            try {
                this.sqlConnection.close();
                this.sqlConnection = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private final String getStringFromResults(ResultSet results, int i) throws SQLException {
        String s = results.getString(i);
        return s == null ? "" : SQLHandleStorage.decodeString(s);
    }

    private final byte[] getBytesFromResults(ResultSet results, int i) throws SQLException {
        if (this.compensateForOracleJDBCBug) {
            String s = results.getString(i);
            if (s == null) {
                return new byte[0];
            }
            return Util.encodeHexString(s);
        }
        byte[] b = results.getBytes(i);
        return b == null ? new byte[]{} : b;
    }

    private class ListHdlsEnum
    implements Enumeration {
        private ResultSet results = null;
        private PreparedStatement scanStatement = null;
        private byte[] nextVal = null;

        ListHdlsEnum(byte[] prefix) throws HandleException {
            try {
                SQLHandleStorage.this.getConnection();
                this.scanStatement = SQLHandleStorage.this.sqlConnection.prepareStatement(SQLHandleStorage.this.SCAN_BYPREFIX_STMT);
                this.scanStatement.setBytes(1, Util.encodeString(Util.decodeString(prefix) + "/%"));
                this.results = this.scanStatement.executeQuery();
            }
            catch (SQLException e) {
                throw new HandleException(1, "SQL Error: " + e);
            }
            this.getNextValue();
        }

        public boolean hasMoreElements() {
            return this.nextVal != null;
        }

        public Object nextElement() {
            byte[] returnVal = this.nextVal;
            if (returnVal != null) {
                this.getNextValue();
            }
            return returnVal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getNextValue() {
            block15: {
                if (this.results == null) {
                    return;
                }
                try {
                    if (this.results.next()) {
                        this.nextVal = SQLHandleStorage.this.getBytesFromResults(this.results, 1);
                        break block15;
                    }
                    if (this.scanStatement != null) {
                        try {
                            this.scanStatement.close();
                            this.scanStatement = null;
                        }
                        catch (Throwable t) {
                            System.err.println("Error closing SQL statement: " + t);
                        }
                        finally {
                            this.scanStatement = null;
                        }
                    }
                    if (this.results == null) break block15;
                    try {
                        this.results.close();
                    }
                    catch (Throwable t) {
                        System.err.println("Error closing SQL result set: " + t);
                    }
                    finally {
                        this.results = null;
                    }
                }
                catch (Exception e) {
                    System.err.println("Error retrieving handles: " + e);
                    e.printStackTrace(System.err);
                }
            }
        }
    }
}

