/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.FileOutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import net.handle.hdllib.Util;

public class ServerKeyGenerator {
    private static final void printUsage() {
        System.err.println("usage: java net.handle.server.ServerKeyGenerator <algorithm> [<provider>] <publickeyfile> <privatekeyfile> <strength#>");
    }

    public static void main(String[] argv) throws Exception {
        int i;
        if (argv.length < 4) {
            ServerKeyGenerator.printUsage();
            System.exit(1);
        }
        int argN = 0;
        String alg = argv[argN++];
        String provider = null;
        if (argv.length > 4) {
            provider = argv[argN++];
        }
        String pubKeyFile = argv[argN++];
        String privKeyFile = argv[argN++];
        String strengthStr = argv[argN++];
        int strength = Integer.parseInt(strengthStr);
        KeyPairGenerator kpg = null;
        kpg = provider == null ? KeyPairGenerator.getInstance(alg) : KeyPairGenerator.getInstance(alg, provider);
        System.err.print("initializing KeyPairGenerator... ");
        kpg.initialize(strength);
        System.err.println("done");
        System.err.print("Generating KeyPair...  ");
        KeyPair keys = kpg.generateKeyPair();
        System.err.println("done");
        byte[] secKey = Util.getPassphrase("Please enter the private key passphrase: ");
        byte[] secKey2 = Util.getPassphrase("Please re-enter the private key passphrase: ");
        if (!Util.equals(secKey, secKey2)) {
            System.err.println("Passphrases do not match!  Keys not saved.");
            return;
        }
        PrivateKey priv = keys.getPrivate();
        byte[] keyBytes = Util.getBytesFromPrivateKey((DSAPrivateKey)priv);
        FileOutputStream dbgOut = new FileOutputStream("./privkey.clear");
        dbgOut.write(keyBytes);
        dbgOut.close();
        byte[] encKeyBytes = secKey == null || secKey.length <= 0 ? Util.encrypt(keyBytes, secKey, 1) : Util.encryptIfPossible(keyBytes, secKey);
        for (i = 0; i < keyBytes.length; ++i) {
            keyBytes[i] = 0;
        }
        for (i = 0; i < secKey.length; ++i) {
            secKey[i] = 0;
        }
        FileOutputStream out = new FileOutputStream(privKeyFile);
        out.write(encKeyBytes);
        try {
            out.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        System.out.println("saved private key to " + privKeyFile);
        PublicKey pub = keys.getPublic();
        out = new FileOutputStream(pubKeyFile);
        out.write(Util.getBytesFromPublicKey((DSAPublicKey)pub));
        try {
            out.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        System.out.println("saved public key to " + pubKeyFile);
    }
}

