/*
 * Decompiled with CFR 0.152.
 */
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import edu.sdsc.grid.io.srb.SRBShadowFile;
import java.net.URI;

public class ShadowFileTest {
    SRBAccount account = null;
    SRBFileSystem fileSystem = null;
    GeneralFile file = null;
    SRBShadowFile shadow = null;

    ShadowFileTest() throws Throwable {
        this(new String[0]);
    }

    public ShadowFileTest(GeneralFile generalFile, String string) throws Throwable {
        if (generalFile != null) {
            this.file = generalFile;
            this.fileSystem = (SRBFileSystem)generalFile.getFileSystem();
        } else {
            this.fileSystem = new SRBFileSystem();
            generalFile = new SRBFile(this.fileSystem, this.fileSystem.getHomeDirectory());
        }
        this.shadow = new SRBShadowFile((SRBFile)generalFile, string);
        this.run();
    }

    ShadowFileTest(String[] stringArray) throws Throwable {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Wrong number of arguments sent to Test.");
        }
        this.file = new SRBFile(new URI(stringArray[0]));
        this.fileSystem = (SRBFileSystem)this.file.getFileSystem();
        this.shadow = new SRBShadowFile((SRBFile)this.file, stringArray[1]);
        this.run();
    }

    private void run() throws Throwable {
        System.out.println("\n List the shadow directory.");
        String[] stringArray = this.shadow.list();
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                System.out.println(stringArray[n]);
                ++n;
            }
            this.shadow = new SRBShadowFile(this.shadow, stringArray[0]);
        }
        System.out.println("\n Read from a shadow file.");
        System.out.println(this.shadow.read());
        System.out.println(this.shadow.read());
        System.out.println(this.shadow.read());
        System.out.println(this.shadow.read());
        System.out.println(this.shadow.read());
        System.out.println(this.shadow.read());
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        try {
            ShadowFileTest shadowFileTest = new ShadowFileTest(stringArray);
        }
        catch (Throwable throwable) {
            System.out.println("\nJava Error Message: " + throwable.toString());
            throwable.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

